/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.catalog.types;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.derby.catalog.TypeDescriptor;
import org.apache.derby.catalog.types.BaseTypeIdImpl;
import org.apache.derby.catalog.types.TypeDescriptorImpl;
import org.apache.derby.shared.common.util.ArrayUtil;

public class RowMultiSetImpl
extends BaseTypeIdImpl {
    private String[] _columnNames;
    private TypeDescriptor[] _types;

    public RowMultiSetImpl() {
    }

    public RowMultiSetImpl(String[] columnNames, TypeDescriptor[] types) {
        this._columnNames = (String[])ArrayUtil.copy((Object[])columnNames);
        this.setTypes(types);
        if (columnNames == null || types == null || columnNames.length != types.length) {
            throw new IllegalArgumentException("Bad args: columnNames = " + columnNames + ". types = " + types);
        }
    }

    public String[] getColumnNames() {
        return (String[])ArrayUtil.copy((Object[])this._columnNames);
    }

    public TypeDescriptor[] getTypes() {
        return TypeDescriptorImpl.copyTypeDescriptors(this._types);
    }

    public void setTypes(TypeDescriptor[] types) {
        this._types = TypeDescriptorImpl.copyTypeDescriptors(types);
    }

    @Override
    public String getSQLTypeName() {
        StringBuffer buffer = new StringBuffer();
        int count = this._columnNames.length;
        buffer.append("TABLE ( ");
        for (int i = 0; i < count; ++i) {
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append('\"');
            buffer.append(this._columnNames[i]);
            buffer.append('\"');
            buffer.append(' ');
            buffer.append(this._types[i].getSQLstring());
        }
        buffer.append(" )");
        return buffer.toString();
    }

    @Override
    public int getJDBCTypeId() {
        return 1111;
    }

    @Override
    public int getTypeFormatId() {
        return 469;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int i;
        int count = in.readInt();
        this._columnNames = new String[count];
        this._types = new TypeDescriptor[count];
        for (i = 0; i < count; ++i) {
            this._columnNames[i] = in.readUTF();
        }
        for (i = 0; i < count; ++i) {
            this._types[i] = (TypeDescriptor)in.readObject();
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        int i;
        int count = this._columnNames.length;
        out.writeInt(count);
        for (i = 0; i < count; ++i) {
            out.writeUTF(this._columnNames[i]);
        }
        for (i = 0; i < count; ++i) {
            out.writeObject(this._types[i]);
        }
    }
}

