/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor.bcextensions;

import io.quarkus.arc.processor.bcextensions.AllAnnotationOverlays;
import io.quarkus.arc.processor.bcextensions.AnnotationBuilderImpl;
import io.quarkus.arc.processor.bcextensions.ClassInfoImpl;
import jakarta.enterprise.inject.build.compatible.spi.AnnotationBuilder;
import jakarta.enterprise.inject.build.compatible.spi.AnnotationBuilderFactory;
import jakarta.enterprise.lang.model.declarations.ClassInfo;
import java.lang.annotation.Annotation;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;

final class AnnotationBuilderFactoryImpl
implements AnnotationBuilderFactory {
    private final IndexView beanArchiveIndex;
    private final AllAnnotationOverlays annotationOverlays;

    AnnotationBuilderFactoryImpl(IndexView beanArchiveIndex, AllAnnotationOverlays annotationOverlays) {
        this.beanArchiveIndex = beanArchiveIndex;
        this.annotationOverlays = annotationOverlays;
    }

    public AnnotationBuilder create(Class<? extends Annotation> annotationType) {
        if (this.beanArchiveIndex == null || this.annotationOverlays == null) {
            throw new IllegalStateException("Can't create AnnotationBuilder right now");
        }
        DotName jandexAnnotationName = DotName.createSimple((String)annotationType.getName());
        return new AnnotationBuilderImpl(this.beanArchiveIndex, this.annotationOverlays, jandexAnnotationName);
    }

    public AnnotationBuilder create(ClassInfo annotationType) {
        if (this.beanArchiveIndex == null || this.annotationOverlays == null) {
            throw new IllegalStateException("Can't create AnnotationBuilder right now");
        }
        DotName jandexAnnotationName = ((org.jboss.jandex.ClassInfo)((ClassInfoImpl)annotationType).jandexDeclaration).name();
        return new AnnotationBuilderImpl(this.beanArchiveIndex, this.annotationOverlays, jandexAnnotationName);
    }
}

