/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.jicofo.xmpp;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.jicofo.ConferenceStore;
import org.jitsi.jicofo.TaskPools;
import org.jitsi.jicofo.conference.JitsiMeetConference;
import org.jitsi.jicofo.xmpp.AvModerationHandlerKt;
import org.jitsi.jicofo.xmpp.XmppProvider;
import org.jitsi.jicofo.xmpp.muc.ChatRoom;
import org.jitsi.utils.MediaType;
import org.jitsi.utils.OrderedJsonObject;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerExtensionsKt;
import org.jitsi.xmpp.extensions.jitsimeet.JsonMessageExtension;
import org.jivesoftware.smack.StanzaListener;
import org.jivesoftware.smack.filter.MessageTypeFilter;
import org.jivesoftware.smack.packet.Stanza;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.jxmpp.jid.DomainBareJid;
import org.jxmpp.jid.EntityBareJid;
import org.jxmpp.jid.impl.JidCreate;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0016\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0016J\u0010\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0006\u0010\u0018\u001a\u00020\u0011R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jitsi/jicofo/xmpp/AvModerationHandler;", "Lorg/jitsi/jicofo/xmpp/XmppProvider$Listener;", "Lorg/jivesoftware/smack/StanzaListener;", "xmppProvider", "Lorg/jitsi/jicofo/xmpp/XmppProvider;", "conferenceStore", "Lorg/jitsi/jicofo/ConferenceStore;", "(Lorg/jitsi/jicofo/xmpp/XmppProvider;Lorg/jitsi/jicofo/ConferenceStore;)V", "avModerationAddress", "Lorg/jxmpp/jid/DomainBareJid;", "debugState", "Lorg/jitsi/utils/OrderedJsonObject;", "getDebugState", "()Lorg/jitsi/utils/OrderedJsonObject;", "logger", "Lorg/jitsi/utils/logging2/Logger;", "componentsChanged", "", "components", "", "Lorg/jitsi/jicofo/xmpp/XmppProvider$Component;", "processStanza", "stanza", "Lorg/jivesoftware/smack/packet/Stanza;", "shutdown", "jicofo"})
@SourceDebugExtension(value={"SMAP\nAvModerationHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AvModerationHandler.kt\norg/jitsi/jicofo/xmpp/AvModerationHandler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,145:1\n1#2:146\n215#3,2:147\n*S KotlinDebug\n*F\n+ 1 AvModerationHandler.kt\norg/jitsi/jicofo/xmpp/AvModerationHandler\n*L\n97#1:147,2\n*E\n"})
public final class AvModerationHandler
implements XmppProvider.Listener,
StanzaListener {
    @NotNull
    private final XmppProvider xmppProvider;
    @NotNull
    private final ConferenceStore conferenceStore;
    @Nullable
    private DomainBareJid avModerationAddress;
    @NotNull
    private final Logger logger;

    public AvModerationHandler(@NotNull XmppProvider xmppProvider, @NotNull ConferenceStore conferenceStore) {
        Intrinsics.checkNotNullParameter(xmppProvider, "xmppProvider");
        Intrinsics.checkNotNullParameter(conferenceStore, "conferenceStore");
        this.xmppProvider = xmppProvider;
        this.conferenceStore = conferenceStore;
        this.logger = LoggerExtensionsKt.createLogger$default(this, null, null, 3, null);
        this.xmppProvider.getXmppConnection().addSyncStanzaListener(this, MessageTypeFilter.NORMAL);
        this.xmppProvider.addListener(this);
        this.registrationChanged(this.xmppProvider.getRegistered());
        this.componentsChanged(this.xmppProvider.getComponents());
    }

    @NotNull
    public final OrderedJsonObject getDebugState() {
        OrderedJsonObject orderedJsonObject;
        OrderedJsonObject $this$_get_debugState__u24lambda_u240 = orderedJsonObject = new OrderedJsonObject();
        boolean bl = false;
        ((Map)$this$_get_debugState__u24lambda_u240).put("address", String.valueOf(this.avModerationAddress));
        return orderedJsonObject;
    }

    @Override
    public void processStanza(@NotNull Stanza stanza) {
        Intrinsics.checkNotNullParameter(stanza, "stanza");
        if (!Intrinsics.areEqual(stanza.getFrom(), this.avModerationAddress)) {
            return;
        }
        JsonMessageExtension jsonMessageExtension = stanza.getExtension(JsonMessageExtension.class);
        if (jsonMessageExtension == null) {
            Unit unit;
            Unit it = unit = Unit.INSTANCE;
            boolean bl = false;
            this.logger.warn("Skip processing stanza without JsonMessageExtension");
            return;
        }
        JsonMessageExtension jsonMessage = jsonMessageExtension;
        TaskPools.Companion.getIoPool().execute(() -> AvModerationHandler.processStanza$lambda$5(jsonMessage, this, stanza));
    }

    @Override
    public void componentsChanged(@NotNull Set<XmppProvider.Component> components) {
        DomainBareJid domainBareJid;
        String address;
        Object v0;
        block3: {
            Intrinsics.checkNotNullParameter(components, "components");
            Iterable iterable = components;
            for (Object t : iterable) {
                XmppProvider.Component it = (XmppProvider.Component)t;
                boolean bl = false;
                if (!Intrinsics.areEqual(it.getType(), "av_moderation")) continue;
                v0 = t;
                break block3;
            }
            v0 = null;
        }
        XmppProvider.Component component = v0;
        String string = address = component != null ? component.getAddress() : null;
        if (address == null) {
            this.logger.info("No av_moderation component discovered.");
            domainBareJid = null;
        } else {
            this.logger.info("Using av_moderation component at " + address + ".");
            domainBareJid = JidCreate.domainBareFrom(address);
        }
        this.avModerationAddress = domainBareJid;
    }

    public final void shutdown() {
        this.xmppProvider.getXmppConnection().removeSyncStanzaListener(this);
    }

    @Override
    public void registrationChanged(boolean registered) {
        XmppProvider.Listener.DefaultImpls.registrationChanged(this, registered);
    }

    private static final void processStanza$lambda$5(JsonMessageExtension $jsonMessage, AvModerationHandler this$0, Stanza $stanza) {
        block9: {
            Intrinsics.checkNotNullParameter($jsonMessage, "$jsonMessage");
            Intrinsics.checkNotNullParameter(this$0, "this$0");
            Intrinsics.checkNotNullParameter($stanza, "$stanza");
            try {
                Object object = new JSONParser().parse($jsonMessage.getJson());
                Intrinsics.checkNotNull(object, "null cannot be cast to non-null type org.json.simple.JSONObject");
                JSONObject incomingJson = (JSONObject)object;
                if (!Intrinsics.areEqual(incomingJson.get("type"), "av_moderation")) break block9;
                Object v = incomingJson.get("room");
                EntityBareJid conferenceJid = JidCreate.entityBareFrom(v != null ? v.toString() : null);
                ConferenceStore conferenceStore = this$0.conferenceStore;
                Intrinsics.checkNotNull(conferenceJid);
                JitsiMeetConference jitsiMeetConference = conferenceStore.getConference(conferenceJid);
                if (jitsiMeetConference == null) {
                    throw new IllegalStateException("Conference " + conferenceJid + " does not exist.");
                }
                JitsiMeetConference conference = jitsiMeetConference;
                ChatRoom chatRoom = conference.getChatRoom();
                if (chatRoom == null) {
                    throw new IllegalStateException("Conference has no associated chatRoom.");
                }
                ChatRoom chatRoom2 = chatRoom;
                Object v2 = incomingJson.get("enabled");
                if (v2 != null) {
                    Object enabled2 = v2;
                    boolean bl = false;
                    if (!(enabled2 instanceof Boolean)) {
                        throw new IllegalArgumentException("Invalid value for the 'enabled' attribute: " + enabled2);
                    }
                    Object v3 = incomingJson.get("mediaType");
                    Intrinsics.checkNotNull(v3, "null cannot be cast to non-null type kotlin.String");
                    MediaType mediaType = MediaType.parseString((String)v3);
                    Intrinsics.checkNotNull((Object)mediaType);
                    boolean oldEnabledValue = chatRoom2.isAvModerationEnabled(mediaType);
                    chatRoom2.setAvModerationEnabled(mediaType, (Boolean)enabled2);
                    if (!Intrinsics.areEqual(oldEnabledValue, enabled2) && ((Boolean)enabled2).booleanValue()) {
                        this$0.logger.info("Moderation for " + mediaType + " in " + conferenceJid + " was enabled by " + incomingJson.get("actor"));
                        conference.muteAllParticipants(mediaType);
                    }
                }
                Object v4 = incomingJson.get("whitelists");
                if (v4 != null) {
                    Object it = v4;
                    boolean bl = false;
                    Map $this$forEach$iv = AvModerationHandlerKt.access$parseWhitelists(it);
                    boolean $i$f$forEach = false;
                    Iterator iterator2 = $this$forEach$iv.entrySet().iterator();
                    while (iterator2.hasNext()) {
                        Map.Entry element$iv;
                        Map.Entry entry = element$iv = iterator2.next();
                        boolean bl2 = false;
                        MediaType mediaType = (MediaType)((Object)entry.getKey());
                        List whitelist = (List)entry.getValue();
                        chatRoom2.setAvModerationWhitelist(mediaType, whitelist);
                    }
                }
            }
            catch (Exception e) {
                this$0.logger.warn("Failed to process av_moderation request from " + $stanza.getFrom(), e);
            }
        }
    }
}

