/*
 * Decompiled with CFR 0.152.
 */
package org.jd.gui.service.fileloader;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Iterator;
import org.jd.gui.api.API;
import org.jd.gui.service.fileloader.AbstractFileLoaderProvider;
import org.jd.gui.util.exception.ExceptionUtil;

public class ZipFileLoaderProvider
extends AbstractFileLoaderProvider {
    protected static final String[] EXTENSIONS = new String[]{"zip"};

    @Override
    public String[] getExtensions() {
        return EXTENSIONS;
    }

    @Override
    public String getDescription() {
        return "Zip files (*.zip)";
    }

    @Override
    public boolean accept(API api, File file) {
        return file.exists() && file.isFile() && file.canRead() && file.getName().toLowerCase().endsWith(".zip");
    }

    @Override
    public boolean load(API api, File file) {
        block5: {
            try {
                Iterator<Path> rootDirectories;
                FileSystem fileSystem;
                URI fileUri = file.toURI();
                URI uri = new URI("jar:" + fileUri.getScheme(), fileUri.getHost(), fileUri.getPath() + "!/", null);
                try {
                    fileSystem = FileSystems.getFileSystem(uri);
                }
                catch (FileSystemNotFoundException e) {
                    fileSystem = FileSystems.newFileSystem(uri, Collections.emptyMap());
                }
                if (fileSystem != null && (rootDirectories = fileSystem.getRootDirectories().iterator()).hasNext()) {
                    return this.load(api, file, rootDirectories.next()) != null;
                }
            }
            catch (IOException | URISyntaxException e) {
                if ($assertionsDisabled || ExceptionUtil.printStackTrace(e)) break block5;
                throw new AssertionError();
            }
        }
        return false;
    }
}

