/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.resources;

import java.net.URI;
import java.nio.charset.Charset;
import org.gradle.api.InvalidUserCodeException;
import org.gradle.api.internal.file.FileOperations;
import org.gradle.api.internal.file.temp.TemporaryFileProvider;
import org.gradle.api.internal.resources.ApiTextResourceAdapter;
import org.gradle.api.internal.resources.FileCollectionBackedArchiveTextResource;
import org.gradle.api.internal.resources.FileCollectionBackedTextResource;
import org.gradle.api.internal.resources.InsecureProtocolException;
import org.gradle.api.internal.resources.StringBackedTextResource;
import org.gradle.api.internal.tasks.TaskDependencyFactory;
import org.gradle.api.resources.TextResource;
import org.gradle.api.resources.TextResourceFactory;
import org.gradle.internal.deprecation.Documentation;
import org.gradle.internal.verifier.HttpRedirectVerifier;
import org.gradle.internal.verifier.HttpRedirectVerifierFactory;
import org.gradle.util.internal.GUtil;

public class DefaultTextResourceFactory
implements TextResourceFactory {
    private final FileOperations fileOperations;
    private final TemporaryFileProvider tempFileProvider;
    private final TaskDependencyFactory taskDependencyFactory;
    private ApiTextResourceAdapter.Factory apiTextResourcesAdapterFactory;

    public DefaultTextResourceFactory(FileOperations fileOperations, TemporaryFileProvider tempFileProvider, ApiTextResourceAdapter.Factory apiTextResourcesAdapterFactory, TaskDependencyFactory taskDependencyFactory) {
        this.fileOperations = fileOperations;
        this.tempFileProvider = tempFileProvider;
        this.apiTextResourcesAdapterFactory = apiTextResourcesAdapterFactory;
        this.taskDependencyFactory = taskDependencyFactory;
    }

    public TextResource fromString(String string) {
        return new StringBackedTextResource(this.tempFileProvider, string);
    }

    public TextResource fromFile(Object file, String charset) {
        return new FileCollectionBackedTextResource(this.tempFileProvider, this.fileOperations.immutableFiles(file), Charset.forName(charset));
    }

    public TextResource fromFile(Object file) {
        return this.fromFile(file, Charset.defaultCharset().name());
    }

    public TextResource fromArchiveEntry(Object archive, String entryPath, String charset) {
        return new FileCollectionBackedArchiveTextResource(this.fileOperations, this.taskDependencyFactory, this.tempFileProvider, this.fileOperations.immutableFiles(archive), entryPath, Charset.forName(charset));
    }

    public TextResource fromArchiveEntry(Object archive, String entryPath) {
        return this.fromArchiveEntry(archive, entryPath, Charset.defaultCharset().name());
    }

    public TextResource fromUri(Object uri) {
        return this.fromUri(uri, false);
    }

    public TextResource fromInsecureUri(Object uri) {
        return this.fromUri(uri, true);
    }

    private TextResource fromUri(Object uri, boolean allowInsecureProtocol) {
        URI rootUri = this.fileOperations.uri(uri);
        HttpRedirectVerifier redirectVerifier = HttpRedirectVerifierFactory.create((URI)rootUri, (boolean)allowInsecureProtocol, () -> DefaultTextResourceFactory.throwExceptionDueToInsecureProtocol(rootUri), redirect -> DefaultTextResourceFactory.throwExceptionDueToInsecureRedirect(uri, redirect));
        return this.apiTextResourcesAdapterFactory.create(rootUri, redirectVerifier);
    }

    private static void throwExceptionDueToInsecureProtocol(URI rootUri) {
        throw new InsecureProtocolException("Loading a TextResource from an insecure URI, without explicit opt-in, is unsupported. " + String.format("The provided URI '%s' uses an insecure protocol (HTTP). ", rootUri), String.format("Switch the URI to '%s' or try 'resources.text.fromInsecureUri(\"%s\")' to silence the warning. ", GUtil.toSecureUrl((URI)rootUri), rootUri), Documentation.dslReference(TextResourceFactory.class, (String)"fromInsecureUri(java.lang.Object)").consultDocumentationMessage());
    }

    private static void throwExceptionDueToInsecureRedirect(Object uri, URI redirect) throws InvalidUserCodeException {
        throw new InsecureProtocolException("Loading a TextResource from an insecure redirect, without explicit opt-in, is unsupported. " + String.format("'%s' redirects to insecure '%s'.", uri, redirect), "Switch to HTTPS or use TextResourceFactory.fromInsecureUri(Object) to silence the warning.", Documentation.dslReference(TextResourceFactory.class, (String)"fromInsecureUri(java.lang.Object)").consultDocumentationMessage());
    }
}

