/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.failure;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import org.gradle.api.NonNullApi;
import org.gradle.api.internal.tasks.testing.failure.RootAssertionToFailureMapper;
import org.gradle.api.tasks.testing.TestFailure;

@NonNullApi
public abstract class FailureMapper {
    public boolean supports(Class<?> cls) {
        if (this.getSupportedClassNames().contains(cls.getName())) {
            return true;
        }
        Class<?> superclass = cls.getSuperclass();
        if (superclass == null) {
            return false;
        }
        return this.supports(superclass);
    }

    protected abstract List<String> getSupportedClassNames();

    public abstract TestFailure map(Throwable var1, RootAssertionToFailureMapper var2) throws Exception;

    protected static <T> T invokeMethod(Object obj, String methodName, Class<T> targetClass) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Method method = obj.getClass().getMethod(methodName, new Class[0]);
        return targetClass.cast(method.invoke(obj, new Object[0]));
    }
}

