/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.caching.local.internal;

import com.google.common.io.Closer;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import org.gradle.api.Action;
import org.gradle.cache.FileLock;
import org.gradle.cache.FileLockManager;
import org.gradle.cache.HasCleanupAction;
import org.gradle.cache.LockOptions;
import org.gradle.cache.PersistentCache;
import org.gradle.cache.internal.AbstractCrossProcessCacheAccess;
import org.gradle.cache.internal.CacheInitializationAction;
import org.gradle.cache.internal.LockOnDemandCrossProcessCacheAccess;
import org.gradle.cache.internal.cacheops.CacheAccessOperationsStack;
import org.gradle.cache.internal.filelock.LockOptionsBuilder;
import org.gradle.caching.BuildCacheEntryReader;
import org.gradle.caching.BuildCacheEntryWriter;
import org.gradle.caching.BuildCacheException;
import org.gradle.caching.BuildCacheKey;
import org.gradle.caching.internal.NextGenBuildCacheService;
import org.gradle.caching.internal.StatefulNextGenBuildCacheService;
import org.gradle.internal.UncheckedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LockOnDemandCrossProcessBuildCacheService
implements NextGenBuildCacheService,
HasCleanupAction {
    private static final Logger LOG = LoggerFactory.getLogger(LockOnDemandCrossProcessBuildCacheService.class);
    private final String cacheDisplayName;
    private final StatefulNextGenBuildCacheService delegate;
    private final AbstractCrossProcessCacheAccess crossProcessCacheAccess;
    private final CacheAccessOperationsStack operations;
    private final Lock stateLock = new ReentrantLock();
    private final Condition condition = this.stateLock.newCondition();
    private final PersistentCache persistentCache;
    private Thread owner;
    private FileLock fileLock;
    private Runnable fileLockHeldByOwner;
    private int cacheClosedCount;

    public LockOnDemandCrossProcessBuildCacheService(String cacheDisplayName, File lockTarget, FileLockManager lockManager, StatefulNextGenBuildCacheService delegate, Function<HasCleanupAction, PersistentCache> persistentCacheFactory) {
        this.cacheDisplayName = cacheDisplayName;
        this.delegate = delegate;
        this.operations = new CacheAccessOperationsStack();
        Action onFileLockAcquireAction = this::afterLockAcquire;
        Action onFileLockReleaseAction = this::beforeLockRelease;
        LockOptionsBuilder lockOptions = LockOptionsBuilder.mode((FileLockManager.LockMode)FileLockManager.LockMode.Exclusive).useCrossVersionImplementation();
        this.crossProcessCacheAccess = new LockOnDemandCrossProcessCacheAccess(cacheDisplayName, lockTarget, (LockOptions)lockOptions, lockManager, this.stateLock, CacheInitializationAction.NO_INIT_REQUIRED, onFileLockAcquireAction, onFileLockReleaseAction);
        this.persistentCache = persistentCacheFactory.apply(this);
        this.withOwnershipNow(() -> {
            try {
                this.crossProcessCacheAccess.open();
            }
            catch (Throwable throwable) {
                this.crossProcessCacheAccess.close();
                throw UncheckedException.throwAsUncheckedException((Throwable)throwable);
            }
        });
    }

    @Override
    public boolean contains(BuildCacheKey key) {
        return (Boolean)this.crossProcessCacheAccess.withFileLock(() -> this.delegate.contains(key));
    }

    @Override
    public void store(BuildCacheKey key, BuildCacheEntryWriter legacyWriter) throws BuildCacheException {
        this.crossProcessCacheAccess.withFileLock(() -> {
            this.delegate.store(key, legacyWriter);
            return null;
        });
    }

    @Override
    public void store(BuildCacheKey key, NextGenBuildCacheService.NextGenWriter writer) throws BuildCacheException {
        this.crossProcessCacheAccess.withFileLock(() -> {
            this.delegate.store(key, writer);
            return null;
        });
    }

    public boolean load(BuildCacheKey key, BuildCacheEntryReader reader) throws BuildCacheException {
        return (Boolean)this.crossProcessCacheAccess.withFileLock(() -> this.delegate.load(key, reader));
    }

    public void cleanup() {
        this.crossProcessCacheAccess.withFileLock(() -> {
            this.delegate.cleanup();
            return null;
        });
    }

    public synchronized void close() {
        this.withOwnershipNow(() -> {
            try {
                if (this.fileLockHeldByOwner != null) {
                    this.fileLockHeldByOwner.run();
                }
                Closer closer = Closer.create();
                closer.register((Closeable)this.crossProcessCacheAccess);
                closer.register((Closeable)this.persistentCache);
                closer.close();
                if (this.cacheClosedCount != 1) {
                    LOG.debug("Cache {} was closed {} times.", (Object)this.cacheDisplayName, (Object)this.cacheClosedCount);
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            finally {
                this.owner = null;
                this.fileLockHeldByOwner = null;
            }
        });
    }

    private void withOwnershipNow(Runnable action) {
        this.stateLock.lock();
        try {
            this.takeOwnershipNow();
            try {
                action.run();
            }
            finally {
                this.releaseOwnership();
            }
        }
        finally {
            this.stateLock.unlock();
        }
    }

    private void takeOwnershipNow() {
        if (this.owner != null && this.owner != Thread.currentThread()) {
            throw new IllegalStateException(String.format("Cannot take ownership of %s as it is currently being used by another thread.", this.cacheDisplayName));
        }
        this.owner = Thread.currentThread();
        this.operations.pushCacheAction();
    }

    private void releaseOwnership() {
        this.operations.popCacheAction();
        if (!this.operations.isInCacheAction()) {
            this.owner = null;
            this.condition.signalAll();
        }
    }

    private void afterLockAcquire(FileLock fileLock) {
        assert (this.fileLock == null);
        this.fileLock = fileLock;
        this.withOwnershipNow(this.delegate::open);
    }

    private void beforeLockRelease(FileLock fileLock) {
        assert (this.fileLock == fileLock);
        try {
            ++this.cacheClosedCount;
            this.withOwnershipNow(this.delegate::close);
        }
        finally {
            this.fileLock = null;
        }
    }
}

