/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution;

import com.google.common.collect.ImmutableSortedMap;
import java.io.File;
import org.gradle.internal.execution.UnitOfWork;
import org.gradle.internal.snapshot.FileSystemSnapshot;

public interface OutputSnapshotter {
    public ImmutableSortedMap<String, FileSystemSnapshot> snapshotOutputs(UnitOfWork var1, File var2) throws OutputFileSnapshottingException;

    public static class OutputFileSnapshottingException
    extends RuntimeException {
        private final String propertyName;

        public OutputFileSnapshottingException(String propertyName, Throwable cause) {
            this(String.format("Cannot snapshot output property '%s'.", propertyName), cause, propertyName);
        }

        private OutputFileSnapshottingException(String formattedMessage, Throwable cause, String propertyName) {
            super(formattedMessage, cause);
            this.propertyName = propertyName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }
    }
}

