/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.reflect.validation;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.gradle.internal.logging.text.TreeFormatter;
import org.gradle.internal.reflect.validation.TypeValidationProblem;
import org.gradle.internal.reflect.validation.TypeValidationProblemLocation;
import org.gradle.model.internal.type.ModelType;
import org.gradle.plugin.use.PluginId;
import org.gradle.problems.Solution;
import org.gradle.util.internal.TextUtil;

public class TypeValidationProblemRenderer {
    public static String renderMinimalInformationAbout(TypeValidationProblem problem) {
        return TypeValidationProblemRenderer.renderMinimalInformationAbout(problem, true);
    }

    public static String renderMinimalInformationAbout(TypeValidationProblem problem, boolean renderDocLink) {
        return TypeValidationProblemRenderer.renderMinimalInformationAbout(problem, renderDocLink, true);
    }

    public static String renderMinimalInformationAbout(TypeValidationProblem problem, boolean renderDocLink, boolean renderSolutions) {
        TreeFormatter formatter = new TreeFormatter();
        formatter.node(TypeValidationProblemRenderer.introductionFor((TypeValidationProblemLocation)problem.getWhere()) + TextUtil.endLineWithDot((String)problem.getShortDescription()));
        problem.getWhy().ifPresent(reason -> {
            formatter.blankLine();
            formatter.node("Reason: " + StringUtils.capitalize((String)TextUtil.endLineWithDot((String)reason)));
        });
        if (renderSolutions) {
            TypeValidationProblemRenderer.renderSolutions(formatter, problem.getPossibleSolutions());
        }
        if (renderDocLink) {
            problem.getDocumentationLink().ifPresent(docLink -> {
                formatter.blankLine();
                formatter.node(docLink);
            });
        }
        return formatter.toString();
    }

    public static void renderSolutions(TreeFormatter formatter, List<Solution> possibleSolutions) {
        int solutionCount = possibleSolutions.size();
        if (solutionCount > 0) {
            formatter.blankLine();
            if (solutionCount == 1) {
                formatter.node("Possible solution: " + StringUtils.capitalize((String)TextUtil.endLineWithDot((String)possibleSolutions.get(0).getShortDescription())));
            } else {
                formatter.node("Possible solutions");
                formatter.startNumberedChildren();
                possibleSolutions.forEach(solution -> formatter.node(StringUtils.capitalize((String)TextUtil.endLineWithDot((String)solution.getShortDescription()))));
                formatter.endChildren();
            }
        }
    }

    public static String convertToSingleLine(String message) {
        return message.replaceAll("(\\r?\\n *)+", ". ").replaceAll("[.]+", ".").replaceAll("[ ]+", " ").replaceAll(": ?[. ]", ": ");
    }

    private static String introductionFor(TypeValidationProblemLocation location) {
        String property;
        StringBuilder builder = new StringBuilder();
        Class rootType = location.getType().filter(TypeValidationProblemRenderer::shouldRenderType).orElse(null);
        PluginId pluginId = location.getPlugin().orElse(null);
        if (rootType != null) {
            if (pluginId != null) {
                builder.append("In plugin '").append(pluginId).append("' type '");
            } else {
                builder.append("Type '");
            }
            builder.append(ModelType.of((Class)rootType).getName()).append("' ");
        }
        if ((property = (String)location.getPropertyName().orElse(null)) != null) {
            if (rootType == null) {
                if (pluginId != null) {
                    builder.append("In plugin '").append(pluginId).append("' property '");
                } else {
                    builder.append("Property '");
                }
            } else {
                builder.append("property '");
            }
            location.getParentPropertyName().ifPresent(parentProperty -> {
                builder.append((String)parentProperty);
                builder.append('.');
            });
            builder.append(property).append("' ");
        }
        return builder.toString();
    }

    private static boolean shouldRenderType(Class<?> clazz) {
        return !"org.gradle.api.DefaultTask".equals(clazz.getName());
    }
}

