/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.reflect.annotations.impl;

import com.google.common.collect.ImmutableMap;
import com.google.common.reflect.TypeToken;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.gradle.api.GradleException;
import org.gradle.internal.Cast;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.reflect.annotations.AnnotationCategory;
import org.gradle.internal.reflect.annotations.PropertyAnnotationMetadata;

public class DefaultPropertyAnnotationMetadata
implements PropertyAnnotationMetadata {
    private final String propertyName;
    private final Method getter;
    private final TypeToken<?> declaredType;
    private final ImmutableMap<AnnotationCategory, Annotation> annotationsByCategory;
    private final ImmutableMap<Class<? extends Annotation>, Annotation> annotationsByType;

    public DefaultPropertyAnnotationMetadata(String propertyName, Method getter, ImmutableMap<AnnotationCategory, Annotation> annotationsByCategory) {
        this.propertyName = propertyName;
        this.getter = getter;
        getter.setAccessible(true);
        this.declaredType = TypeToken.of((Type)getter.getGenericReturnType());
        this.annotationsByCategory = annotationsByCategory;
        this.annotationsByType = DefaultPropertyAnnotationMetadata.collectAnnotationsByType(annotationsByCategory);
    }

    private static ImmutableMap<Class<? extends Annotation>, Annotation> collectAnnotationsByType(ImmutableMap<AnnotationCategory, Annotation> annotations) {
        ImmutableMap.Builder builder = ImmutableMap.builderWithExpectedSize((int)annotations.size());
        for (Annotation value : annotations.values()) {
            builder.put(value.annotationType(), (Object)value);
        }
        return builder.build();
    }

    @Override
    public Method getGetter() {
        return this.getter;
    }

    @Override
    public String getPropertyName() {
        return this.propertyName;
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
        return this.annotationsByType.containsKey(annotationType);
    }

    @Override
    public <T extends Annotation> Optional<T> getAnnotation(Class<T> annotationType) {
        return Optional.ofNullable((Annotation)Cast.uncheckedCast((Object)this.annotationsByType.get(annotationType)));
    }

    @Override
    public ImmutableMap<AnnotationCategory, Annotation> getAnnotations() {
        return this.annotationsByCategory;
    }

    @Override
    public int compareTo(@Nonnull PropertyAnnotationMetadata o) {
        return this.propertyName.compareTo(o.getPropertyName());
    }

    @Override
    public TypeToken<?> getDeclaredType() {
        return this.declaredType;
    }

    @Override
    @Nullable
    public Object getPropertyValue(Object object) {
        try {
            return this.getter.invoke(object, new Object[0]);
        }
        catch (InvocationTargetException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e.getCause());
        }
        catch (Exception e) {
            throw new GradleException(String.format("Could not call %s.%s() on %s", this.getter.getDeclaringClass().getSimpleName(), this.getter.getName(), object), (Throwable)e);
        }
    }

    public String toString() {
        return String.format("%s / %s()", this.propertyName, this.getter.getName());
    }
}

