/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.repositories;

import java.net.URI;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.gradle.api.InvalidUserCodeException;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.artifacts.repositories.UrlArtifactRepository;
import org.gradle.api.internal.artifacts.repositories.InsecureProtocolException;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.internal.deprecation.Documentation;
import org.gradle.internal.verifier.HttpRedirectVerifier;
import org.gradle.internal.verifier.HttpRedirectVerifierFactory;

public class DefaultUrlArtifactRepository
implements UrlArtifactRepository {
    private Object url;
    private boolean allowInsecureProtocol;
    private final String repositoryType;
    private final FileResolver fileResolver;
    private final Supplier<String> displayNameSupplier;

    DefaultUrlArtifactRepository(FileResolver fileResolver, String repositoryType, Supplier<String> displayNameSupplier) {
        this.fileResolver = fileResolver;
        this.repositoryType = repositoryType;
        this.displayNameSupplier = displayNameSupplier;
    }

    public URI getUrl() {
        return this.url == null ? null : this.fileResolver.resolveUri(this.url);
    }

    public void setUrl(URI url) {
        this.url = url;
    }

    public void setUrl(Object url) {
        this.url = url;
    }

    public void setAllowInsecureProtocol(boolean allowInsecureProtocol) {
        this.allowInsecureProtocol = allowInsecureProtocol;
    }

    public boolean isAllowInsecureProtocol() {
        return this.allowInsecureProtocol;
    }

    @Nonnull
    public URI validateUrl() {
        URI rootUri = this.getUrl();
        if (rootUri == null) {
            throw new InvalidUserDataException(String.format("You must specify a URL for a %s repository.", this.repositoryType));
        }
        return rootUri;
    }

    private void throwExceptionDueToInsecureProtocol() throws InvalidUserCodeException {
        throw new InsecureProtocolException("Using insecure protocols with repositories, without explicit opt-in, is unsupported.", String.format("Switch %s repository '%s' to redirect to a secure protocol (like HTTPS) or allow insecure protocols.", this.repositoryType, this.displayNameSupplier.get()), Documentation.dslReference(UrlArtifactRepository.class, (String)"allowInsecureProtocol").consultDocumentationMessage());
    }

    private void throwExceptionDueToInsecureRedirect(@Nullable URI redirectFrom, URI redirectLocation) throws InvalidUserCodeException {
        String contextualAdvice = redirectFrom != null ? String.format(" '%s' is redirecting to '%s'. ", redirectFrom, redirectLocation) : "";
        throw new InsecureProtocolException("Redirecting from secure protocol to insecure protocol, without explicit opt-in, is unsupported." + contextualAdvice, String.format("Switch %s repository '%s' to redirect to a secure protocol (like HTTPS) or allow insecure protocols. ", this.repositoryType, this.displayNameSupplier.get()), Documentation.dslReference(UrlArtifactRepository.class, (String)"allowInsecureProtocol").consultDocumentationMessage());
    }

    HttpRedirectVerifier createRedirectVerifier() {
        URI uri = this.getUrl();
        return HttpRedirectVerifierFactory.create((URI)uri, (boolean)this.allowInsecureProtocol, this::throwExceptionDueToInsecureProtocol, redirection -> this.throwExceptionDueToInsecureRedirect(uri, (URI)redirection));
    }

    public static class Factory {
        private final FileResolver fileResolver;

        @Inject
        public Factory(FileResolver fileResolver) {
            this.fileResolver = fileResolver;
        }

        DefaultUrlArtifactRepository create(String repositoryType, Supplier<String> displayNameSupplier) {
            return new DefaultUrlArtifactRepository(this.fileResolver, repositoryType, displayNameSupplier);
        }
    }
}

