/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.jline.terminal.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.kotlin.org.jline.terminal.Terminal;
import org.jetbrains.kotlin.org.jline.terminal.impl.AbstractPosixTerminal;
import org.jetbrains.kotlin.org.jline.terminal.spi.Pty;
import org.jetbrains.kotlin.org.jline.utils.InputStreamReader;
import org.jetbrains.kotlin.org.jline.utils.NonBlockingReader;
import org.jetbrains.kotlin.org.jline.utils.ShutdownHooks;
import org.jetbrains.kotlin.org.jline.utils.Signals;

public class PosixSysTerminal
extends AbstractPosixTerminal {
    protected final InputStream input;
    protected final OutputStream output;
    protected final NonBlockingReader reader;
    protected final PrintWriter writer;
    protected final Map<Terminal.Signal, Object> nativeHandlers = new HashMap<Terminal.Signal, Object>();
    protected final ShutdownHooks.Task closer;

    public PosixSysTerminal(String name2, String type2, Pty pty, String encoding, boolean nativeSignals, Terminal.SignalHandler signalHandler) throws IOException {
        super(name2, type2, pty, signalHandler);
        Objects.requireNonNull(encoding);
        this.input = pty.getSlaveInput();
        this.output = pty.getSlaveOutput();
        this.reader = new NonBlockingReader(this.getName(), new InputStreamReader(this.input, encoding));
        this.writer = new PrintWriter(new OutputStreamWriter(this.output, encoding));
        this.parseInfoCmp();
        if (nativeSignals) {
            for (Terminal.Signal signal : Terminal.Signal.values()) {
                if (signalHandler == Terminal.SignalHandler.SIG_DFL) {
                    this.nativeHandlers.put(signal, Signals.registerDefault(signal.name()));
                    continue;
                }
                this.nativeHandlers.put(signal, Signals.register(signal.name(), () -> this.raise(signal)));
            }
        }
        this.closer = this::close;
        ShutdownHooks.add(this.closer);
    }

    @Override
    public Terminal.SignalHandler handle(Terminal.Signal signal, Terminal.SignalHandler handler2) {
        Terminal.SignalHandler prev = super.handle(signal, handler2);
        if (prev != handler2) {
            if (handler2 == Terminal.SignalHandler.SIG_DFL) {
                Signals.registerDefault(signal.name());
            } else {
                Signals.register(signal.name(), () -> this.raise(signal));
            }
        }
        return prev;
    }

    @Override
    public NonBlockingReader reader() {
        return this.reader;
    }

    @Override
    public PrintWriter writer() {
        return this.writer;
    }

    @Override
    public void close() throws IOException {
        ShutdownHooks.remove(this.closer);
        for (Map.Entry<Terminal.Signal, Object> entry : this.nativeHandlers.entrySet()) {
            Signals.unregister(entry.getKey().name(), entry.getValue());
        }
        super.close();
        this.reader.shutdown();
    }
}

