/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.MouseListener;
import java.util.List;
import javax.swing.TransferHandler;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.label.UnitLabel;
import net.sf.freecol.client.gui.panel.CargoPanel;
import net.sf.freecol.client.gui.panel.DefaultTransferHandler;
import net.sf.freecol.client.gui.panel.FreeColPanel;
import net.sf.freecol.client.gui.panel.InPortPanel;
import net.sf.freecol.common.model.Unit;

public abstract class PortPanel
extends FreeColPanel {
    protected CargoPanel cargoPanel;
    protected InPortPanel inPortPanel;
    protected UnitLabel selectedUnitLabel = null;
    protected DefaultTransferHandler defaultTransferHandler;
    protected MouseListener pressListener;

    protected PortPanel(FreeColClient freeColClient, LayoutManager layout) {
        super(freeColClient, null, layout);
    }

    public final CargoPanel getCargoPanel() {
        return this.cargoPanel;
    }

    public Unit getSelectedUnit() {
        return this.selectedUnitLabel == null ? null : this.selectedUnitLabel.getUnit();
    }

    protected boolean setSelectedUnit(Unit unit) {
        for (Component component : this.getComponents()) {
            UnitLabel label;
            if (!(component instanceof UnitLabel) || (label = (UnitLabel)component).getUnit() != unit) continue;
            this.setSelectedUnitLabel(label);
            return true;
        }
        return false;
    }

    public UnitLabel getSelectedUnitLabel() {
        return this.selectedUnitLabel;
    }

    public void setSelectedUnitLabel(UnitLabel label) {
        this.selectedUnitLabel = label;
    }

    public MouseListener getPressListener() {
        return this.pressListener;
    }

    public abstract List<Unit> getUnitList();

    @Override
    public TransferHandler getTransferHandler() {
        return this.defaultTransferHandler;
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.removeAll();
        this.cargoPanel = null;
        this.inPortPanel = null;
        this.defaultTransferHandler = null;
        this.pressListener = null;
        this.selectedUnitLabel = null;
    }
}

