/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.spi.connector.checksum;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.aether.spi.connector.checksum.ChecksumAlgorithm;
import org.eclipse.aether.spi.connector.checksum.ChecksumAlgorithmFactory;

public final class ChecksumAlgorithmHelper {
    private ChecksumAlgorithmHelper() {
    }

    public static Map<String, String> calculate(byte[] data2, List<ChecksumAlgorithmFactory> factories) throws IOException {
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(data2);){
            Map<String, String> map2 = ChecksumAlgorithmHelper.calculate(inputStream, factories);
            return map2;
        }
    }

    public static Map<String, String> calculate(File file2, List<ChecksumAlgorithmFactory> factories) throws IOException {
        try (BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(file2));){
            Map<String, String> map2 = ChecksumAlgorithmHelper.calculate(inputStream, factories);
            return map2;
        }
    }

    private static Map<String, String> calculate(InputStream inputStream, List<ChecksumAlgorithmFactory> factories) throws IOException {
        int read2;
        LinkedHashMap<String, ChecksumAlgorithm> algorithms = new LinkedHashMap<String, ChecksumAlgorithm>();
        factories.forEach(f -> algorithms.put(f.getName(), f.getAlgorithm()));
        byte[] buffer2 = new byte[32768];
        while ((read2 = inputStream.read(buffer2)) >= 0) {
            for (ChecksumAlgorithm checksumAlgorithm : algorithms.values()) {
                checksumAlgorithm.update(ByteBuffer.wrap(buffer2, 0, read2));
            }
        }
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        algorithms.forEach((k, v) -> result.put((String)k, v.checksum()));
        return result;
    }
}

