# pylint:disable=line-too-long
import logging

from ...sim_type import SimTypeFunction,     SimTypeShort, SimTypeInt, SimTypeLong, SimTypeLongLong, SimTypeDouble, SimTypeFloat,     SimTypePointer,     SimTypeChar,     SimStruct,     SimTypeFixedSizeArray,     SimTypeBottom,     SimUnion,     SimTypeBool
from ...calling_conventions import SimCCStdcall, SimCCMicrosoftAMD64
from .. import SIM_PROCEDURES as P
from . import SimLibrary


_l = logging.getLogger(name=__name__)


lib = SimLibrary()
lib.set_default_cc('X86', SimCCStdcall)
lib.set_default_cc('AMD64', SimCCMicrosoftAMD64)
lib.set_library_names("httpapi.dll")
prototypes = \
    {
        #
        'HttpInitialize': SimTypeFunction([SimStruct({"HttpApiMajorVersion": SimTypeShort(signed=False, label="UInt16"), "HttpApiMinorVersion": SimTypeShort(signed=False, label="UInt16")}, name="HTTPAPI_VERSION", pack=False, align=None), SimTypeInt(signed=False, label="HTTP_INITIALIZE"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["Version", "Flags", "pReserved"]),
        #
        'HttpTerminate': SimTypeFunction([SimTypeInt(signed=False, label="HTTP_INITIALIZE"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["Flags", "pReserved"]),
        #
        'HttpCreateHttpHandle': SimTypeFunction([SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["RequestQueueHandle", "Reserved"]),
        #
        'HttpCreateRequestQueue': SimTypeFunction([SimStruct({"HttpApiMajorVersion": SimTypeShort(signed=False, label="UInt16"), "HttpApiMinorVersion": SimTypeShort(signed=False, label="UInt16")}, name="HTTPAPI_VERSION", pack=False, align=None), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"nLength": SimTypeInt(signed=False, label="UInt32"), "lpSecurityDescriptor": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "bInheritHandle": SimTypeInt(signed=True, label="Int32")}, name="SECURITY_ATTRIBUTES", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["Version", "Name", "SecurityAttributes", "Flags", "RequestQueueHandle"]),
        #
        'HttpCloseRequestQueue': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["RequestQueueHandle"]),
        #
        'HttpSetRequestQueueProperty': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="HTTP_SERVER_PROPERTY"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["RequestQueueHandle", "Property", "PropertyInformation", "PropertyInformationLength", "Reserved1", "Reserved2"]),
        #
        'HttpQueryRequestQueueProperty': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="HTTP_SERVER_PROPERTY"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["RequestQueueHandle", "Property", "PropertyInformation", "PropertyInformationLength", "Reserved1", "ReturnLength", "Reserved2"]),
        #
        'HttpShutdownRequestQueue': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["RequestQueueHandle"]),
        #
        'HttpReceiveClientCertificate': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeLongLong(signed=False, label="UInt64"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"CertFlags": SimTypeInt(signed=False, label="UInt32"), "CertEncodedSize": SimTypeInt(signed=False, label="UInt32"), "pCertEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Token": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "CertDeniedByMapper": SimTypeChar(label="Byte")}, name="HTTP_SSL_CLIENT_CERT_INFO", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimStruct({"Internal": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "InternalHigh": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Anonymous": SimUnion({"Anonymous": SimStruct({"Offset": SimTypeInt(signed=False, label="UInt32"), "OffsetHigh": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None), "Pointer": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="<anon>", label="None"), "hEvent": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="OVERLAPPED", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["RequestQueueHandle", "ConnectionId", "Flags", "SslClientCertInfo", "SslClientCertInfoSize", "BytesReceived", "Overlapped"]),
        #
        'HttpCreateServerSession': SimTypeFunction([SimStruct({"HttpApiMajorVersion": SimTypeShort(signed=False, label="UInt16"), "HttpApiMinorVersion": SimTypeShort(signed=False, label="UInt16")}, name="HTTPAPI_VERSION", pack=False, align=None), SimTypePointer(SimTypeLongLong(signed=False, label="UInt64"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["Version", "ServerSessionId", "Reserved"]),
        #
        'HttpCloseServerSession': SimTypeFunction([SimTypeLongLong(signed=False, label="UInt64")], SimTypeInt(signed=False, label="UInt32"), arg_names=["ServerSessionId"]),
        #
        'HttpQueryServerSessionProperty': SimTypeFunction([SimTypeLongLong(signed=False, label="UInt64"), SimTypeInt(signed=False, label="HTTP_SERVER_PROPERTY"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ServerSessionId", "Property", "PropertyInformation", "PropertyInformationLength", "ReturnLength"]),
        #
        'HttpSetServerSessionProperty': SimTypeFunction([SimTypeLongLong(signed=False, label="UInt64"), SimTypeInt(signed=False, label="HTTP_SERVER_PROPERTY"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["ServerSessionId", "Property", "PropertyInformation", "PropertyInformationLength"]),
        #
        'HttpAddUrl': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["RequestQueueHandle", "FullyQualifiedUrl", "Reserved"]),
        #
        'HttpRemoveUrl': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["RequestQueueHandle", "FullyQualifiedUrl"]),
        #
        'HttpCreateUrlGroup': SimTypeFunction([SimTypeLongLong(signed=False, label="UInt64"), SimTypePointer(SimTypeLongLong(signed=False, label="UInt64"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["ServerSessionId", "pUrlGroupId", "Reserved"]),
        #
        'HttpCloseUrlGroup': SimTypeFunction([SimTypeLongLong(signed=False, label="UInt64")], SimTypeInt(signed=False, label="UInt32"), arg_names=["UrlGroupId"]),
        #
        'HttpAddUrlToUrlGroup': SimTypeFunction([SimTypeLongLong(signed=False, label="UInt64"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeLongLong(signed=False, label="UInt64"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["UrlGroupId", "pFullyQualifiedUrl", "UrlContext", "Reserved"]),
        #
        'HttpRemoveUrlFromUrlGroup': SimTypeFunction([SimTypeLongLong(signed=False, label="UInt64"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["UrlGroupId", "pFullyQualifiedUrl", "Flags"]),
        #
        'HttpSetUrlGroupProperty': SimTypeFunction([SimTypeLongLong(signed=False, label="UInt64"), SimTypeInt(signed=False, label="HTTP_SERVER_PROPERTY"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["UrlGroupId", "Property", "PropertyInformation", "PropertyInformationLength"]),
        #
        'HttpQueryUrlGroupProperty': SimTypeFunction([SimTypeLongLong(signed=False, label="UInt64"), SimTypeInt(signed=False, label="HTTP_SERVER_PROPERTY"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["UrlGroupId", "Property", "PropertyInformation", "PropertyInformationLength", "ReturnLength"]),
        #
        'HttpPrepareUrl': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["Reserved", "Flags", "Url", "PreparedUrl"]),
        #
        'HttpReceiveHttpRequest': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeLongLong(signed=False, label="UInt64"), SimTypeInt(signed=False, label="HTTP_RECEIVE_HTTP_REQUEST_FLAGS"), SimTypePointer(SimStruct({"__AnonymousBase_http_L1816_C35": SimStruct({"Flags": SimTypeInt(signed=False, label="UInt32"), "ConnectionId": SimTypeLongLong(signed=False, label="UInt64"), "RequestId": SimTypeLongLong(signed=False, label="UInt64"), "UrlContext": SimTypeLongLong(signed=False, label="UInt64"), "Version": SimStruct({"MajorVersion": SimTypeShort(signed=False, label="UInt16"), "MinorVersion": SimTypeShort(signed=False, label="UInt16")}, name="HTTP_VERSION", pack=False, align=None), "Verb": SimTypeInt(signed=False, label="HTTP_VERB"), "UnknownVerbLength": SimTypeShort(signed=False, label="UInt16"), "RawUrlLength": SimTypeShort(signed=False, label="UInt16"), "pUnknownVerb": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pRawUrl": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "CookedUrl": SimStruct({"FullUrlLength": SimTypeShort(signed=False, label="UInt16"), "HostLength": SimTypeShort(signed=False, label="UInt16"), "AbsPathLength": SimTypeShort(signed=False, label="UInt16"), "QueryStringLength": SimTypeShort(signed=False, label="UInt16"), "pFullUrl": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pHost": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pAbsPath": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pQueryString": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="HTTP_COOKED_URL", pack=False, align=None), "Address": SimStruct({"pRemoteAddress": SimTypePointer(SimTypeBottom(label="SOCKADDR"), offset=0), "pLocalAddress": SimTypePointer(SimTypeBottom(label="SOCKADDR"), offset=0)}, name="HTTP_TRANSPORT_ADDRESS", pack=False, align=None), "Headers": SimStruct({"UnknownHeaderCount": SimTypeShort(signed=False, label="UInt16"), "pUnknownHeaders": SimTypePointer(SimStruct({"NameLength": SimTypeShort(signed=False, label="UInt16"), "RawValueLength": SimTypeShort(signed=False, label="UInt16"), "pName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pRawValue": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="HTTP_UNKNOWN_HEADER", pack=False, align=None), offset=0), "TrailerCount": SimTypeShort(signed=False, label="UInt16"), "pTrailers": SimTypePointer(SimStruct({"NameLength": SimTypeShort(signed=False, label="UInt16"), "RawValueLength": SimTypeShort(signed=False, label="UInt16"), "pName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pRawValue": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="HTTP_UNKNOWN_HEADER", pack=False, align=None), offset=0), "KnownHeaders": SimTypeFixedSizeArray(SimStruct({"RawValueLength": SimTypeShort(signed=False, label="UInt16"), "pRawValue": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="HTTP_KNOWN_HEADER", pack=False, align=None), 41)}, name="HTTP_REQUEST_HEADERS", pack=False, align=None), "BytesReceived": SimTypeLongLong(signed=False, label="UInt64"), "EntityChunkCount": SimTypeShort(signed=False, label="UInt16"), "pEntityChunks": SimTypePointer(SimStruct({"DataChunkType": SimTypeInt(signed=False, label="HTTP_DATA_CHUNK_TYPE"), "Anonymous": SimUnion({"FromMemory": SimStruct({"pBuffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32")}, name="_FromMemory_e__Struct", pack=False, align=None), "FromFileHandle": SimStruct({"ByteRange": SimStruct({"StartingOffset": SimTypeBottom(label="ULARGE_INTEGER"), "Length": SimTypeBottom(label="ULARGE_INTEGER")}, name="HTTP_BYTE_RANGE", pack=False, align=None), "FileHandle": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="_FromFileHandle_e__Struct", pack=False, align=None), "FromFragmentCache": SimStruct({"FragmentNameLength": SimTypeShort(signed=False, label="UInt16"), "pFragmentName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="_FromFragmentCache_e__Struct", pack=False, align=None), "FromFragmentCacheEx": SimStruct({"ByteRange": SimStruct({"StartingOffset": SimTypeBottom(label="ULARGE_INTEGER"), "Length": SimTypeBottom(label="ULARGE_INTEGER")}, name="HTTP_BYTE_RANGE", pack=False, align=None), "pFragmentName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="_FromFragmentCacheEx_e__Struct", pack=False, align=None)}, name="<anon>", label="None")}, name="HTTP_DATA_CHUNK", pack=False, align=None), offset=0), "RawConnectionId": SimTypeLongLong(signed=False, label="UInt64"), "pSslInfo": SimTypePointer(SimStruct({"ServerCertKeySize": SimTypeShort(signed=False, label="UInt16"), "ConnectionKeySize": SimTypeShort(signed=False, label="UInt16"), "ServerCertIssuerSize": SimTypeInt(signed=False, label="UInt32"), "ServerCertSubjectSize": SimTypeInt(signed=False, label="UInt32"), "pServerCertIssuer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pServerCertSubject": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pClientCertInfo": SimTypePointer(SimStruct({"CertFlags": SimTypeInt(signed=False, label="UInt32"), "CertEncodedSize": SimTypeInt(signed=False, label="UInt32"), "pCertEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Token": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "CertDeniedByMapper": SimTypeChar(label="Byte")}, name="HTTP_SSL_CLIENT_CERT_INFO", pack=False, align=None), offset=0), "SslClientCertNegotiated": SimTypeInt(signed=False, label="UInt32")}, name="HTTP_SSL_INFO", pack=False, align=None), offset=0)}, name="HTTP_REQUEST_V1", pack=False, align=None), "RequestInfoCount": SimTypeShort(signed=False, label="UInt16"), "pRequestInfo": SimTypePointer(SimStruct({"InfoType": SimTypeInt(signed=False, label="HTTP_REQUEST_INFO_TYPE"), "InfoLength": SimTypeInt(signed=False, label="UInt32"), "pInfo": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="HTTP_REQUEST_INFO", pack=False, align=None), offset=0)}, name="HTTP_REQUEST_V2", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimStruct({"Internal": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "InternalHigh": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Anonymous": SimUnion({"Anonymous": SimStruct({"Offset": SimTypeInt(signed=False, label="UInt32"), "OffsetHigh": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None), "Pointer": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="<anon>", label="None"), "hEvent": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="OVERLAPPED", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["RequestQueueHandle", "RequestId", "Flags", "RequestBuffer", "RequestBufferLength", "BytesReturned", "Overlapped"]),
        #
        'HttpReceiveRequestEntityBody': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeLongLong(signed=False, label="UInt64"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimStruct({"Internal": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "InternalHigh": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Anonymous": SimUnion({"Anonymous": SimStruct({"Offset": SimTypeInt(signed=False, label="UInt32"), "OffsetHigh": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None), "Pointer": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="<anon>", label="None"), "hEvent": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="OVERLAPPED", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["RequestQueueHandle", "RequestId", "Flags", "EntityBuffer", "EntityBufferLength", "BytesReturned", "Overlapped"]),
        #
        'HttpSendHttpResponse': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeLongLong(signed=False, label="UInt64"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"__AnonymousBase_http_L2003_C36": SimStruct({"Flags": SimTypeInt(signed=False, label="UInt32"), "Version": SimStruct({"MajorVersion": SimTypeShort(signed=False, label="UInt16"), "MinorVersion": SimTypeShort(signed=False, label="UInt16")}, name="HTTP_VERSION", pack=False, align=None), "StatusCode": SimTypeShort(signed=False, label="UInt16"), "ReasonLength": SimTypeShort(signed=False, label="UInt16"), "pReason": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Headers": SimStruct({"UnknownHeaderCount": SimTypeShort(signed=False, label="UInt16"), "pUnknownHeaders": SimTypePointer(SimStruct({"NameLength": SimTypeShort(signed=False, label="UInt16"), "RawValueLength": SimTypeShort(signed=False, label="UInt16"), "pName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pRawValue": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="HTTP_UNKNOWN_HEADER", pack=False, align=None), offset=0), "TrailerCount": SimTypeShort(signed=False, label="UInt16"), "pTrailers": SimTypePointer(SimStruct({"NameLength": SimTypeShort(signed=False, label="UInt16"), "RawValueLength": SimTypeShort(signed=False, label="UInt16"), "pName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pRawValue": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="HTTP_UNKNOWN_HEADER", pack=False, align=None), offset=0), "KnownHeaders": SimTypeFixedSizeArray(SimStruct({"RawValueLength": SimTypeShort(signed=False, label="UInt16"), "pRawValue": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="HTTP_KNOWN_HEADER", pack=False, align=None), 30)}, name="HTTP_RESPONSE_HEADERS", pack=False, align=None), "EntityChunkCount": SimTypeShort(signed=False, label="UInt16"), "pEntityChunks": SimTypePointer(SimStruct({"DataChunkType": SimTypeInt(signed=False, label="HTTP_DATA_CHUNK_TYPE"), "Anonymous": SimUnion({"FromMemory": SimStruct({"pBuffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32")}, name="_FromMemory_e__Struct", pack=False, align=None), "FromFileHandle": SimStruct({"ByteRange": SimStruct({"StartingOffset": SimTypeBottom(label="ULARGE_INTEGER"), "Length": SimTypeBottom(label="ULARGE_INTEGER")}, name="HTTP_BYTE_RANGE", pack=False, align=None), "FileHandle": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="_FromFileHandle_e__Struct", pack=False, align=None), "FromFragmentCache": SimStruct({"FragmentNameLength": SimTypeShort(signed=False, label="UInt16"), "pFragmentName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="_FromFragmentCache_e__Struct", pack=False, align=None), "FromFragmentCacheEx": SimStruct({"ByteRange": SimStruct({"StartingOffset": SimTypeBottom(label="ULARGE_INTEGER"), "Length": SimTypeBottom(label="ULARGE_INTEGER")}, name="HTTP_BYTE_RANGE", pack=False, align=None), "pFragmentName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="_FromFragmentCacheEx_e__Struct", pack=False, align=None)}, name="<anon>", label="None")}, name="HTTP_DATA_CHUNK", pack=False, align=None), offset=0)}, name="HTTP_RESPONSE_V1", pack=False, align=None), "ResponseInfoCount": SimTypeShort(signed=False, label="UInt16"), "pResponseInfo": SimTypePointer(SimStruct({"Type": SimTypeInt(signed=False, label="HTTP_RESPONSE_INFO_TYPE"), "Length": SimTypeInt(signed=False, label="UInt32"), "pInfo": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="HTTP_RESPONSE_INFO", pack=False, align=None), offset=0)}, name="HTTP_RESPONSE_V2", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"Policy": SimTypeInt(signed=False, label="HTTP_CACHE_POLICY_TYPE"), "SecondsToLive": SimTypeInt(signed=False, label="UInt32")}, name="HTTP_CACHE_POLICY", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"Internal": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "InternalHigh": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Anonymous": SimUnion({"Anonymous": SimStruct({"Offset": SimTypeInt(signed=False, label="UInt32"), "OffsetHigh": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None), "Pointer": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="<anon>", label="None"), "hEvent": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="OVERLAPPED", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"Type": SimTypeInt(signed=False, label="HTTP_LOG_DATA_TYPE")}, name="HTTP_LOG_DATA", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["RequestQueueHandle", "RequestId", "Flags", "HttpResponse", "CachePolicy", "BytesSent", "Reserved1", "Reserved2", "Overlapped", "LogData"]),
        #
        'HttpSendResponseEntityBody': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeLongLong(signed=False, label="UInt64"), SimTypeInt(signed=False, label="UInt32"), SimTypeShort(signed=False, label="UInt16"), SimTypePointer(SimStruct({"DataChunkType": SimTypeInt(signed=False, label="HTTP_DATA_CHUNK_TYPE"), "Anonymous": SimUnion({"FromMemory": SimStruct({"pBuffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32")}, name="_FromMemory_e__Struct", pack=False, align=None), "FromFileHandle": SimStruct({"ByteRange": SimStruct({"StartingOffset": SimTypeBottom(label="ULARGE_INTEGER"), "Length": SimTypeBottom(label="ULARGE_INTEGER")}, name="HTTP_BYTE_RANGE", pack=False, align=None), "FileHandle": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="_FromFileHandle_e__Struct", pack=False, align=None), "FromFragmentCache": SimStruct({"FragmentNameLength": SimTypeShort(signed=False, label="UInt16"), "pFragmentName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="_FromFragmentCache_e__Struct", pack=False, align=None), "FromFragmentCacheEx": SimStruct({"ByteRange": SimStruct({"StartingOffset": SimTypeBottom(label="ULARGE_INTEGER"), "Length": SimTypeBottom(label="ULARGE_INTEGER")}, name="HTTP_BYTE_RANGE", pack=False, align=None), "pFragmentName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="_FromFragmentCacheEx_e__Struct", pack=False, align=None)}, name="<anon>", label="None")}, name="HTTP_DATA_CHUNK", pack=False, align=None), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"Internal": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "InternalHigh": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Anonymous": SimUnion({"Anonymous": SimStruct({"Offset": SimTypeInt(signed=False, label="UInt32"), "OffsetHigh": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None), "Pointer": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="<anon>", label="None"), "hEvent": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="OVERLAPPED", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"Type": SimTypeInt(signed=False, label="HTTP_LOG_DATA_TYPE")}, name="HTTP_LOG_DATA", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["RequestQueueHandle", "RequestId", "Flags", "EntityChunkCount", "EntityChunks", "BytesSent", "Reserved1", "Reserved2", "Overlapped", "LogData"]),
        #
        'HttpDeclarePush': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeLongLong(signed=False, label="UInt64"), SimTypeInt(signed=False, label="HTTP_VERB"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimStruct({"UnknownHeaderCount": SimTypeShort(signed=False, label="UInt16"), "pUnknownHeaders": SimTypePointer(SimStruct({"NameLength": SimTypeShort(signed=False, label="UInt16"), "RawValueLength": SimTypeShort(signed=False, label="UInt16"), "pName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pRawValue": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="HTTP_UNKNOWN_HEADER", pack=False, align=None), offset=0), "TrailerCount": SimTypeShort(signed=False, label="UInt16"), "pTrailers": SimTypePointer(SimStruct({"NameLength": SimTypeShort(signed=False, label="UInt16"), "RawValueLength": SimTypeShort(signed=False, label="UInt16"), "pName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pRawValue": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="HTTP_UNKNOWN_HEADER", pack=False, align=None), offset=0), "KnownHeaders": SimTypeFixedSizeArray(SimStruct({"RawValueLength": SimTypeShort(signed=False, label="UInt16"), "pRawValue": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="HTTP_KNOWN_HEADER", pack=False, align=None), 41)}, name="HTTP_REQUEST_HEADERS", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["RequestQueueHandle", "RequestId", "Verb", "Path", "Query", "Headers"]),
        #
        'HttpWaitForDisconnect': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeLongLong(signed=False, label="UInt64"), SimTypePointer(SimStruct({"Internal": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "InternalHigh": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Anonymous": SimUnion({"Anonymous": SimStruct({"Offset": SimTypeInt(signed=False, label="UInt32"), "OffsetHigh": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None), "Pointer": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="<anon>", label="None"), "hEvent": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="OVERLAPPED", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["RequestQueueHandle", "ConnectionId", "Overlapped"]),
        #
        'HttpWaitForDisconnectEx': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeLongLong(signed=False, label="UInt64"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"Internal": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "InternalHigh": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Anonymous": SimUnion({"Anonymous": SimStruct({"Offset": SimTypeInt(signed=False, label="UInt32"), "OffsetHigh": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None), "Pointer": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="<anon>", label="None"), "hEvent": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="OVERLAPPED", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["RequestQueueHandle", "ConnectionId", "Reserved", "Overlapped"]),
        #
        'HttpCancelHttpRequest': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeLongLong(signed=False, label="UInt64"), SimTypePointer(SimStruct({"Internal": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "InternalHigh": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Anonymous": SimUnion({"Anonymous": SimStruct({"Offset": SimTypeInt(signed=False, label="UInt32"), "OffsetHigh": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None), "Pointer": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="<anon>", label="None"), "hEvent": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="OVERLAPPED", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["RequestQueueHandle", "RequestId", "Overlapped"]),
        #
        'HttpWaitForDemandStart': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"Internal": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "InternalHigh": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Anonymous": SimUnion({"Anonymous": SimStruct({"Offset": SimTypeInt(signed=False, label="UInt32"), "OffsetHigh": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None), "Pointer": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="<anon>", label="None"), "hEvent": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="OVERLAPPED", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["RequestQueueHandle", "Overlapped"]),
        #
        'HttpFlushResponseCache': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"Internal": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "InternalHigh": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Anonymous": SimUnion({"Anonymous": SimStruct({"Offset": SimTypeInt(signed=False, label="UInt32"), "OffsetHigh": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None), "Pointer": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="<anon>", label="None"), "hEvent": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="OVERLAPPED", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["RequestQueueHandle", "UrlPrefix", "Flags", "Overlapped"]),
        #
        'HttpAddFragmentToCache': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"DataChunkType": SimTypeInt(signed=False, label="HTTP_DATA_CHUNK_TYPE"), "Anonymous": SimUnion({"FromMemory": SimStruct({"pBuffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32")}, name="_FromMemory_e__Struct", pack=False, align=None), "FromFileHandle": SimStruct({"ByteRange": SimStruct({"StartingOffset": SimTypeBottom(label="ULARGE_INTEGER"), "Length": SimTypeBottom(label="ULARGE_INTEGER")}, name="HTTP_BYTE_RANGE", pack=False, align=None), "FileHandle": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="_FromFileHandle_e__Struct", pack=False, align=None), "FromFragmentCache": SimStruct({"FragmentNameLength": SimTypeShort(signed=False, label="UInt16"), "pFragmentName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="_FromFragmentCache_e__Struct", pack=False, align=None), "FromFragmentCacheEx": SimStruct({"ByteRange": SimStruct({"StartingOffset": SimTypeBottom(label="ULARGE_INTEGER"), "Length": SimTypeBottom(label="ULARGE_INTEGER")}, name="HTTP_BYTE_RANGE", pack=False, align=None), "pFragmentName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="_FromFragmentCacheEx_e__Struct", pack=False, align=None)}, name="<anon>", label="None")}, name="HTTP_DATA_CHUNK", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"Policy": SimTypeInt(signed=False, label="HTTP_CACHE_POLICY_TYPE"), "SecondsToLive": SimTypeInt(signed=False, label="UInt32")}, name="HTTP_CACHE_POLICY", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"Internal": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "InternalHigh": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Anonymous": SimUnion({"Anonymous": SimStruct({"Offset": SimTypeInt(signed=False, label="UInt32"), "OffsetHigh": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None), "Pointer": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="<anon>", label="None"), "hEvent": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="OVERLAPPED", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["RequestQueueHandle", "UrlPrefix", "DataChunk", "CachePolicy", "Overlapped"]),
        #
        'HttpReadFragmentFromCache': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"StartingOffset": SimTypeBottom(label="ULARGE_INTEGER"), "Length": SimTypeBottom(label="ULARGE_INTEGER")}, name="HTTP_BYTE_RANGE", pack=False, align=None), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimStruct({"Internal": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "InternalHigh": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Anonymous": SimUnion({"Anonymous": SimStruct({"Offset": SimTypeInt(signed=False, label="UInt32"), "OffsetHigh": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None), "Pointer": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="<anon>", label="None"), "hEvent": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="OVERLAPPED", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["RequestQueueHandle", "UrlPrefix", "ByteRange", "Buffer", "BufferLength", "BytesRead", "Overlapped"]),
        #
        'HttpSetServiceConfiguration': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="HTTP_SERVICE_CONFIG_ID"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"Internal": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "InternalHigh": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Anonymous": SimUnion({"Anonymous": SimStruct({"Offset": SimTypeInt(signed=False, label="UInt32"), "OffsetHigh": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None), "Pointer": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="<anon>", label="None"), "hEvent": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="OVERLAPPED", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ServiceHandle", "ConfigId", "pConfigInformation", "ConfigInformationLength", "pOverlapped"]),
        #
        'HttpUpdateServiceConfiguration': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="HTTP_SERVICE_CONFIG_ID"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"Internal": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "InternalHigh": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Anonymous": SimUnion({"Anonymous": SimStruct({"Offset": SimTypeInt(signed=False, label="UInt32"), "OffsetHigh": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None), "Pointer": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="<anon>", label="None"), "hEvent": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="OVERLAPPED", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["Handle", "ConfigId", "ConfigInfo", "ConfigInfoLength", "Overlapped"]),
        #
        'HttpDeleteServiceConfiguration': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="HTTP_SERVICE_CONFIG_ID"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"Internal": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "InternalHigh": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Anonymous": SimUnion({"Anonymous": SimStruct({"Offset": SimTypeInt(signed=False, label="UInt32"), "OffsetHigh": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None), "Pointer": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="<anon>", label="None"), "hEvent": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="OVERLAPPED", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ServiceHandle", "ConfigId", "pConfigInformation", "ConfigInformationLength", "pOverlapped"]),
        #
        'HttpQueryServiceConfiguration': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="HTTP_SERVICE_CONFIG_ID"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimStruct({"Internal": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "InternalHigh": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Anonymous": SimUnion({"Anonymous": SimStruct({"Offset": SimTypeInt(signed=False, label="UInt32"), "OffsetHigh": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None), "Pointer": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="<anon>", label="None"), "hEvent": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="OVERLAPPED", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ServiceHandle", "ConfigId", "pInput", "InputLength", "pOutput", "OutputLength", "pReturnLength", "pOverlapped"]),
        #
        'HttpGetExtension': SimTypeFunction([SimStruct({"HttpApiMajorVersion": SimTypeShort(signed=False, label="UInt16"), "HttpApiMinorVersion": SimTypeShort(signed=False, label="UInt16")}, name="HTTPAPI_VERSION", pack=False, align=None), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["Version", "Extension", "Buffer", "BufferSize"]),
    }

lib.set_prototypes(prototypes)
