"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = _default;
var _configSchema = require("@osd/config-schema");
var _common = require("../../common");
var _helpers = require("./utils/helpers");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

function _default(router) {
  // Get all configs from Notifications
  router.get({
    path: _common.REPORTING_NOTIFICATIONS_DASHBOARDS_API.GET_CONFIGS,
    validate: {
      query: _configSchema.schema.object({
        from_index: _configSchema.schema.number(),
        max_items: _configSchema.schema.number(),
        query: _configSchema.schema.maybe(_configSchema.schema.string()),
        config_type: _configSchema.schema.oneOf([_configSchema.schema.arrayOf(_configSchema.schema.string()), _configSchema.schema.string()]),
        feature_list: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.arrayOf(_configSchema.schema.string()), _configSchema.schema.string()])),
        is_enabled: _configSchema.schema.maybe(_configSchema.schema.boolean()),
        sort_field: _configSchema.schema.string(),
        sort_order: _configSchema.schema.string(),
        config_id_list: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.arrayOf(_configSchema.schema.string()), _configSchema.schema.string()]))
      })
    }
  }, async (context, request, response) => {
    const config_type = (0, _helpers.joinRequestParams)(request.query.config_type);
    const feature_list = (0, _helpers.joinRequestParams)(request.query.feature_list);
    const config_id_list = (0, _helpers.joinRequestParams)(request.query.config_id_list);
    const query = request.query.query;
    // @ts-ignore
    const client = context.reporting_plugin.notificationsClient.asScoped(request);
    try {
      const resp = await client.callAsCurrentUser('notifications.getConfigs', {
        from_index: request.query.from_index,
        max_items: request.query.max_items,
        is_enabled: request.query.is_enabled,
        sort_field: request.query.sort_field,
        sort_order: request.query.sort_order,
        config_type,
        ...(feature_list && {
          feature_list
        }),
        ...(query && {
          query
        }),
        ...(config_id_list && {
          config_id_list
        })
      });
      return response.ok({
        body: resp
      });
    } catch (error) {
      return response.custom({
        statusCode: error.statusCode || 500,
        body: error.message
      });
    }
  });

  // get event by id
  router.get({
    path: `${_common.REPORTING_NOTIFICATIONS_DASHBOARDS_API.GET_EVENT}/{eventId}`,
    validate: {
      params: _configSchema.schema.object({
        eventId: _configSchema.schema.string()
      })
    }
  }, async (context, request, response) => {
    // @ts-ignore
    const client = context.reporting_plugin.notificationsClient.asScoped(request);
    try {
      const resp = await client.callAsCurrentUser('notifications.getEventById', {
        eventId: request.params.eventId
      });
      return response.ok({
        body: resp
      });
    } catch (error) {
      return response.custom({
        statusCode: error.statusCode || 500,
        body: error.message
      });
    }
  });

  // Send test message
  router.get({
    path: `${_common.REPORTING_NOTIFICATIONS_DASHBOARDS_API.SEND_TEST_MESSAGE}/{configId}`,
    validate: {
      params: _configSchema.schema.object({
        configId: _configSchema.schema.string()
      }),
      query: _configSchema.schema.object({
        feature: _configSchema.schema.string()
      })
    }
  }, async (context, request, response) => {
    // @ts-ignore
    const client = context.reporting_plugin.notificationsClient.asScoped(request);
    try {
      const resp = await client.callAsCurrentUser('notifications.sendTestMessage', {
        configId: request.params.configId,
        feature: request.query.feature
      });
      return response.ok({
        body: resp
      });
    } catch (error) {
      return response.custom({
        statusCode: error.statusCode || 500,
        body: error.message
      });
    }
  });
}
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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