/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.build;

import aQute.bnd.build.Workspace;
import aQute.bnd.classindex.ClassIndexerAnalyzer;
import aQute.bnd.exceptions.Exceptions;
import aQute.bnd.osgi.BundleId;
import aQute.bnd.osgi.Descriptors;
import aQute.bnd.osgi.resource.RequirementBuilder;
import aQute.bnd.osgi.resource.ResourceUtils;
import aQute.bnd.result.Result;
import aQute.bnd.version.Version;
import aQute.lib.collections.MultiMap;
import aQute.lib.hierarchy.NamedNode;
import aQute.lib.zip.JarIndex;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;
import org.osgi.service.repository.Repository;

class WorkspaceClassIndex
implements AutoCloseable {
    final Workspace workspace;

    WorkspaceClassIndex(Workspace workspace) {
        this.workspace = workspace;
    }

    Result<Map<String, List<BundleId>>> search(String partialFqn) throws Exception {
        Result<String[]> determine = Descriptors.determine(partialFqn);
        if (determine.isErr()) {
            return determine.asError();
        }
        String[] parts = determine.unwrap();
        String packageName = parts[0];
        String className = parts[1];
        return this.search(packageName, className);
    }

    public Result<Map<String, List<BundleId>>> search(String packageName, String className) throws Exception {
        String filter = this.createFilter(packageName, className);
        Map<Resource, List<Capability>> index = this.getMatchingResources(filter);
        MultiMap<BundleId, String> result = new MultiMap<BundleId, String>();
        for (Map.Entry<Resource, List<Capability>> e : index.entrySet()) {
            Resource resource = e.getKey();
            BundleId bundle = ResourceUtils.getBundleId(resource);
            if (bundle == null) continue;
            if (packageName != null && className == null) {
                this.addLongestMatchingPackagePrefix(packageName, e.getValue(), bundle, result);
                continue;
            }
            assert (className != null) : "we handle pack !class, class || package class left";
            String binaryClassPath = Descriptors.classToPath(className);
            String error = this.matchClassNameAgainstResource(binaryClassPath, e.getValue(), bundle, result);
            if (error == null) continue;
            return Result.err(error);
        }
        return Result.ok(result.transpose(true));
    }

    private String matchClassNameAgainstResource(String binaryClassName, List<Capability> caps, BundleId bundle, MultiMap<BundleId, String> result) {
        try {
            Result<File> r = this.workspace.getBundle(bundle.getBsn(), Version.valueOf(bundle.getVersion()), null);
            if (r.isErr()) {
                return r.error().get();
            }
            JarIndex zipIndex = new JarIndex(r.unwrap());
            for (Capability cap : caps) {
                String foundPackage = (String)cap.getAttributes().get("osgi.wiring.package");
                if (foundPackage == null) continue;
                String[] foundPath = foundPackage.split("\\.");
                zipIndex.findFolder(foundPath).ifPresent(folder -> {
                    NamedNode clazz = folder.get(binaryClassName).orElse(null);
                    if (clazz != null) {
                        String path = clazz.path();
                        String fqn = Descriptors.binaryClassToFQN(path);
                        result.add(bundle, fqn);
                        return;
                    }
                });
            }
        }
        catch (IOException e1) {
            return Exceptions.causes(e1);
        }
        return null;
    }

    private void addLongestMatchingPackagePrefix(String packageName, List<Capability> caps, BundleId bundle, MultiMap<BundleId, String> result) {
        caps.stream().map(cap -> cap.getAttributes().get("osgi.wiring.package")).filter(Objects::nonNull).map(String.class::cast).filter(s -> s.startsWith(packageName)).sorted((a, b) -> Integer.compare(a.length(), b.length())).findFirst().ifPresent(s -> result.add(bundle, (String)s));
    }

    private Map<Resource, List<Capability>> getMatchingResources(String filter) throws Exception {
        RequirementBuilder rb = new RequirementBuilder("osgi.wiring.package");
        rb.filter(filter);
        Requirement requirement = rb.buildSyntheticRequirement();
        Repository repository = this.workspace.getResourceRepository(Workspace.ResourceRepositoryStrategy.ALL);
        Collection caps = (Collection)repository.findProviders(Collections.singleton(requirement)).get(requirement);
        Map<Resource, List<Capability>> index = ResourceUtils.getIndexedByResource(caps);
        return index;
    }

    private String createFilter(String packageName, String className) {
        StringBuilder sb = new StringBuilder();
        assert (packageName != null || className != null) : "Only 3 case, cannot both be null";
        if (className != null) {
            if (packageName == null) {
                int hash = ClassIndexerAnalyzer.hash(className);
                sb.append('(').append("bnd.hashes").append('=').append(hash).append(')');
            } else {
                sb.append('(').append("osgi.wiring.package").append('=').append(packageName).append(')');
            }
        } else {
            assert (packageName != null && className == null) : "lonely package, use wildcard, could be prefix";
            sb.append('(').append("osgi.wiring.package").append('=').append(packageName).append('*').append(')');
        }
        return sb.toString();
    }

    @Override
    public void close() {
    }
}

