ONLY_FOR_ARCHS =	${GO_ARCHS}

MODGO_MODNAME =		github.com/elastic/beats/v7
MODGO_VERSION =		v7.12.1

DISTNAME =		beats-${MODGO_VERSION}
PKGNAME =		${BEAT}-${MODGO_VERSION:S/v//}

CATEGORIES =		sysutils

HOMEPAGE =		https://www.elastic.co/beats/${BEAT}

MAINTAINER =		Pavel Korovin <pvk@openbsd.org>

# Apachev2
PERMIT_PACKAGE =	Yes

WANTLIB +=		c pthread

MODULES =		lang/go

ALL_TARGET =		github.com/elastic/beats/v7/${BEAT}

WRKDIST =		${WRKDIR}/${MODGO_MODNAME}@${MODGO_VERSION}

MODGO_SUBDIR =		${WRKSRC}/${BEAT}

CONFIGS ?=		${BEAT}.{reference.yml,yml} modules.d
SUBST_TARGETS =		${WRKSRC}/libbeat/cfgfile/cfgfile.go
SUBST_VARS =		BEAT

post-patch:
	${SUBST_CMD} ${SUBST_TARGETS}

.if defined(KIBANA_DASHBOARDS) && ${KIBANA_DASHBOARDS:L} == "yes"
MODULES +=		lang/python
MODPY_RUNDEP =		No
post-build:
	cd ${WRKSRC}/${BEAT} && \
	find . -type d -path \*_meta/\* -name kibana \
		-exec cp -R '{}' '{}'.generated \; && \
	find . -type d -path \*_meta/kibana.generated\* -name dashboard -exec \
		${MODPY_BIN} ../libbeat/scripts/unpack_dashboards.py --glob='{}'/*.json \;
.endif

post-install:
	${INSTALL_DATA_DIR} ${PREFIX}/share/examples/${BEAT}/
.for c in ${CONFIGS}
	cp -R ${WRKSRC}/${BEAT}/$c ${PREFIX}/share/examples/${BEAT}/
.endfor
.if defined(BEATS_MODULES) && ${BEATS_MODULES:L} == "yes"
	${INSTALL_DATA_DIR} ${PREFIX}/share/${BEAT}/module/
	cd ${WRKSRC}/${BEAT}/module && \
		find . -type f -name \*.yml -a \! -name \*docker-compose\.yml \
			-o -name \*.json -a \! -name \*expected\.json | \
		grep -v _meta | pax -rw ${PREFIX}/share/${BEAT}/module/
.endif
.if defined(KIBANA_DASHBOARDS) && ${KIBANA_DASHBOARDS:L} == "yes"
	${INSTALL_DATA_DIR} ${PREFIX}/share/${BEAT}/kibana/7/dashboard
	cd ${WRKSRC}/${BEAT} && \
		find . -type f -path \*kibana.generated/\* -name \*.json -exec \
		${INSTALL_DATA} '{}' ${PREFIX}/share/${BEAT}/kibana/7/dashboard \;
.endif

MODGO_MODULES =	\
	4d63.com/embedfiles					 v0.0.0-20190311033909-995e0740726f \
	4d63.com/tz						 v1.1.1-0.20191124060701-6d37baae851b \
	bazil.org/fuse						 v0.0.0-20160811212531-371fbbdaa898 \
	cloud.google.com/go					 v0.51.0 \
	cloud.google.com/go/bigquery				 v1.0.1 \
	cloud.google.com/go/datastore				 v1.0.0 \
	cloud.google.com/go/pubsub				 v1.0.1 \
	cloud.google.com/go/storage				 v1.0.0 \
	code.cloudfoundry.org/go-diodes				 v0.0.0-20190809170250-f77fb823c7ee \
	code.cloudfoundry.org/go-loggregator			 v7.4.0+incompatible \
	code.cloudfoundry.org/gofileutils			 v0.0.0-20170111115228-4d0c80011a0f \
	code.cloudfoundry.org/rfc5424				 v0.0.0-20180905210152-236a6d29298a \
	dmitri.shuralyov.com/gpu/mtl				 v0.0.0-20190408044501-666a987793e9 \
	github.com/!azure/azure-amqp-common-go/v3		 v3.0.0 \
	github.com/!azure/azure-event-hubs-go/v3		 v3.1.2 \
	github.com/!azure/azure-pipeline-go			 v0.2.1 \
	github.com/!azure/azure-sdk-for-go			 v37.1.0+incompatible \
	github.com/!azure/azure-storage-blob-go			 v0.8.0 \
	github.com/!azure/go-amqp				 v0.12.6 \
	github.com/!azure/go-ansiterm				 v0.0.0-20170929234023-d6e3b3328b78 \
	github.com/!azure/go-autorest/autorest			 v0.9.6 \
	github.com/!azure/go-autorest/autorest/adal		 v0.8.2 \
	github.com/!azure/go-autorest/autorest/azure/auth	 v0.4.2 \
	github.com/!azure/go-autorest/autorest/azure/cli	 v0.3.1 \
	github.com/!azure/go-autorest/autorest/date		 v0.2.0 \
	github.com/!azure/go-autorest/autorest/mocks		 v0.3.0 \
	github.com/!azure/go-autorest/autorest/to		 v0.3.0 \
	github.com/!azure/go-autorest/autorest/validation	 v0.2.0 \
	github.com/!azure/go-autorest/logger			 v0.1.0 \
	github.com/!azure/go-autorest/tracing			 v0.5.0 \
	github.com/!burnt!sushi/toml				 v0.3.1 \
	github.com/!burnt!sushi/xgb				 v0.0.0-20160522181843-27f122750802 \
	github.com/!data!dog/zstd				 v1.4.1 \
	github.com/!masterminds/semver				 v1.4.2 \
	github.com/!microsoft/go-winio				 v0.4.15-0.20190919025122-fc70bd9a86b5 \
	github.com/!microsoft/hcsshim				 v0.8.7 \
	github.com/!n!y!times/gziphandler			 v0.0.0-20170623195520-56545f4a5d46 \
	github.com/!one!of!one/xxhash				 v1.2.2 \
	github.com/!puerkito!bio/purell				 v1.0.0 \
	github.com/!puerkito!bio/urlesc				 v0.0.0-20160726150825-5bd2802263f2 \
	github.com/!shopify/sarama				 v0.0.0-00010101000000-000000000000 \
	github.com/!shopify/toxiproxy				 v2.1.4+incompatible \
	github.com/!stack!exchange/wmi				 v0.0.0-20170221213301-9f32b5905fd6 \
	github.com/adriansr/fsnotify				 v0.0.0-20180417234312-c9bbe1f46f1d \
	github.com/adriansr/gopacket				 v1.1.18-0.20200327165309-dd62abfa8a41 \
	github.com/aerospike/aerospike-client-go		 v1.27.1-0.20170612174108-0f3b54da6bdc \
	github.com/akavel/rsrc					 v0.8.0 \
	github.com/alecthomas/template				 v0.0.0-20190718012654-fb15b899a751 \
	github.com/alecthomas/units				 v0.0.0-20190717042225-c3de453c63f4 \
	github.com/andrewkroh/goja				 v0.0.0-20190128172624-dd2ac4456e20 \
	github.com/andrewkroh/sys				 v0.0.0-20151128191922-287798fe3e43 \
	github.com/antihax/optional				 v0.0.0-20180407024304-ca021399b1a6 \
	github.com/antlr/antlr4					 v0.0.0-20200820155224-be881fa6b91d \
	github.com/apoydence/eachers				 v0.0.0-20181020210610-23942921fe77 \
	github.com/armon/consul-api				 v0.0.0-20180202201655-eb2c6b5be1b6 \
	github.com/armon/go-radix				 v1.0.0 \
	github.com/armon/go-socks5				 v0.0.0-20160902184237-e75332964ef5 \
	github.com/aws/aws-lambda-go				 v1.6.0 \
	github.com/aws/aws-sdk-go-v2				 v0.9.0 \
	github.com/awslabs/goformation/v3			 v3.1.0 \
	github.com/awslabs/goformation/v4			 v4.1.0 \
	github.com/beorn7/perks					 v1.0.1 \
	github.com/bi-zone/go-winio				 v0.4.15 \
	github.com/blakerouse/service				 v1.1.1-0.20200924160513-057808572ffa \
	github.com/blakesmith/ar				 v0.0.0-20150311145944-8bd4349a67f2 \
	github.com/blang/semver					 v3.1.0+incompatible \
	github.com/bsm/sarama-cluster				 v2.1.14-0.20180625083203-7e67d87a6b3f+incompatible \
	github.com/cavaliercoder/badio				 v0.0.0-20160213150051-ce5280129e9e \
	github.com/cavaliercoder/go-rpm				 v0.0.0-20190131055624-7a9c54e3d83e \
	github.com/census-instrumentation/opencensus-proto	 v0.2.1 \
	github.com/cespare/xxhash				 v1.1.0 \
	github.com/cespare/xxhash/v2				 v2.1.1 \
	github.com/chzyer/logex					 v1.1.10 \
	github.com/chzyer/readline				 v0.0.0-20180603132655-2972be24d48e \
	github.com/chzyer/test					 v0.0.0-20180213035817-a1ea475d72b1 \
	github.com/client9/misspell				 v0.3.4 \
	github.com/cloudfoundry-community/go-cfclient		 v0.0.0-20190808214049-35bcce23fc5f \
	github.com/cloudfoundry/noaa				 v2.1.0+incompatible \
	github.com/cloudfoundry/sonde-go			 v0.0.0-20171206171820-b33733203bb4 \
	github.com/cncf/udpa/go					 v0.0.0-20191209042840-269d4d468f6f \
	github.com/codegangsta/inject				 v0.0.0-20150114235600-33e0aa1cb7c0 \
	github.com/containerd/cgroups				 v0.0.0-20190919134610-bf292b21730f \
	github.com/containerd/console				 v0.0.0-20180822173158-c12b1e7919c1 \
	github.com/containerd/containerd			 v1.3.3 \
	github.com/containerd/continuity			 v0.0.0-20200107194136-26c1120b8d41 \
	github.com/containerd/fifo				 v0.0.0-20190816180239-bda0ff6ed73c \
	github.com/containerd/go-runc				 v0.0.0-20180907222934-5a6d9f37cfa3 \
	github.com/containerd/ttrpc				 v0.0.0-20190828154514-0e0f228740de \
	github.com/containerd/typeurl				 v0.0.0-20180627222232-a93fcdb778cd \
	github.com/coreos/etcd					 v3.3.10+incompatible \
	github.com/coreos/go-etcd				 v2.0.0+incompatible \
	github.com/coreos/go-semver				 v0.2.0 \
	github.com/coreos/go-systemd				 v0.0.0-20190321100706-95778dfbb74e \
	github.com/coreos/go-systemd/v22			 v22.0.0 \
	github.com/coreos/pkg					 v0.0.0-20180108230652-97fdf19511ea \
	github.com/cpuguy83/go-md2man				 v1.0.10 \
	github.com/creack/pty					 v1.1.9 \
	github.com/cucumber/godog				 v0.8.1 \
	github.com/cyphar/filepath-securejoin			 v0.2.2 \
	github.com/davecgh/go-spew				 v1.1.1 \
	github.com/davecgh/go-xdr				 v0.0.0-20161123171359-e6a2ba005892 \
	github.com/denisenkom/go-mssqldb			 v0.0.0-20200206145737-bbfc9a55622e \
	github.com/devigned/tab					 v0.1.2-0.20190607222403-0c15cf42f9a2 \
	github.com/dgraph-io/badger/v2				 v2.2007.3-0.20201012072640-f5a7e0a1c83b \
	github.com/dgraph-io/ristretto				 v0.0.3-0.20200630154024-f66de99634de \
	github.com/dgrijalva/jwt-go				 v3.2.1-0.20190620180102-5e25c22bd5d6+incompatible \
	github.com/dgryski/go-farm				 v0.0.0-20190423205320-6a90982ecee2 \
	github.com/digitalocean/go-libvirt			 v0.0.0-20180301200012-6075ea3c39a1 \
	github.com/dimchansky/utfbom				 v1.1.0 \
	github.com/dlclark/regexp2				 v1.1.7-0.20171009020623-7632a260cbaf \
	github.com/docker/distribution				 v2.7.1+incompatible \
	github.com/docker/docker				 v1.4.2-0.20170802015333-8af4db6f002a \
	github.com/docker/engine				 v0.0.0-20191113042239-ea84732a7725 \
	github.com/docker/go-connections			 v0.4.0 \
	github.com/docker/go-metrics				 v0.0.1 \
	github.com/docker/go-plugins-helpers			 v0.0.0-20181025120712-1e6269c305b8 \
	github.com/docker/go-units				 v0.4.0 \
	github.com/docker/spdystream				 v0.0.0-20160310174837-449fdfce4d96 \
	github.com/docopt/docopt-go				 v0.0.0-20180111231733-ee0de3bc6815 \
	github.com/dop251/goja					 v0.0.0-00010101000000-000000000000 \
	github.com/dop251/goja_nodejs				 v0.0.0-20171011081505-adff31b136e6 \
	github.com/dustin/go-humanize				 v1.0.0 \
	github.com/eapache/go-resiliency			 v1.2.0 \
	github.com/eapache/go-xerial-snappy			 v0.0.0-20180814174437-776d5712da21 \
	github.com/eapache/queue				 v1.1.0 \
	github.com/eclipse/paho.mqtt.golang			 v1.2.1-0.20200121105743-0d940dd29fd2 \
	github.com/elastic/dhcp					 v0.0.0-20200227161230-57ec251c7eb3 \
	github.com/elastic/ecs					 v1.8.0 \
	github.com/elastic/elastic-agent-client/v7		 v7.0.0-20200709172729-d43b7ad5833a \
	github.com/elastic/fsevents				 v0.0.0-20181029231046-e1d381a4d270 \
	github.com/elastic/go-concert				 v0.1.0 \
	github.com/elastic/go-libaudit/v2			 v2.2.0 \
	github.com/elastic/go-licenser				 v0.3.1 \
	github.com/elastic/go-lookslike				 v0.3.0 \
	github.com/elastic/go-lumber				 v0.1.0 \
	github.com/elastic/go-perf				 v0.0.0-20191212140718-9c656876f595 \
	github.com/elastic/go-plugins-helpers			 v0.0.0-20200207104224-bdf17607b79f \
	github.com/elastic/go-seccomp-bpf			 v1.1.0 \
	github.com/elastic/go-structform			 v0.0.7 \
	github.com/elastic/go-sysinfo				 v1.6.0 \
	github.com/elastic/go-txfile				 v0.0.7 \
	github.com/elastic/go-ucfg				 v0.8.3 \
	github.com/elastic/go-windows				 v1.0.1 \
	github.com/elastic/gosigar				 v0.14.1 \
	github.com/elastic/sarama				 v1.19.1-0.20210120173147-5c8cb347d877 \
	github.com/elazarl/goproxy				 v0.0.0-20180725130230-947c36da3153 \
	github.com/emicklei/go-restful				 v0.0.0-20170410110728-ff4f55a20633 \
	github.com/envoyproxy/go-control-plane			 v0.9.4 \
	github.com/envoyproxy/protoc-gen-validate		 v0.1.0 \
	github.com/evanphx/json-patch				 v4.9.0+incompatible \
	github.com/fatih/color					 v1.9.0 \
	github.com/fortytw2/leaktest				 v1.3.0 \
	github.com/frankban/quicktest				 v1.10.2 \
	github.com/fsnotify/fsevents				 v0.1.1 \
	github.com/fsnotify/fsnotify				 v1.4.9 \
	github.com/ghodss/yaml					 v1.0.0 \
	github.com/go-gl/glfw/v3.3/glfw				 v0.0.0-20191125211704-12ad95a8df72 \
	github.com/go-kit/kit					 v0.9.0 \
	github.com/go-logfmt/logfmt				 v0.4.0 \
	github.com/go-logr/logr					 v0.2.0 \
	github.com/go-martini/martini				 v0.0.0-20170121215854-22fa46961aab \
	github.com/go-ole/go-ole				 v1.2.5-0.20190920104607-14974a1cf647 \
	github.com/go-openapi/jsonpointer			 v0.0.0-20160704185906-46af16f9f7b1 \
	github.com/go-openapi/jsonreference			 v0.0.0-20160704190145-13c6e3589ad9 \
	github.com/go-openapi/spec				 v0.0.0-20160808142527-6aced65f8501 \
	github.com/go-openapi/swag				 v0.0.0-20160704191624-1d0bd113de87 \
	github.com/go-sourcemap/sourcemap			 v2.1.2+incompatible \
	github.com/go-sql-driver/mysql				 v1.4.1 \
	github.com/go-stack/stack				 v1.8.0 \
	github.com/go-test/deep					 v1.0.7 \
	github.com/gobuffalo/here				 v0.6.0 \
	github.com/gocarina/gocsv				 v0.0.0-20170324095351-ffef3ffc77be \
	github.com/godbus/dbus					 v0.0.0-20190422162347-ade71ed3457e \
	github.com/godbus/dbus/v5				 v5.0.3 \
	github.com/godror/godror				 v0.10.4 \
	github.com/gofrs/flock					 v0.7.2-0.20190320160742-5135e617513b \
	github.com/gofrs/uuid					 v3.3.0+incompatible \
	github.com/gogo/protobuf				 v1.3.1 \
	github.com/golang-sql/civil				 v0.0.0-20190719163853-cb61b32ac6fe \
	github.com/golang/glog					 v0.0.0-20160126235308-23def4e6c14b \
	github.com/golang/groupcache				 v0.0.0-20191227052852-215e87163ea7 \
	github.com/golang/mock					 v1.3.1 \
	github.com/golang/protobuf				 v1.4.2 \
	github.com/golang/snappy				 v0.0.1 \
	github.com/gomodule/redigo				 v1.8.3 \
	github.com/google/btree					 v1.0.0 \
	github.com/google/flatbuffers				 v1.7.2-0.20170925184458-7a6b2bf521e9 \
	github.com/google/go-cmp				 v0.5.2 \
	github.com/google/gofuzz				 v1.1.0 \
	github.com/google/gopacket				 v1.1.18-0.20191009163724-0ad7f2610e34 \
	github.com/google/licenseclassifier			 v0.0.0-20200402202327-879cb1424de0 \
	github.com/google/martian				 v2.1.0+incompatible \
	github.com/google/pprof					 v0.0.0-20191218002539-d4f498aebedc \
	github.com/google/renameio				 v0.1.0 \
	github.com/google/shlex					 v0.0.0-20191202100458-e7afc7fbc510 \
	github.com/google/uuid					 v1.1.2-0.20190416172445-c2e93f3ae59f \
	github.com/googleapis/gax-go/v2				 v2.0.5 \
	github.com/googleapis/gnostic				 v0.4.1 \
	github.com/gopherjs/gopherjs				 v0.0.0-20181017120253-0766667cb4d1 \
	github.com/gorhill/cronexpr				 v0.0.0-20180427100037-88b0669f7d75 \
	github.com/gorilla/mux					 v1.7.2 \
	github.com/gorilla/websocket				 v1.4.1 \
	github.com/gregjones/httpcache				 v0.0.0-20180305231024-9cad4c3443a7 \
	github.com/grpc-ecosystem/grpc-gateway			 v1.13.0 \
	github.com/h2non/filetype				 v1.1.1-0.20201130172452-f60988ab73d5 \
	github.com/hashicorp/errwrap				 v1.0.0 \
	github.com/hashicorp/go-cleanhttp			 v0.5.1 \
	github.com/hashicorp/go-hclog				 v0.9.2 \
	github.com/hashicorp/go-multierror			 v1.1.0 \
	github.com/hashicorp/go-retryablehttp			 v0.6.6 \
	github.com/hashicorp/go-rootcerts			 v1.0.2 \
	github.com/hashicorp/go-uuid				 v1.0.2 \
	github.com/hashicorp/go-version				 v1.0.0 \
	github.com/hashicorp/golang-lru				 v0.5.2-0.20190520140433-59383c442f7d \
	github.com/hashicorp/hcl				 v1.0.0 \
	github.com/hashicorp/nomad/api				 v0.0.0-20200303134319-e31695b5bbe6 \
	github.com/hectane/go-acl				 v0.0.0-20190604041725-da78bae5fc95 \
	github.com/hpcloud/tail					 v1.0.0 \
	github.com/ianlancetaylor/demangle			 v0.0.0-20181102032728-5e5cf60278f6 \
	github.com/imdario/mergo				 v0.3.6 \
	github.com/inconshreveable/mousetrap			 v1.0.0 \
	github.com/insomniacslk/dhcp				 v0.0.0-20180716145214-633285ba52b2 \
	github.com/jarcoal/httpmock				 v1.0.4 \
	github.com/jcmturner/gofork				 v1.0.0 \
	github.com/jessevdk/go-flags				 v1.4.0 \
	github.com/jmespath/go-jmespath				 v0.0.0-20180206201540-c2b33e8439af \
	github.com/jmoiron/sqlx					 v1.2.1-0.20190826204134-d7d95172beb5 \
	github.com/joeshaw/multierror				 v0.0.0-20140124173710-69b34d4ec901 \
	github.com/joho/godotenv				 v1.3.0 \
	github.com/jonboulle/clockwork				 v0.2.2 \
	github.com/josephspurrier/goversioninfo			 v0.0.0-20190209210621-63e6d1acd3dd \
	github.com/jpillora/backoff				 v1.0.0 \
	github.com/json-iterator/go				 v1.1.10 \
	github.com/jstemmer/go-junit-report			 v0.9.1 \
	github.com/jtolds/gls					 v4.20.0+incompatible \
	github.com/julienschmidt/httprouter			 v1.2.0 \
	github.com/kardianos/service				 v1.1.0 \
	github.com/karrick/godirwalk				 v1.15.6 \
	github.com/kisielk/errcheck				 v1.2.0 \
	github.com/kisielk/gotool				 v1.0.0 \
	github.com/klauspost/compress				 v1.11.0 \
	github.com/konsorten/go-windows-terminal-sequences	 v1.0.2 \
	github.com/kr/logfmt					 v0.0.0-20140226030751-b84e30acd515 \
	github.com/kr/pretty					 v0.2.1 \
	github.com/kr/pty					 v1.1.1 \
	github.com/kr/text					 v0.2.0 \
	github.com/lib/pq					 v1.1.2-0.20190507191818-2ff3cb3adc01 \
	github.com/magefile/mage				 v1.11.0 \
	github.com/magiconair/properties			 v1.8.0 \
	github.com/mailru/easyjson				 v0.7.1 \
	github.com/markbates/pkger				 v0.17.0 \
	github.com/martini-contrib/render			 v0.0.0-20150707142108-ec18f8345a11 \
	github.com/mattn/go-colorable				 v0.1.6 \
	github.com/mattn/go-ieproxy				 v0.0.0-20191113090002-7c0f6868bffe \
	github.com/mattn/go-isatty				 v0.0.12 \
	github.com/mattn/go-sqlite3				 v1.9.0 \
	github.com/matttproud/golang_protobuf_extensions	 v1.0.2-0.20181231171920-c182affec369 \
	github.com/miekg/dns					 v1.1.15 \
	github.com/mitchellh/go-homedir				 v1.1.0 \
	github.com/mitchellh/go-testing-interface		 v1.0.0 \
	github.com/mitchellh/gox				 v1.0.1 \
	github.com/mitchellh/hashstructure			 v0.0.0-20170116052023-ab25296c0f51 \
	github.com/mitchellh/iochan				 v1.0.0 \
	github.com/mitchellh/mapstructure			 v1.1.2 \
	github.com/modern-go/concurrent				 v0.0.0-20180306012644-bacd9c7ef1dd \
	github.com/modern-go/reflect2				 v1.0.1 \
	github.com/morikuni/aec					 v1.0.0 \
	github.com/munnerz/goautoneg				 v0.0.0-20120707110453-a547fc61f48d \
	github.com/mwitkow/go-conntrack				 v0.0.0-20161129095857-cc309e4a2223 \
	github.com/mxk/go-flowrate				 v0.0.0-20140419014527-cca7078d478f \
	github.com/niemeyer/pretty				 v0.0.0-20200227124842-a10e7caefd8e \
	github.com/oklog/ulid					 v1.3.1 \
	github.com/onsi/ginkgo					 v1.11.0 \
	github.com/onsi/gomega					 v1.7.0 \
	github.com/opencontainers/go-digest			 v1.0.0-rc1.0.20190228220655-ac19fd6e7483 \
	github.com/opencontainers/image-spec			 v1.0.2-0.20190823105129-775207bd45b6 \
	github.com/opencontainers/runc				 v1.0.0-rc9 \
	github.com/opencontainers/runtime-spec			 v1.0.1 \
	github.com/opencontainers/runtime-tools			 v0.0.0-20181011054405-1d69bd0f9c39 \
	github.com/otiai10/copy					 v1.2.0 \
	github.com/otiai10/curr					 v1.0.0 \
	github.com/otiai10/mint					 v1.3.1 \
	github.com/oxtoacart/bpool				 v0.0.0-20150712133111-4e1c5567d7c2 \
	github.com/pelletier/go-toml				 v1.2.0 \
	github.com/peterbourgon/diskv				 v2.0.1+incompatible \
	github.com/pierrec/lz4					 v2.5.2+incompatible \
	github.com/pierrre/gotestcover				 v0.0.0-20160517101806-924dca7d15f0 \
	github.com/pkg/errors					 v0.9.1 \
	github.com/pmezard/go-difflib				 v1.0.0 \
	github.com/poy/eachers					 v0.0.0-20181020210610-23942921fe77 \
	github.com/prometheus/client_golang			 v1.1.1-0.20190913103102-20428fa0bffc \
	github.com/prometheus/client_model			 v0.0.0-20190812154241-14fe0d1b01d4 \
	github.com/prometheus/common				 v0.7.0 \
	github.com/prometheus/procfs				 v0.0.11 \
	github.com/prometheus/prometheus			 v2.5.0+incompatible \
	github.com/rcrowley/go-metrics				 v0.0.0-20200313005456-10cdbea86bc0 \
	github.com/rogpeppe/fastuuid				 v1.2.0 \
	github.com/rogpeppe/go-internal				 v1.3.0 \
	github.com/russross/blackfriday				 v1.5.2 \
	github.com/samuel/go-parser				 v0.0.0-20130731160455-ca8abbf65d0e \
	github.com/samuel/go-thrift				 v0.0.0-20140522043831-2187045faa54 \
	github.com/sanathkr/go-yaml				 v0.0.0-20170819195128-ed9d249f429b \
	github.com/sanathkr/yaml				 v1.0.1-0.20170819201035-0056894fa522 \
	github.com/santhosh-tekuri/jsonschema			 v1.2.4 \
	github.com/satori/go.uuid				 v1.2.0 \
	github.com/sergi/go-diff				 v1.1.0 \
	github.com/shirou/gopsutil				 v3.20.12+incompatible \
	github.com/shopspring/decimal				 v1.2.0 \
	github.com/sirupsen/logrus				 v1.4.2 \
	github.com/smartystreets/assertions			 v0.0.0-20180927180507-b2de0cb4f26d \
	github.com/smartystreets/goconvey			 v0.0.0-20190330032615-68dc04aab96a \
	github.com/spaolacci/murmur3				 v1.1.0 \
	github.com/spf13/afero					 v1.2.2 \
	github.com/spf13/cast					 v1.3.0 \
	github.com/spf13/cobra					 v0.0.5 \
	github.com/spf13/jwalterweatherman			 v1.0.0 \
	github.com/spf13/pflag					 v1.0.5 \
	github.com/spf13/viper					 v1.3.2 \
	github.com/stretchr/objx				 v0.2.0 \
	github.com/stretchr/testify				 v1.6.1 \
	github.com/syndtr/gocapability				 v0.0.0-20170704070218-db04d3cc01c8 \
	github.com/tsg/go-daemon				 v0.0.0-20200207173439-e704b93fd89b \
	github.com/tsg/gopacket					 v0.0.0-20200626092518-2ab8e397a786 \
	github.com/ugorji/go					 v1.1.8 \
	github.com/ugorji/go/codec				 v1.1.8 \
	github.com/urfave/cli					 v0.0.0-20171014202726-7bc6a0acffa5 \
	github.com/urso/diag					 v0.0.0-20200210123136-21b3cc8eb797 \
	github.com/urso/go-bin					 v0.0.0-20180220135811-781c575c9f0e \
	github.com/urso/magetools				 v0.0.0-20190919040553-290c89e0c230 \
	github.com/urso/qcgen					 v0.0.0-20180131103024-0b059e7db4f4 \
	github.com/urso/sderr					 v0.0.0-20200210124243-c2a16f3d43ec \
	github.com/vbatts/tar-split				 v0.11.1 \
	github.com/vmware/govmomi				 v0.0.0-20170802214208-2cad15190b41 \
	github.com/xdg/scram					 v0.0.0-20180814205039-7eeb5667e42c \
	github.com/xdg/stringprep				 v1.0.0 \
	github.com/xeipuuv/gojsonpointer			 v0.0.0-20190905194746-02993c407bfb \
	github.com/xeipuuv/gojsonreference			 v0.0.0-20180127040603-bd5ef7bd5415 \
	github.com/xeipuuv/gojsonschema				 v0.0.0-20181112162635-ac52e6811b56 \
	github.com/xordataexchange/crypt			 v0.0.3-0.20170626215501-b2862e3d0a77 \
	github.com/yuin/gopher-lua				 v0.0.0-20170403160031-b402f3114ec7 \
	go.elastic.co/apm					 v1.8.1-0.20200909061013-2aef45b9cf4b \
	go.elastic.co/apm/module/apmelasticsearch		 v1.7.2 \
	go.elastic.co/apm/module/apmhttp			 v1.7.2 \
	go.elastic.co/ecszap					 v0.3.0 \
	go.elastic.co/fastjson					 v1.1.0 \
	go.elastic.co/go-licence-detector			 v0.4.0 \
	go.etcd.io/bbolt					 v1.3.4 \
	go.opencensus.io					 v0.22.2 \
	go.uber.org/atomic					 v1.5.0 \
	go.uber.org/goleak					 v1.0.0 \
	go.uber.org/multierr					 v1.3.0 \
	go.uber.org/tools					 v0.0.0-20190618225709-2cfd321de3ee \
	go.uber.org/zap						 v1.14.0 \
	golang.org/x/crypto					 v0.0.0-20200820211705-5c72a883971a \
	golang.org/x/exp					 v0.0.0-20191227195350-da58074b4299 \
	golang.org/x/image					 v0.0.0-20190802002840-cff245a6509b \
	golang.org/x/lint					 v0.0.0-20200130185559-910be7a94367 \
	golang.org/x/mobile					 v0.0.0-20190719004257-d2bd2a29d028 \
	golang.org/x/mod					 v0.3.0 \
	golang.org/x/net					 v0.0.0-20200904194848-62affa334b73 \
	golang.org/x/oauth2					 v0.0.0-20200107190931-bf48bf16ab8d \
	golang.org/x/sync					 v0.0.0-20200317015054-43a5402ce75a \
	golang.org/x/sys					 v0.0.0-20201009025420-dfb3f7c4e634 \
	golang.org/x/text					 v0.3.3 \
	golang.org/x/time					 v0.0.0-20191024005414-555d28b269f0 \
	golang.org/x/tools					 v0.0.0-20200602230032-c00d67ef29d0 \
	golang.org/x/tools					 v0.0.0-20200904185747-39188db58858 \
	golang.org/x/xerrors					 v0.0.0-20200804184101-5ec99f83aff1 \
	google.golang.org/api					 v0.15.0 \
	google.golang.org/appengine				 v1.6.5 \
	google.golang.org/genproto				 v0.0.0-20200526211855-cb27e3aa2013 \
	google.golang.org/grpc					 v1.29.1 \
	google.golang.org/protobuf				 v1.24.0 \
	gopkg.in/airbrake/gobrake.v2				 v2.0.9 \
	gopkg.in/alecthomas/kingpin.v2				 v2.2.6 \
	gopkg.in/check.v1					 v1.0.0-20200902074654-038fdea0a05b \
	gopkg.in/errgo.v2					 v2.1.0 \
	gopkg.in/fsnotify.v1					 v1.4.7 \
	gopkg.in/gemnasium/logrus-airbrake-hook.v2		 v2.1.2 \
	gopkg.in/inf.v0						 v0.9.1 \
	gopkg.in/jcmturner/aescts.v1				 v1.0.1 \
	gopkg.in/jcmturner/dnsutils.v1				 v1.0.1 \
	gopkg.in/jcmturner/goidentity.v3			 v3.0.0 \
	gopkg.in/jcmturner/gokrb5.v7				 v7.5.0 \
	gopkg.in/jcmturner/rpc.v1				 v1.1.0 \
	gopkg.in/mgo.v2						 v2.0.0-20160818020120-3f83fa500528 \
	gopkg.in/tomb.v1					 v1.0.0-20141024135613-dd632973f1e7 \
	gopkg.in/yaml.v2					 v2.3.0 \
	gopkg.in/yaml.v3					 v3.0.0-20200615113413-eeeca48fe776 \
	gotest.tools						 v2.2.0+incompatible \
	gotest.tools/gotestsum					 v0.6.0 \
	gotest.tools/v3						 v3.0.3 \
	honnef.co/go/tools					 v0.0.1-2019.2.3 \
	howett.net/plist					 v0.0.0-20181124034731-591f970eefbb \
	k8s.io/api						 v0.19.4 \
	k8s.io/apimachinery					 v0.19.4 \
	k8s.io/client-go					 v0.19.4 \
	k8s.io/gengo						 v0.0.0-20200413195148-3a45101e95ac \
	k8s.io/klog/v2						 v2.2.0 \
	k8s.io/kube-openapi					 v0.0.0-20200805222855-6aeccd4b50c6 \
	k8s.io/kubernetes					 v1.13.0 \
	k8s.io/utils						 v0.0.0-20200729134348-d5654de09c73 \
	rsc.io/binaryregexp					 v0.2.0 \
	sigs.k8s.io/structured-merge-diff/v4			 v4.0.1 \
	sigs.k8s.io/yaml					 v1.2.0

MODGO_MODFILES =	\
	cloud.google.com/go					 v0.26.0 \
	cloud.google.com/go					 v0.34.0 \
	cloud.google.com/go					 v0.38.0 \
	cloud.google.com/go					 v0.44.1 \
	cloud.google.com/go					 v0.44.2 \
	cloud.google.com/go					 v0.45.1 \
	cloud.google.com/go					 v0.46.3 \
	github.com/!azure/azure-pipeline-go			 v0.1.8 \
	github.com/!azure/azure-pipeline-go			 v0.1.9 \
	github.com/!azure/azure-storage-blob-go			 v0.6.0 \
	github.com/!azure/go-autorest/autorest			 v0.9.0 \
	github.com/!azure/go-autorest/autorest			 v0.9.3 \
	github.com/!azure/go-autorest/autorest/adal		 v0.5.0 \
	github.com/!azure/go-autorest/autorest/adal		 v0.8.0 \
	github.com/!azure/go-autorest/autorest/adal		 v0.8.1 \
	github.com/!azure/go-autorest/autorest/date		 v0.1.0 \
	github.com/!azure/go-autorest/autorest/mocks		 v0.1.0 \
	github.com/!azure/go-autorest/autorest/mocks		 v0.2.0 \
	github.com/alecthomas/template				 v0.0.0-20160405071501-a0175ee3bccc \
	github.com/alecthomas/units				 v0.0.0-20151022065526-2efee857e7cf \
	github.com/beorn7/perks					 v0.0.0-20180321164747-3a771d992973 \
	github.com/beorn7/perks					 v1.0.0 \
	github.com/containerd/containerd			 v1.3.0-beta.2.0.20190828155532-0293cbd26c69 \
	github.com/containerd/continuity			 v0.0.0-20190426062206-aaeac12a7ffc \
	github.com/containerd/fifo				 v0.0.0-20190226154929-a9fb20d87448 \
	github.com/davecgh/go-spew				 v1.1.0 \
	github.com/devigned/tab					 v0.1.1 \
	github.com/dgrijalva/jwt-go				 v3.2.0+incompatible \
	github.com/docker/go-units				 v0.3.3 \
	github.com/dustin/go-humanize				 v0.0.0-20171111073723-bb3d318650d4 \
	github.com/elastic/go-sysinfo				 v1.1.1 \
	github.com/elastic/go-ucfg				 v0.7.0 \
	github.com/elastic/go-windows				 v1.0.0 \
	github.com/envoyproxy/go-control-plane			 v0.9.0 \
	github.com/envoyproxy/go-control-plane			 v0.9.1-0.20191026205805-5f8ba28d4473 \
	github.com/fsnotify/fsnotify				 v1.4.7 \
	github.com/ghodss/yaml					 v0.0.0-20150909031657-73d445a93680 \
	github.com/go-kit/kit					 v0.8.0 \
	github.com/go-logfmt/logfmt				 v0.3.0 \
	github.com/go-logr/logr					 v0.1.0 \
	github.com/go-sql-driver/mysql				 v1.4.0 \
	github.com/gofrs/flock					 v0.7.1 \
	github.com/gogo/protobuf				 v1.1.1 \
	github.com/gogo/protobuf				 v1.2.1 \
	github.com/golang/groupcache				 v0.0.0-20190702054246-869f871628b6 \
	github.com/golang/mock					 v1.1.1 \
	github.com/golang/mock					 v1.2.0 \
	github.com/golang/protobuf				 v1.2.0 \
	github.com/golang/protobuf				 v1.3.1 \
	github.com/golang/protobuf				 v1.3.2 \
	github.com/golang/protobuf				 v1.3.3 \
	github.com/golang/protobuf				 v1.4.0 \
	github.com/golang/protobuf				 v1.4.0-rc.1 \
	github.com/golang/protobuf				 v1.4.0-rc.1.0.20200221234624-67d41d38c208 \
	github.com/golang/protobuf				 v1.4.0-rc.2 \
	github.com/golang/protobuf				 v1.4.0-rc.4.0.20200313231945-b860323f09d0 \
	github.com/golang/protobuf				 v1.4.1 \
	github.com/google/btree					 v0.0.0-20180813153112-4030bb1f1f0c \
	github.com/google/go-cmp				 v0.2.0 \
	github.com/google/go-cmp				 v0.3.0 \
	github.com/google/go-cmp				 v0.3.1 \
	github.com/google/go-cmp				 v0.4.0 \
	github.com/google/gofuzz				 v1.0.0 \
	github.com/google/pprof					 v0.0.0-20181206194817-3ea8567a2e57 \
	github.com/google/pprof					 v0.0.0-20190515194954-54271f7e092f \
	github.com/google/uuid					 v1.1.1 \
	github.com/googleapis/gax-go/v2				 v2.0.4 \
	github.com/hashicorp/errwrap				 v0.0.0-20141028054710-7554cd9344ce \
	github.com/hashicorp/go-multierror			 v0.0.0-20161216184304-ed905158d874 \
	github.com/hashicorp/golang-lru				 v0.5.0 \
	github.com/hashicorp/golang-lru				 v0.5.1 \
	github.com/imdario/mergo				 v0.3.5 \
	github.com/jonboulle/clockwork				 v0.1.0 \
	github.com/jpillora/backoff				 v0.0.0-20180909062703-3050d21c67d7 \
	github.com/json-iterator/go				 v1.1.6 \
	github.com/json-iterator/go				 v1.1.7 \
	github.com/jstemmer/go-junit-report			 v0.0.0-20190106144839-af01ea7f8024 \
	github.com/kisielk/errcheck				 v1.1.0 \
	github.com/konsorten/go-windows-terminal-sequences	 v1.0.1 \
	github.com/kr/pretty					 v0.1.0 \
	github.com/kr/pretty					 v0.2.0 \
	github.com/kr/text					 v0.1.0 \
	github.com/lib/pq					 v1.0.0 \
	github.com/magefile/mage				 v1.9.0 \
	github.com/mailru/easyjson				 v0.0.0-20160728113105-d5b7844b561a \
	github.com/mattn/go-colorable				 v0.1.4 \
	github.com/mattn/go-ieproxy				 v0.0.0-20190610004146-91bb50d98149 \
	github.com/mattn/go-isatty				 v0.0.11 \
	github.com/mattn/go-isatty				 v0.0.8 \
	github.com/matttproud/golang_protobuf_extensions	 v1.0.1 \
	github.com/modern-go/concurrent				 v0.0.0-20180228061459-e0a39a4cb421 \
	github.com/modern-go/reflect2				 v0.0.0-20180701023420-4b7aa43c6742 \
	github.com/onsi/ginkgo					 v0.0.0-20170829012221-11459a886d9c \
	github.com/onsi/ginkgo					 v1.10.1 \
	github.com/onsi/ginkgo					 v1.5.0 \
	github.com/onsi/ginkgo					 v1.6.0 \
	github.com/onsi/gomega					 v0.0.0-20170829124025-dcabb60a477c \
	github.com/onsi/gomega					 v1.2.0 \
	github.com/onsi/gomega					 v1.4.3 \
	github.com/opencontainers/go-digest			 v0.0.0-20180430190053-c9281466c8b2 \
	github.com/opencontainers/go-digest			 v1.0.0-rc1 \
	github.com/opencontainers/image-spec			 v1.0.1 \
	github.com/opencontainers/runc				 v0.0.0-20190115041553-12f6a991201f \
	github.com/opencontainers/runtime-spec			 v0.1.2-0.20190507144316-5b71a03e2700 \
	github.com/otiai10/curr					 v0.0.0-20150429015615-9b4961190c95 \
	github.com/otiai10/mint					 v1.3.0 \
	github.com/pkg/errors					 v0.8.0 \
	github.com/pkg/errors					 v0.8.1 \
	github.com/pkg/errors					 v0.8.1-0.20170505043639-c605e284fe17 \
	github.com/pkg/errors					 v0.8.1-0.20171018195549-f15c970de5b7 \
	github.com/prometheus/client_golang			 v0.9.1 \
	github.com/prometheus/client_golang			 v1.0.0 \
	github.com/prometheus/client_golang			 v1.1.0 \
	github.com/prometheus/client_model			 v0.0.0-20180712105110-5c3871d89910 \
	github.com/prometheus/client_model			 v0.0.0-20190129233127-fd36f4220a90 \
	github.com/prometheus/common				 v0.4.1 \
	github.com/prometheus/common				 v0.6.0 \
	github.com/prometheus/procfs				 v0.0.0-20181005140218-185b4288413d \
	github.com/prometheus/procfs				 v0.0.0-20190425082905-87a4384529e0 \
	github.com/prometheus/procfs				 v0.0.2 \
	github.com/prometheus/procfs				 v0.0.3 \
	github.com/prometheus/procfs				 v0.0.5 \
	github.com/sanathkr/yaml				 v0.0.0-20170819201035-0056894fa522 \
	github.com/sergi/go-diff				 v1.0.0 \
	github.com/sirupsen/logrus				 v1.0.4-0.20170822132746-89742aefa4b2 \
	github.com/sirupsen/logrus				 v1.2.0 \
	github.com/sirupsen/logrus				 v1.4.1 \
	github.com/spaolacci/murmur3				 v0.0.0-20180118202830-f09979ecbc72 \
	github.com/spf13/afero					 v1.1.2 \
	github.com/spf13/cobra					 v0.0.2-0.20171109065643-2da4a54c5cee \
	github.com/spf13/pflag					 v0.0.0-20170130214245-9ff6c6923cff \
	github.com/spf13/pflag					 v1.0.1-0.20171106142849-4c012f6dcd95 \
	github.com/spf13/pflag					 v1.0.3 \
	github.com/stretchr/objx				 v0.1.0 \
	github.com/stretchr/objx				 v0.1.1 \
	github.com/stretchr/testify				 v1.1.5-0.20170601210322-f6abca593680 \
	github.com/stretchr/testify				 v1.2.2 \
	github.com/stretchr/testify				 v1.3.0 \
	github.com/stretchr/testify				 v1.4.0 \
	github.com/stretchr/testify				 v1.5.0 \
	github.com/stretchr/testify				 v1.5.1 \
	github.com/ugorji/go/codec				 v0.0.0-20181204163529-d75b2dcb6bc8 \
	github.com/xeipuuv/gojsonpointer			 v0.0.0-20180127040702-4e3ac2762d5f \
	github.com/xeipuuv/gojsonschema				 v0.0.0-20180618132009-1d523034197f \
	go.elastic.co/apm					 v1.7.2 \
	go.elastic.co/fastjson					 v1.0.0 \
	go.opencensus.io					 v0.21.0 \
	go.opencensus.io					 v0.22.0 \
	golang.org/x/crypto					 v0.0.0-20171113213409-9f005a07e0d3 \
	golang.org/x/crypto					 v0.0.0-20180904163835-0709b304e793 \
	golang.org/x/crypto					 v0.0.0-20181203042331-505ab145d0a9 \
	golang.org/x/crypto					 v0.0.0-20190308221718-c2843e01d9a2 \
	golang.org/x/crypto					 v0.0.0-20190325154230-a5d413f7728c \
	golang.org/x/crypto					 v0.0.0-20190510104115-cbcb75029529 \
	golang.org/x/crypto					 v0.0.0-20190605123033-f99c8df09eb5 \
	golang.org/x/crypto					 v0.0.0-20191011191535-87dc89f01550 \
	golang.org/x/crypto					 v0.0.0-20191206172530-e9b2fee46413 \
	golang.org/x/crypto					 v0.0.0-20200622213623-75b288015ac9 \
	golang.org/x/exp					 v0.0.0-20190121172915-509febef88a4 \
	golang.org/x/exp					 v0.0.0-20190306152737-a1d7652674e8 \
	golang.org/x/exp					 v0.0.0-20190510132918-efd6b22b2522 \
	golang.org/x/exp					 v0.0.0-20190829153037-c13cbed26979 \
	golang.org/x/image					 v0.0.0-20190227222117-0694c2d4d067 \
	golang.org/x/lint					 v0.0.0-20181026193005-c67002cb31c3 \
	golang.org/x/lint					 v0.0.0-20190227174305-5b3e6a55c961 \
	golang.org/x/lint					 v0.0.0-20190301231843-5614ed5bae6f \
	golang.org/x/lint					 v0.0.0-20190313153728-d0100b6bd8b3 \
	golang.org/x/lint					 v0.0.0-20190409202823-959b441ac422 \
	golang.org/x/lint					 v0.0.0-20190909230951-414d861bb4ac \
	golang.org/x/lint					 v0.0.0-20190930215403-16217165b5de \
	golang.org/x/lint					 v0.0.0-20191125180803-fdd1cda4f05f \
	golang.org/x/mobile					 v0.0.0-20190312151609-d3739f865fa6 \
	golang.org/x/mod					 v0.0.0-20190513183733-4bf6d317e70e \
	golang.org/x/mod					 v0.1.0 \
	golang.org/x/net					 v0.0.0-20180724234803-3673e40ba225 \
	golang.org/x/net					 v0.0.0-20180826012351-8a410e7b638d \
	golang.org/x/net					 v0.0.0-20180906233101-161cd47e91fd \
	golang.org/x/net					 v0.0.0-20181114220301-adae6a3d119a \
	golang.org/x/net					 v0.0.0-20181201002055-351d144fa1fc \
	golang.org/x/net					 v0.0.0-20190108225652-1e06a53dbb7e \
	golang.org/x/net					 v0.0.0-20190213061140-3a22650c66bd \
	golang.org/x/net					 v0.0.0-20190311183353-d8887717615a \
	golang.org/x/net					 v0.0.0-20190404232315-eb5bcb51f2a3 \
	golang.org/x/net					 v0.0.0-20190501004415-9ce7a6920f09 \
	golang.org/x/net					 v0.0.0-20190503192946-f4e77d36d62c \
	golang.org/x/net					 v0.0.0-20190522155817-f3200d17e092 \
	golang.org/x/net					 v0.0.0-20190603091049-60506f45cf65 \
	golang.org/x/net					 v0.0.0-20190613194153-d28f0bde5980 \
	golang.org/x/net					 v0.0.0-20190620200207-3b0461eec859 \
	golang.org/x/net					 v0.0.0-20190724013045-ca1201d0de80 \
	golang.org/x/net					 v0.0.0-20191002035440-2ec189313ef0 \
	golang.org/x/net					 v0.0.0-20191021144547-ec77196f6094 \
	golang.org/x/net					 v0.0.0-20191112182307-2180aed22343 \
	golang.org/x/net					 v0.0.0-20191209160850-c0dbc17a3553 \
	golang.org/x/net					 v0.0.0-20200202094626-16171245cfb2 \
	golang.org/x/net					 v0.0.0-20200324143707-d3edc9973b7e \
	golang.org/x/net					 v0.0.0-20200707034311-ab3426394381 \
	golang.org/x/oauth2					 v0.0.0-20180821212333-d2e6202438be \
	golang.org/x/oauth2					 v0.0.0-20190130055435-99b60b757ec1 \
	golang.org/x/oauth2					 v0.0.0-20190226205417-e64efc72b421 \
	golang.org/x/oauth2					 v0.0.0-20190604053449-0f29369cfe45 \
	golang.org/x/oauth2					 v0.0.0-20191202225959-858c2ad4c8b6 \
	golang.org/x/sync					 v0.0.0-20180314180146-1d60e4601c6f \
	golang.org/x/sync					 v0.0.0-20181108010431-42b317875d0f \
	golang.org/x/sync					 v0.0.0-20181221193216-37e7f081c4d4 \
	golang.org/x/sync					 v0.0.0-20190227155943-e225da77a7e6 \
	golang.org/x/sync					 v0.0.0-20190423024810-112230192c58 \
	golang.org/x/sync					 v0.0.0-20190911185100-cd5d95a43a6e \
	golang.org/x/sys					 v0.0.0-20180810173357-98c5dad5d1a0 \
	golang.org/x/sys					 v0.0.0-20180830151530-49385e6e1522 \
	golang.org/x/sys					 v0.0.0-20180905080454-ebe1bf3edb33 \
	golang.org/x/sys					 v0.0.0-20180909124046-d0be0721c37e \
	golang.org/x/sys					 v0.0.0-20181116152217-5ac8a444bdc5 \
	golang.org/x/sys					 v0.0.0-20181205085412-a5c9d58dba9a \
	golang.org/x/sys					 v0.0.0-20190204203706-41f3e6584952 \
	golang.org/x/sys					 v0.0.0-20190215142949-d0b11bdaac8a \
	golang.org/x/sys					 v0.0.0-20190222072716-a9d3bda3a223 \
	golang.org/x/sys					 v0.0.0-20190312061237-fead79001313 \
	golang.org/x/sys					 v0.0.0-20190405154228-4b34438f7a67 \
	golang.org/x/sys					 v0.0.0-20190412213103-97732733099d \
	golang.org/x/sys					 v0.0.0-20190422165155-953cdadca894 \
	golang.org/x/sys					 v0.0.0-20190502145724-3ef323f4f1fd \
	golang.org/x/sys					 v0.0.0-20190507160741-ecd444e8653b \
	golang.org/x/sys					 v0.0.0-20190514135907-3a4b5fb9f71f \
	golang.org/x/sys					 v0.0.0-20190529164535-6a60838ec259 \
	golang.org/x/sys					 v0.0.0-20190606165138-5da285871e9c \
	golang.org/x/sys					 v0.0.0-20190624142023-c5567b49c5d0 \
	golang.org/x/sys					 v0.0.0-20190626221950-04f50cda93cb \
	golang.org/x/sys					 v0.0.0-20190801041406-cbf593c0f2f3 \
	golang.org/x/sys					 v0.0.0-20190813064441-fde4db37ae7a \
	golang.org/x/sys					 v0.0.0-20190916202348-b4ddaad3f8a3 \
	golang.org/x/sys					 v0.0.0-20191025021431-6c3a3bfe00ae \
	golang.org/x/sys					 v0.0.0-20191026070338-33540a1f6037 \
	golang.org/x/sys					 v0.0.0-20191112214154-59a1497f0cea \
	golang.org/x/sys					 v0.0.0-20191204072324-ce4227a45e2e \
	golang.org/x/sys					 v0.0.0-20191228213918-04cbcbbfeed8 \
	golang.org/x/sys					 v0.0.0-20200102141924-c96a22e43c9c \
	golang.org/x/sys					 v0.0.0-20200106162015-b016eb3dc98e \
	golang.org/x/sys					 v0.0.0-20200116001909-b77594299b42 \
	golang.org/x/sys					 v0.0.0-20200202164722-d101bd2416d5 \
	golang.org/x/sys					 v0.0.0-20200223170610-d5e6a3e2c0ae \
	golang.org/x/sys					 v0.0.0-20200323222414-85ca7c5b95cd \
	golang.org/x/sys					 v0.0.0-20200615200032-f1bc736245b1 \
	golang.org/x/sys					 v0.0.0-20200622214017-ed371f2e16b4 \
	golang.org/x/text					 v0.3.0 \
	golang.org/x/text					 v0.3.1-0.20180807135948-17ff2d5776d2 \
	golang.org/x/text					 v0.3.2 \
	golang.org/x/time					 v0.0.0-20181108054448-85acf8d2951c \
	golang.org/x/time					 v0.0.0-20190308202827-9d24e82272b4 \
	golang.org/x/tools					 v0.0.0-20180221164845-07fd8470d635 \
	golang.org/x/tools					 v0.0.0-20180917221912-90fa682c2a6e \
	golang.org/x/tools					 v0.0.0-20181011042414-1f849cf54d09 \
	golang.org/x/tools					 v0.0.0-20181030221726-6c7e314b6563 \
	golang.org/x/tools					 v0.0.0-20190114222345-bf090417da8b \
	golang.org/x/tools					 v0.0.0-20190226205152-f727befe758c \
	golang.org/x/tools					 v0.0.0-20190311212946-11955173bddd \
	golang.org/x/tools					 v0.0.0-20190312151545-0bb0c0a6e846 \
	golang.org/x/tools					 v0.0.0-20190312170243-e65039ee4138 \
	golang.org/x/tools					 v0.0.0-20190328211700-ab21143f2384 \
	golang.org/x/tools					 v0.0.0-20190425150028-36563e24a262 \
	golang.org/x/tools					 v0.0.0-20190506145303-2d16b83fe98c \
	golang.org/x/tools					 v0.0.0-20190524140312-2c0ae7006135 \
	golang.org/x/tools					 v0.0.0-20190606124116-d0a3d012864b \
	golang.org/x/tools					 v0.0.0-20190621195816-6e04913cbbac \
	golang.org/x/tools					 v0.0.0-20190624222133-a101b041ded4 \
	golang.org/x/tools					 v0.0.0-20190628153133-6cdbf07be9d0 \
	golang.org/x/tools					 v0.0.0-20190816200558-6889da9d5479 \
	golang.org/x/tools					 v0.0.0-20190911174233-4f2ddba30aff \
	golang.org/x/tools					 v0.0.0-20191012152004-8de300cfc20a \
	golang.org/x/tools					 v0.0.0-20191029041327-9cc4af7d6b2c \
	golang.org/x/tools					 v0.0.0-20191029190741-b9c20aec41a5 \
	golang.org/x/tools					 v0.0.0-20191108193012-7d206e10da11 \
	golang.org/x/tools					 v0.0.0-20191119224855-298f0cb1881e \
	golang.org/x/tools					 v0.0.0-20191125144606-a911d9008d1f \
	golang.org/x/tools					 v0.0.0-20191227053925-7b8e75db28f4 \
	golang.org/x/tools					 v0.0.0-20200130002326-2f3ba24bd6e7 \
	golang.org/x/tools					 v0.0.0-20200216192241-b320d3a0f5a2 \
	golang.org/x/tools					 v0.0.0-20200509030707-2212a7e161a5 \
	golang.org/x/xerrors					 v0.0.0-20190717185122-a985d3407aa7 \
	golang.org/x/xerrors					 v0.0.0-20191011141410-1b5146add898 \
	golang.org/x/xerrors					 v0.0.0-20191204190536-9bdfabe68543 \
	google.golang.org/api					 v0.4.0 \
	google.golang.org/api					 v0.7.0 \
	google.golang.org/api					 v0.8.0 \
	google.golang.org/api					 v0.9.0 \
	google.golang.org/appengine				 v1.1.0 \
	google.golang.org/appengine				 v1.2.0 \
	google.golang.org/appengine				 v1.4.0 \
	google.golang.org/appengine				 v1.5.0 \
	google.golang.org/appengine				 v1.6.1 \
	google.golang.org/genproto				 v0.0.0-20180817151627-c66870c02cf8 \
	google.golang.org/genproto				 v0.0.0-20190307195333-5fe7a883aa19 \
	google.golang.org/genproto				 v0.0.0-20190418145605-e7d98fc518a7 \
	google.golang.org/genproto				 v0.0.0-20190425155659-357c62f0e4bb \
	google.golang.org/genproto				 v0.0.0-20190502173448-54afdca5d873 \
	google.golang.org/genproto				 v0.0.0-20190801165951-fa694d86fc64 \
	google.golang.org/genproto				 v0.0.0-20190819201941-24fa4b261c55 \
	google.golang.org/genproto				 v0.0.0-20190911173649-1774047e7e51 \
	google.golang.org/genproto				 v0.0.0-20190927181202-20e1ac93f88c \
	google.golang.org/genproto				 v0.0.0-20191230161307-f3c370f40bfb \
	google.golang.org/grpc					 v1.19.0 \
	google.golang.org/grpc					 v1.20.1 \
	google.golang.org/grpc					 v1.21.1 \
	google.golang.org/grpc					 v1.23.0 \
	google.golang.org/grpc					 v1.24.0 \
	google.golang.org/grpc					 v1.25.1 \
	google.golang.org/grpc					 v1.26.0 \
	google.golang.org/grpc					 v1.27.0 \
	google.golang.org/grpc					 v1.27.1 \
	google.golang.org/protobuf				 v0.0.0-20200109180630-ec00e32a8dfd \
	google.golang.org/protobuf				 v0.0.0-20200221191635-4d8936d0db64 \
	google.golang.org/protobuf				 v0.0.0-20200228230310-ab0ca4ff8a60 \
	google.golang.org/protobuf				 v1.20.1-0.20200309200217-e05f789c0967 \
	google.golang.org/protobuf				 v1.21.0 \
	google.golang.org/protobuf				 v1.22.0 \
	google.golang.org/protobuf				 v1.23.0 \
	google.golang.org/protobuf				 v1.23.1-0.20200526195155-81db48ad09cc \
	gopkg.in/check.v1					 v0.0.0-20161208181325-20d25e280405 \
	gopkg.in/check.v1					 v1.0.0-20161208181325-20d25e280405 \
	gopkg.in/check.v1					 v1.0.0-20180628173108-788fd7840127 \
	gopkg.in/check.v1					 v1.0.0-20190902080502-41f04d3bba15 \
	gopkg.in/yaml.v2					 v2.2.1 \
	gopkg.in/yaml.v2					 v2.2.2 \
	gopkg.in/yaml.v2					 v2.2.3 \
	gopkg.in/yaml.v2					 v2.2.4 \
	gopkg.in/yaml.v2					 v2.2.7 \
	gopkg.in/yaml.v2					 v2.2.8 \
	gopkg.in/yaml.v3					 v3.0.0-20200313102051-9f266ea9e77c \
	honnef.co/go/tools					 v0.0.0-20190102054323-c2f93a96b099 \
	honnef.co/go/tools					 v0.0.0-20190106161140-3f1c8253044a \
	honnef.co/go/tools					 v0.0.0-20190418001031-e561f6794a2a \
	honnef.co/go/tools					 v0.0.0-20190523083050-ea95bdfd59fc \
	k8s.io/klog/v2						 v2.0.0 \
	sigs.k8s.io/yaml					 v1.1.0
