/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mpp;

import net.sf.mpxj.MpxjEnum;
import net.sf.mpxj.common.EnumHelper;
import net.sf.mpxj.common.NumberHelper;

public enum ChartPattern implements MpxjEnum
{
    TRANSPARENT(0, "Transparent"),
    SOLID(1, "Solid"),
    LIGHTDOTTED(2, "Light Dotted"),
    DOTTED(3, "Dotted"),
    HEAVYDOTTED(4, "Heavy Dotted"),
    BACKSLASH(5, "Back Slash"),
    FORWARDSLASH(6, "Forward Slash"),
    CHECKERED(7, "Checkered"),
    VERTICALSTRIPE(8, "Vertical Stripe"),
    HORIZONTALSTRIPE(9, "Horizontal Stripe"),
    GRID(10, "Grid"),
    SOLIDHAIRY(11, "Solid Hairy");

    private static final ChartPattern[] TYPE_VALUES;
    private int m_value;
    private String m_name;

    private ChartPattern(int n2, String string2) {
        this.m_value = n2;
        this.m_name = string2;
    }

    public static ChartPattern getInstance(int n) {
        if (n < 0 || n >= TYPE_VALUES.length) {
            n = TRANSPARENT.getValue();
        }
        return TYPE_VALUES[n];
    }

    public static ChartPattern getInstance(Number number) {
        int n = number == null ? -1 : NumberHelper.getInt(number);
        return ChartPattern.getInstance(n);
    }

    @Override
    public int getValue() {
        return this.m_value;
    }

    public String getName() {
        return this.m_name;
    }

    public String toString() {
        return this.getName();
    }

    static {
        TYPE_VALUES = (ChartPattern[])EnumHelper.createTypeArray(ChartPattern.class);
    }
}

