"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.queryWorkbenchPluginID = exports.pageStyles = exports.observabilityTracesTitle = exports.observabilityTracesPluginOrder = exports.observabilityTracesID = exports.observabilityTitle = exports.observabilityPluginOrder = exports.observabilityPanelsTitle = exports.observabilityPanelsPluginOrder = exports.observabilityPanelsID = exports.observabilityNotebookTitle = exports.observabilityNotebookPluginOrder = exports.observabilityNotebookID = exports.observabilityMetricsTitle = exports.observabilityMetricsPluginOrder = exports.observabilityMetricsID = exports.observabilityLogsTitle = exports.observabilityLogsPluginOrder = exports.observabilityLogsID = exports.observabilityIntegrationsTitle = exports.observabilityIntegrationsPluginOrder = exports.observabilityIntegrationsID = exports.observabilityID = exports.observabilityDataConnectionsTitle = exports.observabilityDataConnectionsPluginOrder = exports.observabilityDataConnectionsID = exports.observabilityApplicationsTitle = exports.observabilityApplicationsPluginOrder = exports.observabilityApplicationsID = exports.WAITING_TIME_ON_USER_ACTIONS = exports.VIS_CHART_TYPES = exports.VISUALIZATION_ERROR = exports.UI_DATE_FORMAT = exports.THRESHOLD_LINE_WIDTH = exports.THRESHOLD_LINE_OPACITY = exports.SQL_ENDPOINT = exports.SQL_DOCUMENTATION_URL = exports.SPAN_REGEX = exports.SLIDER_STEP = exports.SLIDER_MIN_VALUE = exports.SLIDER_MAX_VALUE = exports.SAVED_VISUALIZATION = exports.SAVED_QUERY = exports.SAVED_OBJECTS = exports.SAVED_OBJECT = exports.S3_DATASOURCE_TYPE = exports.PPL_WHERE_CLAUSE_REGEX = exports.PPL_STATS_REGEX = exports.PPL_SPAN_REGEX = exports.PPL_SEARCH = exports.PPL_PATTERNS_DOCUMENTATION_URL = exports.PPL_NEWLINE_REGEX = exports.PPL_INDEX_REGEX = exports.PPL_INDEX_INSERT_POINT_REGEX = exports.PPL_ENDPOINT = exports.PPL_DOCUMENTATION_URL = exports.PPL_DATE_FORMAT = exports.PPL_BASE = exports.PLOT_MARGIN = exports.PLOTLY_COLOR = exports.OPENSEARCH_PANELS_API = exports.OPENSEARCH_DATACONNECTIONS_API = exports.OBSERVABILITY_BASE = exports.NUMERICAL_FIELDS = exports.MAX_BUCKET_LENGTH = exports.LONG_CHART_COLOR = exports.LIVE_OPTIONS = exports.LIVE_END_TIME = exports.JOB_RESULT_ENDPOINT = exports.JOBS_ENDPOINT_BASE = exports.JOBS_BASE = exports.INTEGRATIONS_BASE = exports.FILLOPACITY_DIV_FACTOR = exports.EVENT_ANALYTICS = exports.ENABLED_VIS_TYPES = exports.DSL_SEARCH = exports.DSL_MAPPING = exports.DSL_ENDPOINT = exports.DSL_CAT = exports.DSL_BASE = exports.DEFAULT_CHART_STYLES = exports.DATACONNECTIONS_ENDPOINT = exports.DATACONNECTIONS_BASE = exports.CONSOLE_PROXY = exports.BarOrientation = void 0;

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
// Client route
const PPL_BASE = '/api/ppl';
exports.PPL_BASE = PPL_BASE;
const PPL_SEARCH = '/search';
exports.PPL_SEARCH = PPL_SEARCH;
const DSL_BASE = '/api/dsl';
exports.DSL_BASE = DSL_BASE;
const DSL_SEARCH = '/search';
exports.DSL_SEARCH = DSL_SEARCH;
const DSL_CAT = '/cat.indices';
exports.DSL_CAT = DSL_CAT;
const DSL_MAPPING = '/indices.getFieldMapping';
exports.DSL_MAPPING = DSL_MAPPING;
const OBSERVABILITY_BASE = '/api/observability';
exports.OBSERVABILITY_BASE = OBSERVABILITY_BASE;
const INTEGRATIONS_BASE = '/api/integrations';
exports.INTEGRATIONS_BASE = INTEGRATIONS_BASE;
const JOBS_BASE = '/query/jobs';
exports.JOBS_BASE = JOBS_BASE;
const DATACONNECTIONS_BASE = '/api/dataconnections';
exports.DATACONNECTIONS_BASE = DATACONNECTIONS_BASE;
const EVENT_ANALYTICS = '/event_analytics';
exports.EVENT_ANALYTICS = EVENT_ANALYTICS;
const SAVED_OBJECTS = '/saved_objects';
exports.SAVED_OBJECTS = SAVED_OBJECTS;
const SAVED_QUERY = '/query';
exports.SAVED_QUERY = SAVED_QUERY;
const SAVED_VISUALIZATION = '/vis';
exports.SAVED_VISUALIZATION = SAVED_VISUALIZATION;
const CONSOLE_PROXY = '/api/console/proxy'; // Server route

exports.CONSOLE_PROXY = CONSOLE_PROXY;
const PPL_ENDPOINT = '/_plugins/_ppl';
exports.PPL_ENDPOINT = PPL_ENDPOINT;
const SQL_ENDPOINT = '/_plugins/_sql';
exports.SQL_ENDPOINT = SQL_ENDPOINT;
const DSL_ENDPOINT = '/_plugins/_dsl';
exports.DSL_ENDPOINT = DSL_ENDPOINT;
const DATACONNECTIONS_ENDPOINT = '/_plugins/_query/_datasources';
exports.DATACONNECTIONS_ENDPOINT = DATACONNECTIONS_ENDPOINT;
const JOBS_ENDPOINT_BASE = '/_plugins/_async_query';
exports.JOBS_ENDPOINT_BASE = JOBS_ENDPOINT_BASE;
const JOB_RESULT_ENDPOINT = '/result';
exports.JOB_RESULT_ENDPOINT = JOB_RESULT_ENDPOINT;
const observabilityID = 'observability-logs';
exports.observabilityID = observabilityID;
const observabilityTitle = 'Observability';
exports.observabilityTitle = observabilityTitle;
const observabilityPluginOrder = 1500;
exports.observabilityPluginOrder = observabilityPluginOrder;
const observabilityApplicationsID = 'observability-applications';
exports.observabilityApplicationsID = observabilityApplicationsID;
const observabilityApplicationsTitle = 'Applications';
exports.observabilityApplicationsTitle = observabilityApplicationsTitle;
const observabilityApplicationsPluginOrder = 5090;
exports.observabilityApplicationsPluginOrder = observabilityApplicationsPluginOrder;
const observabilityLogsID = 'observability-logs';
exports.observabilityLogsID = observabilityLogsID;
const observabilityLogsTitle = 'Logs';
exports.observabilityLogsTitle = observabilityLogsTitle;
const observabilityLogsPluginOrder = 5091;
exports.observabilityLogsPluginOrder = observabilityLogsPluginOrder;
const observabilityMetricsID = 'observability-metrics';
exports.observabilityMetricsID = observabilityMetricsID;
const observabilityMetricsTitle = 'Metrics';
exports.observabilityMetricsTitle = observabilityMetricsTitle;
const observabilityMetricsPluginOrder = 5092;
exports.observabilityMetricsPluginOrder = observabilityMetricsPluginOrder;
const observabilityTracesID = 'observability-traces';
exports.observabilityTracesID = observabilityTracesID;
const observabilityTracesTitle = 'Traces';
exports.observabilityTracesTitle = observabilityTracesTitle;
const observabilityTracesPluginOrder = 5093;
exports.observabilityTracesPluginOrder = observabilityTracesPluginOrder;
const observabilityNotebookID = 'observability-notebooks';
exports.observabilityNotebookID = observabilityNotebookID;
const observabilityNotebookTitle = 'Notebooks';
exports.observabilityNotebookTitle = observabilityNotebookTitle;
const observabilityNotebookPluginOrder = 5094;
exports.observabilityNotebookPluginOrder = observabilityNotebookPluginOrder;
const observabilityPanelsID = 'observability-dashboards';
exports.observabilityPanelsID = observabilityPanelsID;
const observabilityPanelsTitle = 'Dashboards';
exports.observabilityPanelsTitle = observabilityPanelsTitle;
const observabilityPanelsPluginOrder = 5095;
exports.observabilityPanelsPluginOrder = observabilityPanelsPluginOrder;
const observabilityIntegrationsID = 'integrations';
exports.observabilityIntegrationsID = observabilityIntegrationsID;
const observabilityIntegrationsTitle = 'Integrations';
exports.observabilityIntegrationsTitle = observabilityIntegrationsTitle;
const observabilityIntegrationsPluginOrder = 9020;
exports.observabilityIntegrationsPluginOrder = observabilityIntegrationsPluginOrder;
const observabilityDataConnectionsID = 'datasources';
exports.observabilityDataConnectionsID = observabilityDataConnectionsID;
const observabilityDataConnectionsTitle = 'Data sources';
exports.observabilityDataConnectionsTitle = observabilityDataConnectionsTitle;
const observabilityDataConnectionsPluginOrder = 9030;
exports.observabilityDataConnectionsPluginOrder = observabilityDataConnectionsPluginOrder;
const queryWorkbenchPluginID = 'opensearch-query-workbench'; // Shared Constants

exports.queryWorkbenchPluginID = queryWorkbenchPluginID;
const SQL_DOCUMENTATION_URL = 'https://opensearch.org/docs/latest/search-plugins/sql/index/';
exports.SQL_DOCUMENTATION_URL = SQL_DOCUMENTATION_URL;
const PPL_DOCUMENTATION_URL = 'https://opensearch.org/docs/latest/search-plugins/sql/ppl/index';
exports.PPL_DOCUMENTATION_URL = PPL_DOCUMENTATION_URL;
const PPL_PATTERNS_DOCUMENTATION_URL = 'https://github.com/opensearch-project/sql/blob/2.x/docs/user/ppl/cmd/patterns.rst#description';
exports.PPL_PATTERNS_DOCUMENTATION_URL = PPL_PATTERNS_DOCUMENTATION_URL;
const UI_DATE_FORMAT = 'MM/DD/YYYY hh:mm A';
exports.UI_DATE_FORMAT = UI_DATE_FORMAT;
const PPL_DATE_FORMAT = 'YYYY-MM-DD HH:mm:ss.SSSSSS';
exports.PPL_DATE_FORMAT = PPL_DATE_FORMAT;
const SPAN_REGEX = /span/;
exports.SPAN_REGEX = SPAN_REGEX;
const PPL_SPAN_REGEX = /by\s*span/i;
exports.PPL_SPAN_REGEX = PPL_SPAN_REGEX;
const PPL_STATS_REGEX = /\|\s*stats/i;
exports.PPL_STATS_REGEX = PPL_STATS_REGEX;
const PPL_INDEX_INSERT_POINT_REGEX = /(search source|source|index)\s*=\s*([^|\s]+)(.*)/i;
exports.PPL_INDEX_INSERT_POINT_REGEX = PPL_INDEX_INSERT_POINT_REGEX;
const PPL_INDEX_REGEX = /(search source|source|index)\s*=\s*([^|\s]+)/i;
exports.PPL_INDEX_REGEX = PPL_INDEX_REGEX;
const PPL_WHERE_CLAUSE_REGEX = /\s*where\s+/i;
exports.PPL_WHERE_CLAUSE_REGEX = PPL_WHERE_CLAUSE_REGEX;
const PPL_NEWLINE_REGEX = /[\n\r]+/g; // Observability plugin URI

exports.PPL_NEWLINE_REGEX = PPL_NEWLINE_REGEX;
const BASE_OBSERVABILITY_URI = '/_plugins/_observability';
const BASE_DATACONNECTIONS_URI = '/_plugins/_query/_datasources';
const OPENSEARCH_PANELS_API = {
  OBJECT: `${BASE_OBSERVABILITY_URI}/object`
};
exports.OPENSEARCH_PANELS_API = OPENSEARCH_PANELS_API;
const OPENSEARCH_DATACONNECTIONS_API = {
  DATACONNECTION: `${BASE_DATACONNECTIONS_URI}`
}; // Saved Objects

exports.OPENSEARCH_DATACONNECTIONS_API = OPENSEARCH_DATACONNECTIONS_API;
const SAVED_OBJECT = '/object'; // Color Constants

exports.SAVED_OBJECT = SAVED_OBJECT;
const PLOTLY_COLOR = ['#3CA1C7', '#54B399', '#DB748A', '#F2BE4B', '#68CCC2', '#2A7866', '#843769', '#374FB8', '#BD6F26', '#4C636F'];
exports.PLOTLY_COLOR = PLOTLY_COLOR;
const LONG_CHART_COLOR = PLOTLY_COLOR[1];
exports.LONG_CHART_COLOR = LONG_CHART_COLOR;
const pageStyles = {
  float: 'left',
  width: '100%',
  maxWidth: '1130px'
};
exports.pageStyles = pageStyles;
let VIS_CHART_TYPES;
exports.VIS_CHART_TYPES = VIS_CHART_TYPES;

(function (VIS_CHART_TYPES) {
  VIS_CHART_TYPES["Bar"] = "bar";
  VIS_CHART_TYPES["HorizontalBar"] = "horizontal_bar";
  VIS_CHART_TYPES["Line"] = "line";
  VIS_CHART_TYPES["Pie"] = "pie";
  VIS_CHART_TYPES["HeatMap"] = "heatmap";
  VIS_CHART_TYPES["Text"] = "text";
})(VIS_CHART_TYPES || (exports.VIS_CHART_TYPES = VIS_CHART_TYPES = {}));

const NUMERICAL_FIELDS = ['short', 'integer', 'long', 'float', 'double'];
exports.NUMERICAL_FIELDS = NUMERICAL_FIELDS;
const ENABLED_VIS_TYPES = [VIS_CHART_TYPES.Bar, VIS_CHART_TYPES.HorizontalBar, VIS_CHART_TYPES.Line, VIS_CHART_TYPES.Pie, VIS_CHART_TYPES.HeatMap, VIS_CHART_TYPES.Text]; // Live tail constants

exports.ENABLED_VIS_TYPES = ENABLED_VIS_TYPES;
const LIVE_OPTIONS = [{
  label: '5s',
  startTime: 'now-5s',
  delayTime: 5000
}, {
  label: '10s',
  startTime: 'now-10s',
  delayTime: 10000
}, {
  label: '30s',
  startTime: 'now-30s',
  delayTime: 30000
}, {
  label: '1m',
  startTime: 'now-1m',
  delayTime: 60000
}, {
  label: '5m',
  startTime: 'now-5m',
  delayTime: 60000 * 5
}, {
  label: '15m',
  startTime: 'now-15m',
  delayTime: 60000 * 15
}, {
  label: '30m',
  startTime: 'now-30m',
  delayTime: 60000 * 30
}, {
  label: '1h',
  startTime: 'now-1h',
  delayTime: 60000 * 60
}, {
  label: '2h',
  startTime: 'now-2h',
  delayTime: 60000 * 120
}];
exports.LIVE_OPTIONS = LIVE_OPTIONS;
const LIVE_END_TIME = 'now';
exports.LIVE_END_TIME = LIVE_END_TIME;
const DEFAULT_CHART_STYLES = {
  DefaultModeLine: 'lines',
  Interpolation: 'spline',
  LineWidth: 0,
  FillOpacity: 100,
  MarkerSize: 5,
  ShowLegend: 'show',
  LegendPosition: 'v',
  LabelAngle: 0,
  DefaultSortSectors: 'largest_to_smallest',
  DefaultModeScatter: 'markers'
};
exports.DEFAULT_CHART_STYLES = DEFAULT_CHART_STYLES;
const FILLOPACITY_DIV_FACTOR = 200;
exports.FILLOPACITY_DIV_FACTOR = FILLOPACITY_DIV_FACTOR;
const SLIDER_MIN_VALUE = 0;
exports.SLIDER_MIN_VALUE = SLIDER_MIN_VALUE;
const SLIDER_MAX_VALUE = 100;
exports.SLIDER_MAX_VALUE = SLIDER_MAX_VALUE;
const SLIDER_STEP = 1;
exports.SLIDER_STEP = SLIDER_STEP;
const THRESHOLD_LINE_WIDTH = 3;
exports.THRESHOLD_LINE_WIDTH = THRESHOLD_LINE_WIDTH;
const THRESHOLD_LINE_OPACITY = 0.7;
exports.THRESHOLD_LINE_OPACITY = THRESHOLD_LINE_OPACITY;
const MAX_BUCKET_LENGTH = 16;
exports.MAX_BUCKET_LENGTH = MAX_BUCKET_LENGTH;
let BarOrientation;
exports.BarOrientation = BarOrientation;

(function (BarOrientation) {
  BarOrientation["horizontal"] = "h";
  BarOrientation["vertical"] = "v";
})(BarOrientation || (exports.BarOrientation = BarOrientation = {}));

const PLOT_MARGIN = {
  l: 30,
  r: 5,
  b: 30,
  t: 50,
  pad: 4
};
exports.PLOT_MARGIN = PLOT_MARGIN;
const WAITING_TIME_ON_USER_ACTIONS = 300;
exports.WAITING_TIME_ON_USER_ACTIONS = WAITING_TIME_ON_USER_ACTIONS;
const VISUALIZATION_ERROR = {
  NO_DATA: 'No data found.',
  INVALID_DATA: 'Invalid visualization data'
};
exports.VISUALIZATION_ERROR = VISUALIZATION_ERROR;
const S3_DATASOURCE_TYPE = 'S3_DATASOURCE';
exports.S3_DATASOURCE_TYPE = S3_DATASOURCE_TYPE;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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