/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.datasources.auth;

import java.util.List;
import lombok.Generated;
import org.opensearch.client.Client;
import org.opensearch.commons.authuser.User;
import org.opensearch.sql.datasource.model.DataSourceMetadata;
import org.opensearch.sql.datasources.auth.DataSourceUserAuthorizationHelper;

public class DataSourceUserAuthorizationHelperImpl
implements DataSourceUserAuthorizationHelper {
    private final Client client;

    private Boolean isAuthorizationRequired() {
        String userString = (String)this.client.threadPool().getThreadContext().getTransient("_opendistro_security_user_info");
        return userString != null;
    }

    private List<String> getUserRoles() {
        String userString = (String)this.client.threadPool().getThreadContext().getTransient("_opendistro_security_user_info");
        User user = User.parse((String)userString);
        return user.getRoles();
    }

    @Override
    public void authorizeDataSource(DataSourceMetadata dataSourceMetadata) {
        if (this.isAuthorizationRequired().booleanValue() && !dataSourceMetadata.getName().equals("@opensearch")) {
            boolean isAuthorized = false;
            for (String role : this.getUserRoles()) {
                if (!dataSourceMetadata.getAllowedRoles().contains(role) && !role.equals("all_access")) continue;
                isAuthorized = true;
                break;
            }
            if (!isAuthorized) {
                throw new SecurityException(String.format("User is not authorized to access datasource %s. User should be mapped to any of the roles in %s for access.", dataSourceMetadata.getName(), dataSourceMetadata.getAllowedRoles().toString()));
            }
        }
    }

    @Generated
    public DataSourceUserAuthorizationHelperImpl(Client client) {
        this.client = client;
    }
}

