/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.observability;

import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.opensearch.action.ActionRequest;
import org.opensearch.client.Client;
import org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.opensearch.cluster.node.DiscoveryNodes;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.ClusterSettings;
import org.opensearch.common.settings.IndexScopedSettings;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.settings.SettingsFilter;
import org.opensearch.core.action.ActionResponse;
import org.opensearch.core.common.io.stream.NamedWriteableRegistry;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.env.Environment;
import org.opensearch.env.NodeEnvironment;
import org.opensearch.observability.action.CreateObservabilityObjectAction;
import org.opensearch.observability.action.DeleteObservabilityObjectAction;
import org.opensearch.observability.action.GetObservabilityObjectAction;
import org.opensearch.observability.action.UpdateObservabilityObjectAction;
import org.opensearch.observability.index.ObservabilityIndex;
import org.opensearch.observability.index.ObservabilityIntegrationsIndex;
import org.opensearch.observability.resthandler.ObservabilityRestHandler;
import org.opensearch.observability.resthandler.ObservabilityStatsRestHandler;
import org.opensearch.observability.settings.PluginSettings;
import org.opensearch.plugins.ActionPlugin;
import org.opensearch.plugins.ClusterPlugin;
import org.opensearch.plugins.Plugin;
import org.opensearch.repositories.RepositoriesService;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.RestController;
import org.opensearch.rest.RestHandler;
import org.opensearch.script.ScriptService;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.watcher.ResourceWatcherService;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00ae\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 62\u00020\u00012\u00020\u00022\u00020\u0003:\u00016B\u0005\u00a2\u0006\u0002\u0010\u0004Jl\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dH\u0016J\u001e\u0010\u001f\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0006\b\u0001\u0012\u00020\"\u0012\u0006\b\u0001\u0012\u00020#0!0 H\u0016JL\u0010$\u001a\b\u0012\u0004\u0012\u00020%0 2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/2\u0006\u0010\u001a\u001a\u00020\u001b2\f\u00100\u001a\b\u0012\u0004\u0012\u0002010\u001dH\u0016J\u0012\u00102\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u0003030 H\u0016J\b\u00104\u001a\u000205H\u0016\u00a8\u00067"}, d2={"Lorg/opensearch/observability/ObservabilityPlugin;", "Lorg/opensearch/plugins/Plugin;", "Lorg/opensearch/plugins/ActionPlugin;", "Lorg/opensearch/plugins/ClusterPlugin;", "()V", "createComponents", "", "", "client", "Lorg/opensearch/client/Client;", "clusterService", "Lorg/opensearch/cluster/service/ClusterService;", "threadPool", "Lorg/opensearch/threadpool/ThreadPool;", "resourceWatcherService", "Lorg/opensearch/watcher/ResourceWatcherService;", "scriptService", "Lorg/opensearch/script/ScriptService;", "xContentRegistry", "Lorg/opensearch/core/xcontent/NamedXContentRegistry;", "environment", "Lorg/opensearch/env/Environment;", "nodeEnvironment", "Lorg/opensearch/env/NodeEnvironment;", "namedWriteableRegistry", "Lorg/opensearch/core/common/io/stream/NamedWriteableRegistry;", "indexNameExpressionResolver", "Lorg/opensearch/cluster/metadata/IndexNameExpressionResolver;", "repositoriesServiceSupplier", "Ljava/util/function/Supplier;", "Lorg/opensearch/repositories/RepositoriesService;", "getActions", "", "Lorg/opensearch/plugins/ActionPlugin$ActionHandler;", "Lorg/opensearch/action/ActionRequest;", "Lorg/opensearch/core/action/ActionResponse;", "getRestHandlers", "Lorg/opensearch/rest/RestHandler;", "settings", "Lorg/opensearch/common/settings/Settings;", "restController", "Lorg/opensearch/rest/RestController;", "clusterSettings", "Lorg/opensearch/common/settings/ClusterSettings;", "indexScopedSettings", "Lorg/opensearch/common/settings/IndexScopedSettings;", "settingsFilter", "Lorg/opensearch/common/settings/SettingsFilter;", "nodesInCluster", "Lorg/opensearch/cluster/node/DiscoveryNodes;", "getSettings", "Lorg/opensearch/common/settings/Setting;", "onNodeStarted", "", "Companion", "opensearch-observability"})
public final class ObservabilityPlugin
extends Plugin
implements ActionPlugin,
ClusterPlugin {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String PLUGIN_NAME = "opensearch-observability";
    @NotNull
    public static final String LOG_PREFIX = "observability";
    @NotNull
    public static final String BASE_OBSERVABILITY_URI = "/_plugins/_observability";
    @NotNull
    public static final String BASE_NOTEBOOKS_URI = "/_plugins/_notebooks";

    @NotNull
    public List<Setting<?>> getSettings() {
        return PluginSettings.INSTANCE.getAllSettings();
    }

    @NotNull
    public Collection<Object> createComponents(@NotNull Client client, @NotNull ClusterService clusterService, @NotNull ThreadPool threadPool, @NotNull ResourceWatcherService resourceWatcherService, @NotNull ScriptService scriptService, @NotNull NamedXContentRegistry xContentRegistry, @NotNull Environment environment, @NotNull NodeEnvironment nodeEnvironment, @NotNull NamedWriteableRegistry namedWriteableRegistry, @NotNull IndexNameExpressionResolver indexNameExpressionResolver, @NotNull Supplier<RepositoriesService> repositoriesServiceSupplier) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)clusterService, (String)"clusterService");
        Intrinsics.checkNotNullParameter((Object)threadPool, (String)"threadPool");
        Intrinsics.checkNotNullParameter((Object)resourceWatcherService, (String)"resourceWatcherService");
        Intrinsics.checkNotNullParameter((Object)scriptService, (String)"scriptService");
        Intrinsics.checkNotNullParameter((Object)xContentRegistry, (String)"xContentRegistry");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter((Object)nodeEnvironment, (String)"nodeEnvironment");
        Intrinsics.checkNotNullParameter((Object)namedWriteableRegistry, (String)"namedWriteableRegistry");
        Intrinsics.checkNotNullParameter((Object)indexNameExpressionResolver, (String)"indexNameExpressionResolver");
        Intrinsics.checkNotNullParameter(repositoriesServiceSupplier, (String)"repositoriesServiceSupplier");
        PluginSettings.INSTANCE.addSettingsUpdateConsumer(clusterService);
        ObservabilityIndex.INSTANCE.initialize(client, clusterService);
        ObservabilityIntegrationsIndex.INSTANCE.initialize(client, clusterService);
        return CollectionsKt.emptyList();
    }

    public void onNodeStarted() {
        ObservabilityIndex.INSTANCE.afterStart();
        ObservabilityIntegrationsIndex.INSTANCE.afterStart();
    }

    @NotNull
    public List<RestHandler> getRestHandlers(@NotNull Settings settings, @NotNull RestController restController, @NotNull ClusterSettings clusterSettings, @NotNull IndexScopedSettings indexScopedSettings, @NotNull SettingsFilter settingsFilter, @NotNull IndexNameExpressionResolver indexNameExpressionResolver, @NotNull Supplier<DiscoveryNodes> nodesInCluster) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)restController, (String)"restController");
        Intrinsics.checkNotNullParameter((Object)clusterSettings, (String)"clusterSettings");
        Intrinsics.checkNotNullParameter((Object)indexScopedSettings, (String)"indexScopedSettings");
        Intrinsics.checkNotNullParameter((Object)settingsFilter, (String)"settingsFilter");
        Intrinsics.checkNotNullParameter((Object)indexNameExpressionResolver, (String)"indexNameExpressionResolver");
        Intrinsics.checkNotNullParameter(nodesInCluster, (String)"nodesInCluster");
        Object[] objectArray = new BaseRestHandler[]{new ObservabilityRestHandler(), new ObservabilityStatsRestHandler()};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    public List<ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>> getActions() {
        Object[] objectArray = new ActionPlugin.ActionHandler[]{new ActionPlugin.ActionHandler(CreateObservabilityObjectAction.Companion.getACTION_TYPE$opensearch_observability(), CreateObservabilityObjectAction.class, new Class[0]), new ActionPlugin.ActionHandler(DeleteObservabilityObjectAction.Companion.getACTION_TYPE$opensearch_observability(), DeleteObservabilityObjectAction.class, new Class[0]), new ActionPlugin.ActionHandler(GetObservabilityObjectAction.Companion.getACTION_TYPE$opensearch_observability(), GetObservabilityObjectAction.class, new Class[0]), new ActionPlugin.ActionHandler(UpdateObservabilityObjectAction.Companion.getACTION_TYPE$opensearch_observability(), UpdateObservabilityObjectAction.class, new Class[0])};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/opensearch/observability/ObservabilityPlugin$Companion;", "", "()V", "BASE_NOTEBOOKS_URI", "", "BASE_OBSERVABILITY_URI", "LOG_PREFIX", "PLUGIN_NAME", "opensearch-observability"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

