/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.transport;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.search.TotalHits;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.search.SearchResponseSections;
import org.opensearch.action.search.ShardSearchFailure;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.client.Client;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.core.action.ActionListener;
import org.opensearch.index.IndexNotFoundException;
import org.opensearch.search.SearchHit;
import org.opensearch.search.SearchHits;
import org.opensearch.search.internal.InternalSearchResponse;
import org.opensearch.securityanalytics.action.SearchCorrelationRuleRequest;
import org.opensearch.securityanalytics.util.CorrelationRuleIndices;
import org.opensearch.securityanalytics.util.SecurityAnalyticsException;
import org.opensearch.tasks.Task;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.TransportService;

public class TransportSearchCorrelationRuleAction
extends HandledTransportAction<SearchCorrelationRuleRequest, SearchResponse> {
    private static final Logger log = LogManager.getLogger(TransportSearchCorrelationRuleAction.class);
    private final Client client;
    private final CorrelationRuleIndices correlationRuleIndices;
    private final ClusterService clusterService;
    private final ThreadPool threadPool;
    private static final SearchResponse EMPTY_SEARCH_RESPONSE = new SearchResponse((SearchResponseSections)new InternalSearchResponse(new SearchHits(new SearchHit[0], new TotalHits(0L, TotalHits.Relation.EQUAL_TO), 0.0f), null, null, null, false, null, 1), null, 0, 0, 0, 0L, ShardSearchFailure.EMPTY_ARRAY, SearchResponse.Clusters.EMPTY);

    @Inject
    public TransportSearchCorrelationRuleAction(TransportService transportService, Client client, ActionFilters actionFilters, ClusterService clusterService, ThreadPool threadPool, CorrelationRuleIndices correlationRuleIndices) {
        super("cluster:admin/opensearch/securityanalytics/correlation/rule/search", transportService, actionFilters, SearchCorrelationRuleRequest::new);
        this.client = client;
        this.clusterService = clusterService;
        this.correlationRuleIndices = correlationRuleIndices;
        this.threadPool = threadPool;
    }

    protected void doExecute(Task task, SearchCorrelationRuleRequest request, final ActionListener<SearchResponse> listener) {
        this.threadPool.getThreadContext().stashContext();
        this.client.search(request.getSearchRequest(), (ActionListener)new ActionListener<SearchResponse>(){

            public void onResponse(SearchResponse response) {
                listener.onResponse((Object)response);
            }

            public void onFailure(Exception e) {
                if (e instanceof IndexNotFoundException) {
                    listener.onResponse((Object)EMPTY_SEARCH_RESPONSE);
                } else {
                    listener.onFailure((Exception)SecurityAnalyticsException.wrap(e));
                }
            }
        });
    }
}

