/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.rca.framework.api.summaries;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jooq.Field;
import org.jooq.Name;
import org.jooq.Record;
import org.jooq.exception.DataTypeException;
import org.jooq.impl.DSL;
import org.opensearch.performanceanalyzer.grpc.FlowUnitMessage;
import org.opensearch.performanceanalyzer.grpc.HotNodeSummaryMessage;
import org.opensearch.performanceanalyzer.rca.framework.api.persist.JooqFieldValue;
import org.opensearch.performanceanalyzer.rca.framework.api.summaries.HotResourceSummary;
import org.opensearch.performanceanalyzer.rca.framework.api.summaries.HotShardSummary;
import org.opensearch.performanceanalyzer.rca.framework.core.GenericSummary;
import org.opensearch.performanceanalyzer.rca.framework.util.InstanceDetails;

public class HotNodeSummary
extends GenericSummary {
    public static final String HOT_NODE_SUMMARY_TABLE = HotNodeSummary.class.getSimpleName();
    private static final Logger LOG = LogManager.getLogger(HotNodeSummary.class);
    private final InstanceDetails.Id nodeID;
    private final InstanceDetails.Ip hostAddress;
    private List<HotResourceSummary> hotResourceSummaryList;
    private List<HotShardSummary> hotShardSummaryList;

    public HotNodeSummary(InstanceDetails.Id nodeID, InstanceDetails.Ip hostAddress) {
        this.nodeID = nodeID;
        this.hostAddress = hostAddress;
        this.hotResourceSummaryList = new ArrayList<HotResourceSummary>();
        this.hotShardSummaryList = new ArrayList<HotShardSummary>();
    }

    public InstanceDetails.Id getNodeID() {
        return this.nodeID;
    }

    public InstanceDetails.Ip getHostAddress() {
        return this.hostAddress;
    }

    public List<HotResourceSummary> getHotResourceSummaryList() {
        return this.hotResourceSummaryList;
    }

    public List<HotShardSummary> getHotShardSummaryList() {
        return this.hotShardSummaryList;
    }

    public void setHotShardSummaryList(List<HotShardSummary> summaryList) {
        if (summaryList != null) {
            this.hotShardSummaryList = summaryList;
        }
    }

    public void appendNestedSummary(HotResourceSummary summary) {
        if (summary != null) {
            this.hotResourceSummaryList.add(summary);
        }
    }

    public void appendNestedSummary(HotShardSummary summary) {
        this.hotShardSummaryList.add(summary);
    }

    public HotNodeSummaryMessage buildSummaryMessage() {
        HotNodeSummaryMessage.Builder summaryMessageBuilder = HotNodeSummaryMessage.newBuilder();
        summaryMessageBuilder.setNodeID(this.nodeID.toString());
        summaryMessageBuilder.setHostAddress(this.hostAddress.toString());
        for (HotResourceSummary hotResourceSummary : this.hotResourceSummaryList) {
            summaryMessageBuilder.getHotResourceSummaryListBuilder().addHotResourceSummary(hotResourceSummary.buildSummaryMessage());
        }
        for (HotShardSummary hotShardSummary : this.hotShardSummaryList) {
            summaryMessageBuilder.getHotShardSummaryListBuilder().addHotShardSummary(hotShardSummary.buildSummaryMessage());
        }
        return summaryMessageBuilder.build();
    }

    @Override
    public void buildSummaryMessageAndAddToFlowUnit(FlowUnitMessage.Builder messageBuilder) {
        messageBuilder.setHotNodeSummary(this.buildSummaryMessage());
    }

    public static HotNodeSummary buildHotNodeSummaryFromMessage(HotNodeSummaryMessage message) {
        int i;
        HotNodeSummary newSummary = new HotNodeSummary(new InstanceDetails.Id(message.getNodeID()), new InstanceDetails.Ip(message.getHostAddress()));
        if (message.hasHotResourceSummaryList()) {
            for (i = 0; i < message.getHotResourceSummaryList().getHotResourceSummaryCount(); ++i) {
                newSummary.appendNestedSummary(HotResourceSummary.buildHotResourceSummaryFromMessage(message.getHotResourceSummaryList().getHotResourceSummary(i)));
            }
        }
        if (message.hasHotShardSummaryList()) {
            for (i = 0; i < message.getHotShardSummaryList().getHotShardSummaryCount(); ++i) {
                newSummary.appendNestedSummary(HotShardSummary.buildHotShardSummaryFromMessage(message.getHotShardSummaryList().getHotShardSummary(i)));
            }
        }
        return newSummary;
    }

    public String toString() {
        return this.nodeID + " " + this.hostAddress + " " + this.hotResourceSummaryList + " " + this.hotShardSummaryList;
    }

    @Override
    public String getTableName() {
        return HOT_NODE_SUMMARY_TABLE;
    }

    @Override
    public List<Field<?>> getSqlSchema() {
        ArrayList schema = new ArrayList();
        schema.add(NodeSummaryField.NODE_ID_FIELD.getField());
        schema.add(NodeSummaryField.HOST_IP_ADDRESS_FIELD.getField());
        return schema;
    }

    @Override
    public List<Object> getSqlValue() {
        ArrayList<Object> value = new ArrayList<Object>();
        value.add(this.nodeID);
        value.add(this.hostAddress);
        return value;
    }

    @Override
    public JsonElement toJson() {
        JsonObject summaryObj = new JsonObject();
        summaryObj.addProperty("node_id", this.nodeID.toString());
        summaryObj.addProperty("host_address", this.hostAddress.toString());
        if (!this.getNestedSummaryList().isEmpty()) {
            String tableName = this.getNestedSummaryList().get(0).getTableName();
            summaryObj.add(tableName, (JsonElement)this.nestedSummaryListToJson());
        }
        return summaryObj;
    }

    @Override
    public List<GenericSummary> getNestedSummaryList() {
        ArrayList<GenericSummary> summaries = new ArrayList<GenericSummary>();
        summaries.addAll(this.hotResourceSummaryList);
        summaries.addAll(this.hotShardSummaryList);
        return summaries;
    }

    @Override
    public GenericSummary buildNestedSummary(String summaryTable, Record record) throws IllegalArgumentException {
        if (summaryTable.equals(HotResourceSummary.HOT_RESOURCE_SUMMARY_TABLE)) {
            HotResourceSummary summary = HotResourceSummary.buildSummary(record);
            if (summary != null) {
                this.hotResourceSummaryList.add(summary);
            }
            return summary;
        }
        if (summaryTable.equals(HotShardSummary.HOT_SHARD_SUMMARY_TABLE)) {
            HotShardSummary summary = HotShardSummary.buildSummary(record);
            if (summary != null) {
                this.hotShardSummaryList.add(summary);
            }
            return summary;
        }
        throw new IllegalArgumentException(summaryTable + " does not belong to the nested summaries of " + this.getTableName());
    }

    @Override
    public List<String> getNestedSummaryTables() {
        return Collections.unmodifiableList(Arrays.asList(HotResourceSummary.HOT_RESOURCE_SUMMARY_TABLE, HotShardSummary.HOT_SHARD_SUMMARY_TABLE));
    }

    @Nullable
    public static HotNodeSummary buildSummary(Record record) {
        HotNodeSummary summary = null;
        try {
            String nodeId = (String)record.get(NodeSummaryField.NODE_ID_FIELD.getField(), String.class);
            String ipAddress = (String)record.get(NodeSummaryField.HOST_IP_ADDRESS_FIELD.getField(), String.class);
            if (nodeId == null || ipAddress == null) {
                LOG.warn("read null object from SQL, nodeId: {}, ipAddress: {}", (Object)nodeId, (Object)ipAddress);
                return null;
            }
            summary = new HotNodeSummary(new InstanceDetails.Id(nodeId), new InstanceDetails.Ip(ipAddress));
        }
        catch (IllegalArgumentException ie) {
            LOG.error("Some fields might not be found in record, cause : {}", (Object)ie.getMessage());
        }
        catch (DataTypeException de) {
            LOG.error("Fails to convert data type");
        }
        return summary;
    }

    public static enum NodeSummaryField implements JooqFieldValue
    {
        NODE_ID_FIELD("node_id", String.class),
        HOST_IP_ADDRESS_FIELD("host_address", String.class);

        private String name;
        private Class<?> clazz;

        private NodeSummaryField(String name, Class<?> clazz) {
            this.name = name;
            this.clazz = clazz;
        }

        public Field<?> getField() {
            return DSL.field((Name)DSL.name((String)this.name), this.clazz);
        }

        @Override
        public String getName() {
            return this.name;
        }
    }

    public static class SQL_SCHEMA_CONSTANTS {
        public static final String NODE_ID_COL_NAME = "node_id";
        public static final String HOST_IP_ADDRESS_COL_NAME = "host_address";
    }
}

