/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.ssl;

import com.fasterxml.jackson.databind.InjectableValues;
import io.netty.handler.ssl.OpenSsl;
import io.netty.util.internal.PlatformDependent;
import java.nio.file.Path;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchException;
import org.opensearch.SpecialPermission;
import org.opensearch.Version;
import org.opensearch.client.Client;
import org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.opensearch.cluster.node.DiscoveryNodes;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.Booleans;
import org.opensearch.common.network.NetworkService;
import org.opensearch.common.settings.ClusterSettings;
import org.opensearch.common.settings.IndexScopedSettings;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.settings.SettingsFilter;
import org.opensearch.common.util.BigArrays;
import org.opensearch.common.util.PageCacheRecycler;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.core.common.io.stream.NamedWriteableRegistry;
import org.opensearch.core.indices.breaker.CircuitBreakerService;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.env.Environment;
import org.opensearch.env.NodeEnvironment;
import org.opensearch.http.HttpServerTransport;
import org.opensearch.plugins.NetworkPlugin;
import org.opensearch.plugins.Plugin;
import org.opensearch.plugins.SystemIndexPlugin;
import org.opensearch.repositories.RepositoriesService;
import org.opensearch.rest.RestController;
import org.opensearch.rest.RestHandler;
import org.opensearch.script.ScriptService;
import org.opensearch.security.DefaultObjectMapper;
import org.opensearch.security.NonValidatingObjectMapper;
import org.opensearch.security.filter.SecurityRestFilter;
import org.opensearch.security.ssl.DefaultSecurityKeyStore;
import org.opensearch.security.ssl.ExternalSecurityKeyStore;
import org.opensearch.security.ssl.SecureSSLSettings;
import org.opensearch.security.ssl.SecurityKeyStore;
import org.opensearch.security.ssl.SslExceptionHandler;
import org.opensearch.security.ssl.http.netty.SecuritySSLNettyHttpServerTransport;
import org.opensearch.security.ssl.http.netty.ValidatingDispatcher;
import org.opensearch.security.ssl.rest.SecuritySSLInfoAction;
import org.opensearch.security.ssl.transport.DefaultPrincipalExtractor;
import org.opensearch.security.ssl.transport.PrincipalExtractor;
import org.opensearch.security.ssl.transport.SSLConfig;
import org.opensearch.security.ssl.transport.SecuritySSLNettyTransport;
import org.opensearch.security.ssl.transport.SecuritySSLTransportInterceptor;
import org.opensearch.telemetry.tracing.Tracer;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.SharedGroupFactory;
import org.opensearch.transport.Transport;
import org.opensearch.transport.TransportInterceptor;
import org.opensearch.watcher.ResourceWatcherService;

public class OpenSearchSecuritySSLPlugin
extends Plugin
implements SystemIndexPlugin,
NetworkPlugin {
    private static boolean USE_NETTY_DEFAULT_ALLOCATOR = Booleans.parseBoolean((String)System.getProperty("opensearch.unsafe.use_netty_default_allocator"), (boolean)false);
    public static final boolean OPENSSL_SUPPORTED = PlatformDependent.javaVersion() < 12 && USE_NETTY_DEFAULT_ALLOCATOR;
    protected final Logger log = LogManager.getLogger(((Object)((Object)this)).getClass());
    public static final String CLIENT_TYPE = "client.type";
    protected final boolean client;
    protected final boolean httpSSLEnabled;
    protected final boolean transportSSLEnabled;
    protected final boolean extendedKeyUsageEnabled;
    protected final Settings settings;
    protected volatile SecurityRestFilter securityRestHandler;
    protected final SharedGroupFactory sharedGroupFactory;
    protected final SecurityKeyStore sks;
    protected PrincipalExtractor principalExtractor;
    protected final Path configPath;
    private static final SslExceptionHandler NOOP_SSL_EXCEPTION_HANDLER = new SslExceptionHandler(){};
    protected final SSLConfig SSLConfig;

    protected OpenSearchSecuritySSLPlugin(Settings settings, Path configPath, boolean disabled) {
        SecurityManager sm;
        if (disabled) {
            this.settings = null;
            this.sharedGroupFactory = null;
            this.client = false;
            this.httpSSLEnabled = false;
            this.transportSSLEnabled = false;
            this.extendedKeyUsageEnabled = false;
            this.sks = null;
            this.configPath = null;
            this.SSLConfig = new SSLConfig(false, false);
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    System.setProperty("opensearch.set.netty.runtime.available.processors", "false");
                    return null;
                }
            });
            return;
        }
        this.SSLConfig = new SSLConfig(settings);
        this.configPath = configPath;
        if (this.configPath != null) {
            this.log.info("OpenSearch Config path is {}", (Object)this.configPath.toAbsolutePath());
        } else {
            this.log.info("OpenSearch Config path is not set");
        }
        boolean allowClientInitiatedRenegotiation = settings.getAsBoolean("plugins.security.ssl.allow_client_initiated_renegotiation", Boolean.valueOf(false));
        boolean rejectClientInitiatedRenegotiation = Boolean.parseBoolean(System.getProperty("jdk.tls.rejectClientInitiatedRenegotiation"));
        if (allowClientInitiatedRenegotiation && !rejectClientInitiatedRenegotiation) {
            String renegoMsg = "Client side initiated TLS renegotiation enabled. This can open a vulnerablity for DoS attacks through client side initiated TLS renegotiation.";
            this.log.warn("Client side initiated TLS renegotiation enabled. This can open a vulnerablity for DoS attacks through client side initiated TLS renegotiation.");
        } else if (!rejectClientInitiatedRenegotiation) {
            sm = System.getSecurityManager();
            if (sm != null) {
                sm.checkPermission((Permission)new SpecialPermission());
            }
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    System.setProperty("jdk.tls.rejectClientInitiatedRenegotiation", "true");
                    return null;
                }
            });
            this.log.debug("Client side initiated TLS renegotiation forcibly disabled. This can prevent DoS attacks. (jdk.tls.rejectClientInitiatedRenegotiation set to true).");
        } else {
            this.log.debug("Client side initiated TLS renegotiation already disabled.");
        }
        sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)new SpecialPermission());
        }
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                System.setProperty("opensearch.set.netty.runtime.available.processors", "false");
                PlatformDependent.newFixedMpscQueue((int)1);
                OpenSsl.isAvailable();
                return null;
            }
        });
        this.settings = settings;
        this.sharedGroupFactory = new SharedGroupFactory(settings);
        InjectableValues.Std injectableValues = new InjectableValues.Std();
        injectableValues.addValue(Settings.class, (Object)settings);
        DefaultObjectMapper.inject(injectableValues);
        NonValidatingObjectMapper.inject(injectableValues);
        this.client = !"node".equals(this.settings.get(CLIENT_TYPE));
        this.httpSSLEnabled = settings.getAsBoolean("plugins.security.ssl.http.enabled", Boolean.valueOf(false));
        this.transportSSLEnabled = settings.getAsBoolean("plugins.security.ssl.transport.enabled", Boolean.valueOf(true));
        this.extendedKeyUsageEnabled = settings.getAsBoolean("plugins.security.ssl.transport.extended_key_usage_enabled", Boolean.valueOf(false));
        if (!this.httpSSLEnabled && !this.transportSSLEnabled) {
            this.log.error("SSL not activated for http and/or transport.");
        }
        this.sks = ExternalSecurityKeyStore.hasExternalSslContext(settings) ? new ExternalSecurityKeyStore(settings) : new DefaultSecurityKeyStore(settings, configPath);
    }

    public Map<String, Supplier<HttpServerTransport>> getHttpTransports(Settings settings, ThreadPool threadPool, BigArrays bigArrays, PageCacheRecycler pageCacheRecycler, CircuitBreakerService circuitBreakerService, NamedXContentRegistry xContentRegistry, NetworkService networkService, HttpServerTransport.Dispatcher dispatcher, ClusterSettings clusterSettings, Tracer tracer) {
        if (!this.client && this.httpSSLEnabled) {
            ValidatingDispatcher validatingDispatcher = new ValidatingDispatcher(threadPool.getThreadContext(), dispatcher, settings, this.configPath, NOOP_SSL_EXCEPTION_HANDLER);
            SecuritySSLNettyHttpServerTransport sgsnht = new SecuritySSLNettyHttpServerTransport(settings, networkService, bigArrays, threadPool, this.sks, xContentRegistry, validatingDispatcher, NOOP_SSL_EXCEPTION_HANDLER, clusterSettings, this.sharedGroupFactory, tracer, this.securityRestHandler);
            return Collections.singletonMap("org.opensearch.security.ssl.http.netty.SecuritySSLNettyHttpServerTransport", () -> sgsnht);
        }
        return Collections.emptyMap();
    }

    public List<RestHandler> getRestHandlers(Settings settings, RestController restController, ClusterSettings clusterSettings, IndexScopedSettings indexScopedSettings, SettingsFilter settingsFilter, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<DiscoveryNodes> nodesInCluster) {
        ArrayList<RestHandler> handlers = new ArrayList<RestHandler>(1);
        if (!this.client) {
            handlers.add((RestHandler)new SecuritySSLInfoAction(settings, this.configPath, restController, this.sks, Objects.requireNonNull(this.principalExtractor)));
        }
        return handlers;
    }

    public List<TransportInterceptor> getTransportInterceptors(NamedWriteableRegistry namedWriteableRegistry, ThreadContext threadContext) {
        ArrayList<TransportInterceptor> interceptors = new ArrayList<TransportInterceptor>(1);
        if (this.transportSSLEnabled && !this.client) {
            interceptors.add(new SecuritySSLTransportInterceptor(this.settings, null, null, this.SSLConfig, NOOP_SSL_EXCEPTION_HANDLER));
        }
        return interceptors;
    }

    public Map<String, Supplier<Transport>> getTransports(Settings settings, ThreadPool threadPool, PageCacheRecycler pageCacheRecycler, CircuitBreakerService circuitBreakerService, NamedWriteableRegistry namedWriteableRegistry, NetworkService networkService, Tracer tracer) {
        HashMap<String, Supplier<Transport>> transports = new HashMap<String, Supplier<Transport>>();
        if (this.transportSSLEnabled) {
            transports.put("org.opensearch.security.ssl.http.netty.SecuritySSLNettyTransport", () -> new SecuritySSLNettyTransport(settings, Version.CURRENT, threadPool, networkService, pageCacheRecycler, namedWriteableRegistry, circuitBreakerService, this.sks, NOOP_SSL_EXCEPTION_HANDLER, this.sharedGroupFactory, this.SSLConfig, tracer));
        }
        return transports;
    }

    public Collection<Object> createComponents(Client localClient, ClusterService clusterService, ThreadPool threadPool, ResourceWatcherService resourceWatcherService, ScriptService scriptService, NamedXContentRegistry xContentRegistry, Environment environment, NodeEnvironment nodeEnvironment, NamedWriteableRegistry namedWriteableRegistry, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<RepositoriesService> repositoriesServiceSupplier) {
        ArrayList<Object> components = new ArrayList<Object>(1);
        if (this.client) {
            return components;
        }
        String principalExtractorClass = this.settings.get("plugins.security.ssl.transport.principal_extractor_class", null);
        if (principalExtractorClass == null) {
            this.principalExtractor = new DefaultPrincipalExtractor();
        } else {
            try {
                this.log.debug("Try to load and instantiate '{}'", (Object)principalExtractorClass);
                Class<?> principalExtractorClazz = Class.forName(principalExtractorClass);
                this.principalExtractor = (PrincipalExtractor)principalExtractorClazz.newInstance();
            }
            catch (Exception e) {
                this.log.error("Unable to load '{}' due to", (Object)principalExtractorClass, (Object)e);
                throw new OpenSearchException((Throwable)e);
            }
        }
        components.add(this.principalExtractor);
        return components;
    }

    public List<Setting<?>> getSettings() {
        ArrayList settings = new ArrayList();
        settings.addAll(SecureSSLSettings.getSecureSettings());
        settings.add(Setting.simpleString((String)"plugins.security.ssl.http.clientauth_mode", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.simpleString((String)"plugins.security.ssl.http.keystore_alias", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.simpleString((String)"plugins.security.ssl.http.keystore_filepath", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.simpleString((String)"plugins.security.ssl.http.keystore_type", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.simpleString((String)"plugins.security.ssl.http.truststore_alias", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.simpleString((String)"plugins.security.ssl.http.truststore_filepath", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.simpleString((String)"plugins.security.ssl.http.truststore_type", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.boolSetting((String)"plugins.security.ssl.http.enable_openssl_if_available", (boolean)OPENSSL_SUPPORTED, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.boolSetting((String)"plugins.security.ssl.http.enabled", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.boolSetting((String)"plugins.security.ssl.transport.enable_openssl_if_available", (boolean)OPENSSL_SUPPORTED, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.boolSetting((String)"plugins.security.ssl.transport.enabled", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.boolSetting((String)"plugins.security.ssl.transport.enforce_hostname_verification", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.boolSetting((String)"plugins.security.ssl.transport.resolve_hostname", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.simpleString((String)"plugins.security.ssl.transport.keystore_filepath", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.simpleString((String)"plugins.security.ssl.transport.keystore_type", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.simpleString((String)"plugins.security.ssl.transport.truststore_filepath", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.simpleString((String)"plugins.security.ssl.transport.truststore_type", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.listSetting((String)"plugins.security.ssl.http.enabled_ciphers", Collections.emptyList(), Function.identity(), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
        settings.add(Setting.listSetting((String)"plugins.security.ssl.http.enabled_protocols", Collections.emptyList(), Function.identity(), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
        settings.add(Setting.listSetting((String)"plugins.security.ssl.transport.enabled_ciphers", Collections.emptyList(), Function.identity(), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
        settings.add(Setting.listSetting((String)"plugins.security.ssl.transport.enabled_protocols", Collections.emptyList(), Function.identity(), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
        settings.add(Setting.simpleString((String)"plugins.security.ssl.client.external_context_id", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.simpleString((String)"plugins.security.ssl.transport.principal_extractor_class", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.boolSetting((String)"plugins.security.ssl.transport.extended_key_usage_enabled", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        if (this.extendedKeyUsageEnabled) {
            settings.add(Setting.simpleString((String)"plugins.security.ssl.transport.server.keystore_alias", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.simpleString((String)"plugins.security.ssl.transport.server.truststore_alias", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.simpleString((String)"plugins.security.ssl.transport.client.keystore_alias", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.simpleString((String)"plugins.security.ssl.transport.client.truststore_alias", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.simpleString((String)"plugins.security.ssl.transport.server.pemcert_filepath", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.simpleString((String)"plugins.security.ssl.transport.server.pemkey_filepath", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.simpleString((String)"plugins.security.ssl.transport.server.pemtrustedcas_filepath", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.simpleString((String)"plugins.security.ssl.transport.client.pemcert_filepath", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.simpleString((String)"plugins.security.ssl.transport.client.pemkey_filepath", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.simpleString((String)"plugins.security.ssl.transport.client.pemtrustedcas_filepath", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        } else {
            settings.add(Setting.simpleString((String)"plugins.security.ssl.transport.keystore_alias", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.simpleString((String)"plugins.security.ssl.transport.truststore_alias", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.simpleString((String)"plugins.security.ssl.transport.pemcert_filepath", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.simpleString((String)"plugins.security.ssl.transport.pemkey_filepath", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.simpleString((String)"plugins.security.ssl.transport.pemtrustedcas_filepath", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        }
        settings.add(Setting.simpleString((String)"plugins.security.ssl.http.pemcert_filepath", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.simpleString((String)"plugins.security.ssl.http.pemkey_filepath", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.simpleString((String)"plugins.security.ssl.http.pemtrustedcas_filepath", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.simpleString((String)"plugins.security.ssl.http.crl.file_path", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.boolSetting((String)"plugins.security.ssl.http.crl.validate", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.boolSetting((String)"plugins.security.ssl.http.crl.prefer_crlfile_over_ocsp", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.boolSetting((String)"plugins.security.ssl.http.crl.check_only_end_entities", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.boolSetting((String)"plugins.security.ssl.http.crl.disable_crldp", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.boolSetting((String)"plugins.security.ssl.http.crl.disable_ocsp", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.longSetting((String)"plugins.security.ssl.http.crl.validation_date", (long)-1L, (long)-1L, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        return settings;
    }

    public Settings additionalSettings() {
        Settings.Builder builder = Settings.builder();
        if (!this.client && this.httpSSLEnabled) {
            if (this.settings.get("http.compression") == null) {
                builder.put("http.compression", false);
                this.log.info("Disabled https compression by default to mitigate BREACH attacks. You can enable it by setting 'http.compression: true' in opensearch.yml");
            }
            builder.put("http.type", "org.opensearch.security.ssl.http.netty.SecuritySSLNettyHttpServerTransport");
        }
        if (this.transportSSLEnabled) {
            builder.put("transport.type", "org.opensearch.security.ssl.http.netty.SecuritySSLNettyTransport");
        }
        return builder.build();
    }

    public List<String> getSettingsFilter() {
        ArrayList<String> settingsFilter = new ArrayList<String>();
        settingsFilter.add("opendistro_security.*");
        settingsFilter.add("plugins.security.*");
        return settingsFilter;
    }
}

