/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.randomcutforest.returntypes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;

public class Neighbor {
    public final float[] point;
    public final double distance;
    public final List<Long> sequenceIndexes;
    public int count;

    public Neighbor(float[] point, double distance, List<Long> sequenceIndexes) {
        this.point = point;
        this.distance = distance;
        this.sequenceIndexes = sequenceIndexes;
        this.count = 1;
    }

    public static Collector<Optional<Neighbor>, Map<Integer, Neighbor>, List<Neighbor>> collector() {
        return new CollectorImpl();
    }

    private void mergeSequenceIndexes(Neighbor other) {
        this.sequenceIndexes.addAll(other.sequenceIndexes);
        this.count += other.count;
    }

    private int getHashCodeForPoint() {
        return Arrays.hashCode(this.point);
    }

    private static class CollectorImpl
    implements Collector<Optional<Neighbor>, Map<Integer, Neighbor>, List<Neighbor>> {
        private CollectorImpl() {
        }

        @Override
        public Supplier<Map<Integer, Neighbor>> supplier() {
            return HashMap::new;
        }

        @Override
        public BiConsumer<Map<Integer, Neighbor>, Optional<Neighbor>> accumulator() {
            return (neighborsMap, neighborOptional) -> {
                if (neighborOptional.isPresent()) {
                    this.mergeNeighborIfNeededAndPut((Map<Integer, Neighbor>)neighborsMap, (Neighbor)neighborOptional.get());
                }
            };
        }

        @Override
        public BinaryOperator<Map<Integer, Neighbor>> combiner() {
            return (left, right) -> {
                right.forEach((k, v) -> this.mergeNeighborIfNeededAndPut((Map<Integer, Neighbor>)left, (Neighbor)v));
                return left;
            };
        }

        @Override
        public Function<Map<Integer, Neighbor>, List<Neighbor>> finisher() {
            return map -> {
                ArrayList<Neighbor> combinedResult = new ArrayList<Neighbor>();
                map.forEach((k, v) -> {
                    v.sequenceIndexes.sort(Long::compareTo);
                    combinedResult.add((Neighbor)v);
                });
                Comparator<Neighbor> comparator = Comparator.comparingDouble(n -> n.distance);
                combinedResult.sort(comparator);
                return combinedResult;
            };
        }

        @Override
        public Set<Collector.Characteristics> characteristics() {
            return Collections.emptySet();
        }

        private void mergeNeighborIfNeededAndPut(Map<Integer, Neighbor> neighborsMap, Neighbor currentNeighbor) {
            Neighbor existingNeighbor = neighborsMap.get(currentNeighbor.getHashCodeForPoint());
            if (existingNeighbor != null) {
                existingNeighbor.mergeSequenceIndexes(currentNeighbor);
            } else {
                neighborsMap.put(currentNeighbor.getHashCodeForPoint(), currentNeighbor);
            }
        }
    }
}

