/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.installer;

import java.awt.Dialog;
import java.awt.EventQueue;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import org.netbeans.api.autoupdate.OperationContainer;
import org.netbeans.api.autoupdate.OperationException;
import org.netbeans.api.autoupdate.OperationSupport;
import org.netbeans.api.autoupdate.UpdateElement;
import org.netbeans.api.autoupdate.UpdateManager;
import org.netbeans.api.autoupdate.UpdateUnit;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.autoupdate.ui.api.PluginManager;
import org.netbeans.modules.versioning.spi.VersioningSupport;
import org.netbeans.modules.versioning.spi.VersioningSystem;
import org.netbeans.modules.versioning.system.cvss.installer.CvsInstallDialog;
import org.netbeans.modules.versioning.system.cvss.installer.CvsInstallerModuleConfig;
import org.netbeans.modules.versioning.system.cvss.installer.util.Utils;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;

public final class CvsInstaller
extends VersioningSystem {
    public static final Logger LOG = Logger.getLogger(CvsInstaller.class.getName());
    private final Set<File> unversionedParents = Collections.synchronizedSet(new HashSet(20));
    public static final String FILENAME_CVS = "CVS";
    public static final String FILENAME_CVS_REPOSITORY = "CVS/Repository";
    public static final String FILENAME_CVS_ENTRIES = "CVS/Entries";
    private static final RequestProcessor RP = new RequestProcessor("CVS Installer", 1, false, false);
    private final RequestProcessor.Task task;
    private final AsyncTask installTask = new AsyncTask();
    private static final String CVS_CODENAME = "org.netbeans.modules.versioning.system.cvss";
    private static final String INSTALLER_CODENAME = "org.netbeans.modules.versioning.system.cvss.installer";
    private static boolean downloadWindowDisplayed;

    public CvsInstaller() {
        this.task = RP.create((Runnable)this.installTask);
    }

    public File getTopmostManagedAncestor(File file) {
        if (CvsInstallerModuleConfig.getInstance().isCvsInstalled()) {
            this.task.schedule(0);
            return null;
        }
        if (CvsInstallerModuleConfig.getInstance().isIgnored()) {
            return null;
        }
        return this.getTopmostManagedAncestor(file, false);
    }

    public File getTopmostManagedAncestor(File file, boolean internal) {
        long t = System.currentTimeMillis();
        LOG.log(Level.FINE, "getTopmostManagedParent {0}", new Object[]{file});
        if (this.unversionedParents.contains(file)) {
            LOG.fine(" cached as unversioned");
            return null;
        }
        if (Utils.isPartOfCVSMetadata(file)) {
            LOG.fine(" part of metaddata");
            while (file != null) {
                if (file.getName().equals(FILENAME_CVS) && (file.isDirectory() || !file.exists())) {
                    file = file.getParentFile();
                    LOG.log(Level.FINE, " will use parent {0}", new Object[]{file});
                    break;
                }
                file = file.getParentFile();
            }
        }
        HashSet<File> done = new HashSet<File>();
        File topmost = null;
        while (file != null) {
            if (this.unversionedParents.contains(file)) {
                LOG.log(Level.FINE, " already known as unversioned {0}", new Object[]{file});
                break;
            }
            if (VersioningSupport.isExcluded((File)file)) break;
            if (Utils.containsMetadata(file)) {
                LOG.log(Level.FINE, " found managed parent {0}", new Object[]{file});
                topmost = file;
                done.clear();
            } else {
                LOG.log(Level.FINE, " found unversioned {0}", new Object[]{file});
                if (file.exists()) {
                    done.add(file);
                }
            }
            file = file.getParentFile();
        }
        if (done.size() > 0) {
            LOG.log(Level.FINE, " storing unversioned");
            this.unversionedParents.addAll(done);
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, " getTopmostManagedParent returns {0} after {1} millis", new Object[]{topmost, System.currentTimeMillis() - t});
        }
        if (internal) {
            return topmost;
        }
        if (topmost != null) {
            this.task.schedule(0);
        }
        return null;
    }

    private boolean isCvsInstalled() {
        assert (!EventQueue.isDispatchThread());
        for (UpdateUnit u : UpdateManager.getDefault().getUpdateUnits()) {
            if (!CVS_CODENAME.equals(u.getCodeName())) continue;
            return u.getInstalled() != null;
        }
        return false;
    }

    private class AsyncTask
    implements Runnable {
        private PropertyChangeListener listener;

        private AsyncTask() {
        }

        @Override
        public void run() {
            Project[] projects;
            if (CvsInstallerModuleConfig.getInstance().isCvsInstalled() || CvsInstaller.this.isCvsInstalled()) {
                this.doFinish();
                return;
            }
            if (downloadWindowDisplayed || CvsInstallerModuleConfig.getInstance().isIgnored()) {
                return;
            }
            OpenProjects projs = OpenProjects.getDefault();
            if (this.listener == null) {
                this.listener = new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        if ("openProjects".equals(evt.getPropertyName())) {
                            CvsInstaller.this.task.schedule(0);
                        }
                    }
                };
                projs.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.listener, (Object)projs));
            }
            try {
                projects = (Project[])projs.openProjects().get();
            }
            catch (Exception ex) {
                LOG.log(Level.INFO, null, ex);
                projects = projs.getOpenProjects();
            }
            for (Project p : projects) {
                FileObject fo = p.getProjectDirectory();
                File f = FileUtil.toFile((FileObject)fo);
                if (f == null || CvsInstaller.this.getTopmostManagedAncestor(f, true) == null) continue;
                this.processCvsProject(p);
                break;
            }
        }

        private void doFinish() {
            CvsInstallerModuleConfig.getInstance().setCvsInstalled(true);
            if (this.listener != null) {
                OpenProjects.getDefault().removePropertyChangeListener(this.listener);
                this.listener = null;
            }
            assert (!EventQueue.isDispatchThread());
            for (UpdateUnit u : UpdateManager.getDefault().getUpdateUnits()) {
                OperationContainer container;
                if (!CvsInstaller.INSTALLER_CODENAME.equals(u.getCodeName()) || u.getInstalled() == null || u.isPending() || !(container = OperationContainer.createForUninstall()).canBeAdded(u, u.getInstalled())) continue;
                container.add(u, u.getInstalled());
                try {
                    LOG.log(Level.INFO, "doFinish: uninstalling");
                    OperationSupport support = (OperationSupport)container.getSupport();
                    OperationSupport.Restarter restarter = support.doOperation(null);
                    LOG.log(Level.INFO, "doFinish: uninstalled");
                    if (restarter == null) continue;
                    LOG.log(Level.INFO, "doFinish: restart scheduled");
                    support.doRestartLater(restarter);
                }
                catch (OperationException ex) {
                    LOG.log(Level.INFO, null, ex);
                }
            }
        }

        private void processCvsProject(Project p) {
            JButton installButton = new JButton();
            Mnemonics.setLocalizedText((AbstractButton)installButton, (String)NbBundle.getMessage(CvsInstallDialog.class, (String)"CvsInstallDialog.downloadButton.text"));
            CvsInstallDialog panel = new CvsInstallDialog();
            DialogDescriptor dd = new DialogDescriptor((Object)panel, NbBundle.getMessage(CvsInstallDialog.class, (String)"CvsInstallDialog.title"), true, new Object[]{installButton, DialogDescriptor.CANCEL_OPTION}, (Object)installButton, 0, null, null);
            Dialog dialog = DialogDisplayer.getDefault().createDialog(dd);
            dialog.setVisible(true);
            downloadWindowDisplayed = true;
            if (this.listener != null) {
                OpenProjects.getDefault().removePropertyChangeListener(this.listener);
                this.listener = null;
            }
            if (panel.cbDoNotAsk.isSelected()) {
                CvsInstallerModuleConfig.getInstance().setIgnored(true);
            }
            if (dd.getValue() == installButton) {
                if (this.installCvsSupport()) {
                    this.doFinish();
                } else {
                    CvsInstallerModuleConfig.getInstance().setIgnored(false);
                    DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(CvsInstaller.class, (String)"CvsInstaller.installFailed"), 0));
                }
            }
        }

        private boolean installCvsSupport() {
            assert (!EventQueue.isDispatchThread());
            for (UpdateUnit u : UpdateManager.getDefault().getUpdateUnits()) {
                if (!CvsInstaller.CVS_CODENAME.equals(u.getCodeName()) || u.getInstalled() != null || u.getAvailableUpdates().size() <= 0) continue;
                UpdateElement element = (UpdateElement)u.getAvailableUpdates().get(0);
                OperationContainer container = OperationContainer.createForInstall();
                if (!container.canBeAdded(u, element)) continue;
                container.add(u, element);
                LOG.log(Level.INFO, "installCvsSupport: installing CVS");
                return PluginManager.openInstallWizard((OperationContainer)container);
            }
            return false;
        }
    }
}

