/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.symfony2.annotations.validators.parser;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.php.api.annotation.util.AnnotationUtils;
import org.netbeans.modules.php.spi.annotation.AnnotationLineParser;
import org.netbeans.modules.php.spi.annotation.AnnotationParsedLine;

public class EncapsulatingAnnotationLineParser
implements AnnotationLineParser {
    private static final Map<String, Set<String>> ANNOTATIONS = new HashMap<String, Set<String>>();

    public AnnotationParsedLine parse(String line) {
        AnnotationParsedLine.ParsedLine result = null;
        String[] tokens = line.split("\\(");
        for (Map.Entry<String, Set<String>> entry : ANNOTATIONS.entrySet()) {
            if (tokens.length <= 0 || !AnnotationUtils.isTypeAnnotation((String)tokens[0], (String)entry.getKey())) continue;
            String annotation = tokens[0].trim();
            String description = line.substring(annotation.length()).trim();
            HashMap<OffsetRange, String> types = new HashMap<OffsetRange, String>();
            types.put(new OffsetRange(0, annotation.length()), annotation);
            types.putAll(AnnotationUtils.extractInlineAnnotations((String)line, entry.getValue()));
            result = new AnnotationParsedLine.ParsedLine(entry.getKey(), types, description, true);
            break;
        }
        return result;
    }

    static {
        HashSet<String> inlineAnnotations = new HashSet<String>();
        inlineAnnotations.add("NotBlank");
        inlineAnnotations.add("Blank");
        inlineAnnotations.add("NotNull");
        inlineAnnotations.add("Null");
        inlineAnnotations.add("True");
        inlineAnnotations.add("False");
        inlineAnnotations.add("Email");
        inlineAnnotations.add("MinLength");
        inlineAnnotations.add("MaxLength");
        inlineAnnotations.add("Url");
        inlineAnnotations.add("Regex");
        inlineAnnotations.add("Ip");
        inlineAnnotations.add("Max");
        inlineAnnotations.add("Min");
        inlineAnnotations.add("Date");
        inlineAnnotations.add("DateTime");
        inlineAnnotations.add("Time");
        inlineAnnotations.add("Choice");
        inlineAnnotations.add("UniqueEntity");
        inlineAnnotations.add("Language");
        inlineAnnotations.add("Locale");
        inlineAnnotations.add("Country");
        inlineAnnotations.add("File");
        inlineAnnotations.add("Image");
        inlineAnnotations.add("Callback");
        inlineAnnotations.add("Valid");
        ANNOTATIONS.put("Collection", inlineAnnotations);
        ANNOTATIONS.put("All", inlineAnnotations);
    }
}

