/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.installer.utils.helper;

import org.netbeans.installer.utils.ResourceUtils;

public enum Status {
    NOT_INSTALLED("not-installed"),
    TO_BE_INSTALLED("to-be-installed"),
    INSTALLED("installed"),
    INSTALLED_DIFFERENT_BUILD("installed-different-build"),
    TO_BE_UNINSTALLED("to-be-uninstalled");

    private String name;
    private static final String NOT_INSTALLED_STRING;
    private static final String TO_BE_INSTALLED_STRING;
    private static final String INSTALLED_STRING;
    private static final String TO_BE_UNINSTALLED_STRING;

    private Status(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        switch (this) {
            case NOT_INSTALLED: {
                return NOT_INSTALLED_STRING;
            }
            case TO_BE_INSTALLED: {
                return TO_BE_INSTALLED_STRING;
            }
            case INSTALLED: {
                return INSTALLED_STRING;
            }
            case TO_BE_UNINSTALLED: {
                return TO_BE_UNINSTALLED_STRING;
            }
        }
        return null;
    }

    public String toString() {
        return this.name;
    }

    static {
        NOT_INSTALLED_STRING = ResourceUtils.getString(Status.class, "Status.not-installed");
        TO_BE_INSTALLED_STRING = ResourceUtils.getString(Status.class, "Status.to-be-installed");
        INSTALLED_STRING = ResourceUtils.getString(Status.class, "Status.installed");
        TO_BE_UNINSTALLED_STRING = ResourceUtils.getString(Status.class, "Status.to-be-uninstalled");
    }
}

