/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.extexecution.process.jdk9;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import org.netbeans.spi.extexecution.base.ProcessesImplementation;

public class ProcessesImpl
implements ProcessesImplementation {
    private static final Logger LOGGER = Logger.getLogger(ProcessesImpl.class.getName());
    private static final boolean ENABLED;
    private static final Method PROCESS_TO_HANDLE;
    private static final Method PROCESS_HANDLE_DESCENDANTS;
    private static final Method PROCESS_HANDLE_DESTROY;

    public void killTree(Process process, Map<String, String> environment) {
        if (!ENABLED) {
            throw new UnsupportedOperationException("The JDK 9 way of killing process tree is not supported");
        }
        try {
            Object handle = PROCESS_TO_HANDLE.invoke((Object)process, (Object[])null);
            try (Stream s = (Stream)PROCESS_HANDLE_DESCENDANTS.invoke(handle, (Object[])null);){
                ProcessesImpl.destroy(handle);
                s.forEach(ch -> ProcessesImpl.destroy(ch));
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
            throw new UnsupportedOperationException("The JDK 9 way of killing process tree has failed", ex);
        }
    }

    private static void destroy(Object handle) {
        try {
            PROCESS_HANDLE_DESTROY.invoke(handle, (Object[])null);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
            LOGGER.log(Level.INFO, null, ex);
        }
    }

    static {
        Method toHandle = null;
        Method descendants = null;
        Method destroy = null;
        try {
            toHandle = Process.class.getDeclaredMethod("toHandle", new Class[0]);
            if (toHandle != null) {
                Class<?> processHandle = Class.forName("java.lang.ProcessHandle");
                descendants = processHandle.getDeclaredMethod("descendants", new Class[0]);
                destroy = processHandle.getDeclaredMethod("destroy", new Class[0]);
            }
        }
        catch (Exception | NoClassDefFoundError ex) {
            LOGGER.log(Level.WARNING, null, ex);
        }
        ENABLED = toHandle != null && descendants != null && destroy != null;
        PROCESS_TO_HANDLE = toHandle;
        PROCESS_HANDLE_DESCENDANTS = descendants;
        PROCESS_HANDLE_DESTROY = destroy;
    }
}

