/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.vault.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.vault.model.UpdateSecretDetails;
import java.util.Objects;

public class UpdateSecretRequest
extends BmcRequest<UpdateSecretDetails> {
    private String secretId;
    private UpdateSecretDetails updateSecretDetails;
    private String ifMatch;
    private String opcRequestId;

    public String getSecretId() {
        return this.secretId;
    }

    public UpdateSecretDetails getUpdateSecretDetails() {
        return this.updateSecretDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public UpdateSecretDetails getBody$() {
        return this.updateSecretDetails;
    }

    public Builder toBuilder() {
        return new Builder().secretId(this.secretId).updateSecretDetails(this.updateSecretDetails).ifMatch(this.ifMatch).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",secretId=").append(String.valueOf(this.secretId));
        sb.append(",updateSecretDetails=").append(String.valueOf((Object)this.updateSecretDetails));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateSecretRequest)) {
            return false;
        }
        UpdateSecretRequest other = (UpdateSecretRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.secretId, other.secretId) && Objects.equals((Object)this.updateSecretDetails, (Object)other.updateSecretDetails) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.secretId == null ? 43 : this.secretId.hashCode());
        result = result * 59 + (this.updateSecretDetails == null ? 43 : this.updateSecretDetails.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdateSecretRequest, UpdateSecretDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String secretId = null;
        private UpdateSecretDetails updateSecretDetails = null;
        private String ifMatch = null;
        private String opcRequestId = null;

        public Builder secretId(String secretId) {
            this.secretId = secretId;
            return this;
        }

        public Builder updateSecretDetails(UpdateSecretDetails updateSecretDetails) {
            this.updateSecretDetails = updateSecretDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateSecretRequest o) {
            this.secretId(o.getSecretId());
            this.updateSecretDetails(o.getUpdateSecretDetails());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateSecretRequest build() {
            UpdateSecretRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpdateSecretDetails body) {
            this.updateSecretDetails(body);
            return this;
        }

        public UpdateSecretRequest buildWithoutInvocationCallback() {
            UpdateSecretRequest request = new UpdateSecretRequest();
            request.secretId = this.secretId;
            request.updateSecretDetails = this.updateSecretDetails;
            request.ifMatch = this.ifMatch;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

