/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.classfile;

import com.sun.source.util.TreePath;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.lang.model.element.Element;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.actions.Openable;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.editor.EditorRegistry;
import org.netbeans.api.editor.document.EditorDocumentUtils;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.api.java.queries.SourceJavadocAttacher;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.UiUtils;
import org.netbeans.api.progress.BaseProgressUtils;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class AttachSourcePanel
extends JPanel {
    private static final RequestProcessor RP = new RequestProcessor(AttachSourcePanel.class);
    private final URL root;
    private final URL file;
    private final String binaryName;
    private final String sourceFile;
    private JButton jButton1;
    private JLabel jLabel1;

    public AttachSourcePanel(@NonNull URL root, @NonNull URL file, @NonNull String binaryName, @NonNull String sourceFile) {
        assert (root != null);
        assert (file != null);
        assert (binaryName != null);
        this.root = root;
        this.file = file;
        this.binaryName = binaryName;
        this.sourceFile = sourceFile;
        this.initComponents();
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jButton1 = new JButton();
        this.jLabel1.setText(NbBundle.getMessage(AttachSourcePanel.class, (String)"AttachSourcePanel.jLabel1.text", (Object)this.sourceFile));
        this.jButton1.setText(NbBundle.getMessage(AttachSourcePanel.class, (String)"AttachSourcePanel.jButton1.text"));
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AttachSourcePanel.this.attachSources(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1, -1, 608, Short.MAX_VALUE).addGap(22, 22, 22).addComponent(this.jButton1).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jButton1, -2, 25, -2)));
    }

    private void attachSources(ActionEvent evt) {
        this.jButton1.setEnabled(false);
        RP.execute(new Runnable(){

            @Override
            public void run() {
                SourceJavadocAttacher.attachSources((URL)AttachSourcePanel.this.root, (SourceJavadocAttacher.AttachmentListener)new SourceJavadocAttacher.AttachmentListener(){

                    public void attachmentSucceeded() {
                        ClassPath cp;
                        FileObject newFileFo;
                        FileObject[] fos;
                        boolean success = false;
                        FileObject rootFo = URLMapper.findFileObject((URL)AttachSourcePanel.this.root);
                        FileObject fileFo = URLMapper.findFileObject((URL)AttachSourcePanel.this.file);
                        if (rootFo != null && fileFo != null && (fos = SourceForBinaryQuery.findSourceRoots((URL)AttachSourcePanel.this.root).getRoots()).length > 0 && (newFileFo = (cp = ClassPathSupport.createClassPath((FileObject[])fos)).findResource(AttachSourcePanel.this.binaryName + ".java")) != null) {
                            try {
                                EditorCookie ec = (EditorCookie)DataObject.find((FileObject)fileFo).getLookup().lookup(EditorCookie.class);
                                Openable open = (Openable)DataObject.find((FileObject)newFileFo).getLookup().lookup(Openable.class);
                                if (ec != null && open != null) {
                                    ElementHandle activeElement = AttachSourcePanel.this.findElement(fileFo);
                                    ec.close();
                                    if (activeElement == null || !UiUtils.open(newFileFo, (ElementHandle<? extends Element>)activeElement)) {
                                        open.open();
                                    }
                                    success = true;
                                }
                            }
                            catch (DataObjectNotFoundException ex) {
                                Exceptions.printStackTrace((Throwable)ex);
                            }
                        }
                        if (!success) {
                            this.enableAttach();
                        }
                    }

                    public void attachmentFailed() {
                        this.enableAttach();
                    }

                    private void enableAttach() {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                AttachSourcePanel.this.jButton1.setEnabled(true);
                            }
                        });
                    }
                });
            }
        });
    }

    @CheckForNull
    private ElementHandle<?> findElement(@NonNull FileObject expectedFile) {
        Source src;
        final AtomicReference res = new AtomicReference();
        JTextComponent editor = EditorRegistry.lastFocusedComponent();
        final int pos = editor.getCaret().getDot() + 1;
        FileObject activeFile = EditorDocumentUtils.getFileObject((Document)editor.getDocument());
        if (expectedFile.equals(activeFile) && (src = Source.create((FileObject)expectedFile)) != null) {
            final AtomicBoolean cancel = new AtomicBoolean();
            BaseProgressUtils.runOffEventDispatchThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    try {
                        ParserManager.parse(Collections.singleton(src), (UserTask)new UserTask(){

                            public void run(ResultIterator resultIterator) throws Exception {
                                CompilationController cc;
                                if (cancel.get()) {
                                    return;
                                }
                                Parser.Result result = resultIterator.getParserResult();
                                CompilationController compilationController = cc = result == null ? null : CompilationController.get((Parser.Result)result);
                                if (cc != null) {
                                    cc.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                                    if (cancel.get()) {
                                        return;
                                    }
                                    TreePath path = cc.getTreeUtilities().pathFor(pos);
                                    Element e = AttachSourcePanel.element(path, (CompilationInfo)cc);
                                    while (e == null && (path = path.getParentPath()) != null) {
                                        if (cancel.get()) {
                                            return;
                                        }
                                        e = AttachSourcePanel.element(path, (CompilationInfo)cc);
                                    }
                                    if (e != null) {
                                        res.set(ElementHandle.create((Element)e));
                                    }
                                }
                            }
                        });
                    }
                    catch (ParseException parseException) {
                        // empty catch block
                    }
                }
            }, (String)NbBundle.getMessage(AttachSourcePanel.class, (String)"TXT_OpenAttachedSource"), (AtomicBoolean)cancel, (boolean)false);
        }
        return (ElementHandle)res.get();
    }

    @CheckForNull
    private static Element element(@NonNull TreePath path, @NonNull CompilationInfo ci) {
        Element e = ci.getTrees().getElement(path);
        if (e == null) {
            return e;
        }
        switch (e.getKind()) {
            case PACKAGE: 
            case CLASS: 
            case INTERFACE: 
            case RECORD: 
            case ENUM: 
            case ANNOTATION_TYPE: 
            case METHOD: 
            case CONSTRUCTOR: 
            case INSTANCE_INIT: 
            case STATIC_INIT: 
            case FIELD: 
            case ENUM_CONSTANT: 
            case TYPE_PARAMETER: {
                return e;
            }
        }
        return null;
    }
}

