/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.parser;

import java.util.ArrayList;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocNode;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocStaticAccessType;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocTag;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocTypeNode;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocVarTypeTag;
import org.netbeans.modules.php.editor.parser.astnodes.PHPVarComment;

public class PHPVarCommentParser {
    private static final String PHPDOCTAG = "@" + PHPDocTag.Type.VAR.name().toLowerCase();

    PHPVarComment parse(int startOffset, int endOffset, String comment) {
        boolean isPHPDoc = comment.startsWith("/**");
        int variableIndex = isPHPDoc ? 2 : 1;
        int typeIndex = isPHPDoc ? 1 : 2;
        int index = comment.indexOf(PHPDOCTAG);
        if (index > -1) {
            String definition = comment.substring(index);
            if ((index = definition.indexOf("*/")) > -1) {
                definition = definition.substring(0, index);
            }
            int endPosition = 0;
            String[] parts = definition.split("[ \t]+");
            if (this.isExpectedPartsLength(isPHPDoc, parts) && parts[variableIndex].charAt(0) == '$') {
                int startDocNode;
                String[] types = parts[typeIndex].split("[|]");
                int typePosition = startOffset + comment.indexOf(parts[typeIndex]);
                ArrayList<PHPDocTypeNode> typeNodes = new ArrayList<PHPDocTypeNode>();
                for (String type : types) {
                    PHPDocTypeNode docType;
                    boolean isArray;
                    startDocNode = typePosition + parts[typeIndex].indexOf(type);
                    index = type.indexOf("::");
                    boolean bl = isArray = type.indexOf(91) > 0 && type.indexOf(93) > 0;
                    if (isArray) {
                        type = type.substring(0, type.indexOf(91)).trim();
                    }
                    endPosition = startDocNode + type.length();
                    if (index == -1) {
                        docType = new PHPDocTypeNode(startDocNode, endPosition, type, isArray);
                    } else {
                        String className = type.substring(0, index);
                        String constantName = type.substring(index + 2);
                        PHPDocNode classNameNode = new PHPDocNode(startDocNode, startDocNode + className.length(), className);
                        PHPDocNode constantNode = new PHPDocNode(startDocNode + className.length() + 2, startDocNode + type.length(), constantName);
                        docType = new PHPDocStaticAccessType(startDocNode, startDocNode + type.length(), type, classNameNode, constantNode);
                    }
                    typeNodes.add(docType);
                }
                String variableName = parts[variableIndex];
                int indexOfArrayDimension = parts[variableIndex].indexOf("[");
                if (indexOfArrayDimension != -1) {
                    variableName = parts[variableIndex].substring(0, indexOfArrayDimension);
                }
                startDocNode = startOffset + comment.indexOf(variableName);
                PHPDocNode variableNode = new PHPDocNode(startDocNode, startDocNode + variableName.length(), variableName);
                startDocNode = startOffset + comment.indexOf(PHPDOCTAG);
                PHPDocVarTypeTag variableType = new PHPDocVarTypeTag(startDocNode, endPosition, PHPDocTag.Type.VAR, definition, typeNodes, variableNode);
                return new PHPVarComment(startOffset, endOffset, variableType);
            }
        }
        return null;
    }

    private boolean isExpectedPartsLength(boolean isPHPDoc, String[] parts) {
        if (isPHPDoc) {
            return parts.length >= 3;
        }
        return parts.length == 3;
    }
}

