/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.hcl.terraform;

import java.util.List;
import java.util.Set;
import org.netbeans.modules.csl.api.ColoringAttributes;
import org.netbeans.modules.languages.hcl.HCLParserResult;
import org.netbeans.modules.languages.hcl.HCLSemanticAnalyzer;
import org.netbeans.modules.languages.hcl.SourceRef;
import org.netbeans.modules.languages.hcl.ast.HCLBlock;
import org.netbeans.modules.languages.hcl.ast.HCLDocument;
import org.netbeans.modules.languages.hcl.ast.HCLExpression;
import org.netbeans.modules.languages.hcl.ast.HCLIdentifier;
import org.netbeans.modules.languages.hcl.ast.HCLResolveOperation;
import org.netbeans.modules.languages.hcl.ast.HCLVariable;
import org.netbeans.modules.languages.hcl.terraform.TerraformParserResult;

public final class TerraformSemanticAnalyzer
extends HCLSemanticAnalyzer {
    private static final Set<String> RESOLVE_BASES = Set.of("data", "local", "module", "path", "provider", "var");
    private static final Set<String> LITERAL_TYPES = Set.of("bool", "number", "null", "string");

    @Override
    protected HCLSemanticAnalyzer.Highlighter createHighlighter(HCLParserResult result) {
        return new TerraformHighlighter(result.getReferences());
    }

    private class TerraformHighlighter
    extends HCLSemanticAnalyzer.DefaultHighlighter {
        private TerraformParserResult.BlockType rootBlockType;

        protected TerraformHighlighter(SourceRef refs) {
            super(refs);
        }

        @Override
        protected boolean visitBlock(HCLBlock block) {
            List<HCLIdentifier> dcl;
            if (block.getParent() instanceof HCLDocument && !(dcl = block.getDeclaration()).isEmpty()) {
                this.rootBlockType = TerraformParserResult.BlockType.get(dcl.get(0).id());
            }
            return super.visitBlock(block);
        }

        @Override
        protected boolean visitExpression(HCLExpression expr) {
            if (expr instanceof HCLResolveOperation.Attribute) {
                HCLResolveOperation.Attribute attr = (HCLResolveOperation.Attribute)expr;
                if (this.rootBlockType != null && attr.base instanceof HCLVariable) {
                    String name = ((HCLVariable)attr.base).name.id;
                    switch (this.rootBlockType) {
                        case CHECK: 
                        case DATA: 
                        case LOCALS: 
                        case MODULE: 
                        case OUTPUT: 
                        case PROVIDER: 
                        case RESOURCE: {
                            if (!RESOLVE_BASES.contains(name)) break;
                            this.mark(attr.base, ColoringAttributes.FIELD_SET);
                        }
                    }
                    return false;
                }
            }
            if (this.rootBlockType == TerraformParserResult.BlockType.VARIABLE && expr instanceof HCLVariable) {
                String name = ((HCLVariable)expr).name.id;
                if (LITERAL_TYPES.contains(name)) {
                    this.mark(expr, ColoringAttributes.FIELD_SET);
                }
                return false;
            }
            return super.visitExpression(expr);
        }
    }
}

