/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.execute;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.gradle.api.execute.ActionMapping;
import org.netbeans.modules.gradle.api.execute.GradleExecConfiguration;
import org.netbeans.modules.gradle.execute.ConfigPersistenceUtils;
import org.netbeans.modules.gradle.execute.ConfigurableActionProvider;
import org.netbeans.modules.gradle.execute.GradleExecAccessor;
import org.netbeans.modules.gradle.execute.ProjectConfigurationSupport;
import org.netbeans.modules.gradle.execute.ProjectConfigurationUpdater;
import org.netbeans.modules.gradle.spi.actions.ProjectActionMappingProvider;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.netbeans.spi.project.ProjectConfigurationProvider;
import org.netbeans.spi.project.ui.CustomizerProvider2;
import org.openide.util.Lookup;

public class GradleProjectConfigProvider
implements ProjectConfigurationProvider<GradleExecConfiguration>,
ProjectConfigurationUpdater,
ChangeListener {
    private final PropertyChangeSupport supp = new PropertyChangeSupport(this);
    private final Project project;
    private List<GradleExecConfiguration> configurations = null;
    private Map<String, GradleExecConfiguration> sharedConfigs = new HashMap<String, GradleExecConfiguration>();
    private Map<String, GradleExecConfiguration> privateConfigs = new HashMap<String, GradleExecConfiguration>();
    private String activeConfigId;
    private AuxiliaryConfiguration aux;
    private ConfigurableActionProvider configProvider;
    private AtomicInteger serial = new AtomicInteger(0);

    public GradleProjectConfigProvider(Project project) {
        this.project = project;
    }

    public void setConfigurableProvider(ConfigurableActionProvider provider) {
        this.configProvider = provider;
        provider.addChangeListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<GradleExecConfiguration> getConfigurations() {
        GradleProjectConfigProvider gradleProjectConfigProvider = this;
        synchronized (gradleProjectConfigProvider) {
            if (this.configurations != null) {
                return Collections.unmodifiableCollection(this.configurations);
            }
        }
        return this.refreshConfigurations();
    }

    private synchronized AuxiliaryConfiguration aux() {
        if (this.aux == null) {
            this.aux = ProjectUtils.getAuxiliaryConfiguration((Project)this.project);
        }
        return this.aux;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GradleExecConfiguration getActiveConfiguration() {
        String activeId;
        GradleExecConfiguration cfg = ProjectConfigurationSupport.getExplicitConfiguration(this.project, Lookup.EMPTY);
        if (cfg != null) {
            return cfg;
        }
        Collection<GradleExecConfiguration> confs = this.getConfigurations();
        GradleProjectConfigProvider gradleProjectConfigProvider = this;
        synchronized (gradleProjectConfigProvider) {
            if (this.activeConfigId == null) {
                this.activeConfigId = ConfigPersistenceUtils.readActiveConfiguration(this.aux());
            }
            activeId = this.activeConfigId;
        }
        GradleExecConfiguration def = null;
        for (GradleExecConfiguration c : confs) {
            String cid = c.getId();
            if ("%%DEFAULT%%".equals(cid)) {
                def = c;
            }
            if (!activeId.equals(c.getId())) continue;
            return c;
        }
        return def;
    }

    private GradleExecConfiguration getDefaultConfiguration() {
        Collection<GradleExecConfiguration> confs = this.getConfigurations();
        return confs.iterator().next();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setActiveConfiguration(GradleExecConfiguration configuration) throws IllegalArgumentException, IOException {
        boolean empty;
        String id;
        GradleExecConfiguration d = this.getDefaultConfiguration();
        GradleExecConfiguration a = this.getActiveConfiguration();
        if (configuration == null) {
            configuration = d;
        } else {
            ArrayList<GradleExecConfiguration> confs = new ArrayList<GradleExecConfiguration>(this.getConfigurations());
            int idx = confs.indexOf(configuration);
            if (idx == -1) {
                throw new IllegalArgumentException("Unknown config: " + configuration);
            }
            configuration = (GradleExecConfiguration)confs.get(idx);
        }
        GradleProjectConfigProvider gradleProjectConfigProvider = this;
        synchronized (gradleProjectConfigProvider) {
            if (a == configuration) {
                return;
            }
            id = d == configuration ? "%%DEFAULT%%" : configuration.getId();
            this.activeConfigId = id;
            empty = this.sharedConfigs.isEmpty() && this.privateConfigs.isEmpty();
        }
        ConfigPersistenceUtils.writeActiveConfiguration(this.aux(), id, empty);
        this.supp.firePropertyChange("activeConfiguration", a, configuration);
    }

    public boolean hasCustomizer() {
        return this.project.getLookup().lookup(CustomizerProvider2.class) != null;
    }

    public void customize() {
        CustomizerProvider2 provider = (CustomizerProvider2)this.project.getLookup().lookup(CustomizerProvider2.class);
        provider.showCustomizer("CONFIGURATIONS", null);
    }

    public boolean configurationsAffectAction(String command) {
        switch (command) {
            case "delete": 
            case "copy": 
            case "move": 
            case "rename": {
                return false;
            }
        }
        return true;
    }

    public void addPropertyChangeListener(PropertyChangeListener lst) {
        this.supp.addPropertyChangeListener(lst);
    }

    public void removePropertyChangeListener(PropertyChangeListener lst) {
        this.supp.removePropertyChangeListener(lst);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSharedConfiguration(GradleExecConfiguration c) {
        if ("%%DEFAULT%%".equals(c.getId())) {
            return true;
        }
        GradleProjectConfigProvider gradleProjectConfigProvider = this;
        synchronized (gradleProjectConfigProvider) {
            return this.sharedConfigs.get(c.getId()) != null;
        }
    }

    @Override
    public void setConfigurations(List<GradleExecConfiguration> shared, List<GradleExecConfiguration> nonShared) {
        GradleExecConfiguration a = this.getActiveConfiguration();
        String aid = a == null ? null : a.getId();
        ProjectManager.mutex((boolean)false, (Project)this.project, (Project[])new Project[0]).writeAccess(() -> {
            ConfigPersistenceUtils.writeConfigurations(shared, this.aux, null, true);
            ConfigPersistenceUtils.writeConfigurations(nonShared, this.aux, aid, false);
            LinkedHashMap<String, GradleExecConfiguration> mapShared = new LinkedHashMap<String, GradleExecConfiguration>();
            LinkedHashMap<String, GradleExecConfiguration> mapPrivate = new LinkedHashMap<String, GradleExecConfiguration>();
            shared.forEach(c -> mapShared.put(c.getId(), (GradleExecConfiguration)c));
            nonShared.forEach(c -> mapPrivate.put(c.getId(), (GradleExecConfiguration)c));
            Map<String, GradleExecConfiguration> newCfg = this.buildConfigurations(mapShared, mapPrivate);
            this.updateConfigurations(-1, mapShared, mapPrivate, newCfg);
        });
    }

    private List<GradleExecConfiguration> refreshConfigurations() {
        int stamp = this.serial.incrementAndGet();
        LinkedHashMap<String, GradleExecConfiguration> newShared = new LinkedHashMap<String, GradleExecConfiguration>();
        LinkedHashMap<String, GradleExecConfiguration> newPrivate = new LinkedHashMap<String, GradleExecConfiguration>();
        ConfigPersistenceUtils.readConfigurations(newShared, this.aux(), true);
        ConfigPersistenceUtils.readConfigurations(newPrivate, this.aux(), false);
        return (List)ProjectManager.mutex((boolean)false, (Project)this.project, (Project[])new Project[0]).readAccess(() -> {
            Map<String, GradleExecConfiguration> newCfg = this.buildConfigurations(newShared, newPrivate);
            return this.updateConfigurations(stamp, newShared, newPrivate, newCfg);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<GradleExecConfiguration> updateConfigurations(int stamp, Map<String, GradleExecConfiguration> newShared, Map<String, GradleExecConfiguration> newPrivate, Map<String, GradleExecConfiguration> newCfg) {
        boolean changed;
        ArrayList<GradleExecConfiguration> lst;
        List<GradleExecConfiguration> old;
        GradleProjectConfigProvider gradleProjectConfigProvider = this;
        synchronized (gradleProjectConfigProvider) {
            old = this.configurations;
            lst = new ArrayList<GradleExecConfiguration>();
            lst.add(newCfg.remove("%%DEFAULT%%"));
            lst.addAll(newCfg.values());
            if (stamp < 0 || stamp == this.serial.get()) {
                changed = this.configurations != null && !this.configurations.equals(lst);
                this.configurations = lst;
                this.sharedConfigs = newShared;
                this.privateConfigs = newPrivate;
            } else {
                changed = false;
            }
        }
        if (changed) {
            ProjectManager.mutex((boolean)false, (Project)this.project, (Project[])new Project[0]).postWriteRequest(() -> this.supp.firePropertyChange("configurations", old, lst));
        }
        return lst;
    }

    @Override
    public Collection<GradleExecConfiguration> getSharedConfigurations() {
        return this.sharedConfigs.values();
    }

    @Override
    public Collection<GradleExecConfiguration> getPrivateConfigurations() {
        return this.privateConfigs.values();
    }

    private Map<String, GradleExecConfiguration> buildConfigurations(Map<String, GradleExecConfiguration> sharedConf, Map<String, GradleExecConfiguration> privateConf) {
        LinkedHashMap<String, GradleExecConfiguration> result = new LinkedHashMap<String, GradleExecConfiguration>();
        result.putAll(sharedConf);
        result.putAll(privateConf);
        for (GradleExecConfiguration c : this.getFixedConfigurations()) {
            result.putIfAbsent(c.getId(), c);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<GradleExecConfiguration> getFixedConfigurations() {
        LinkedHashSet<GradleExecConfiguration> result = new LinkedHashSet<GradleExecConfiguration>();
        if (this.configProvider == null) {
            ConfigurableActionProvider p = (ConfigurableActionProvider)this.project.getLookup().lookup(ConfigurableActionProvider.class);
            if (p == null) {
                p = new ConfigurableActionProvider(){

                    @Override
                    public ActionMapping findDefaultMapping(String configurationId, String action) {
                        return null;
                    }

                    @Override
                    public void addChangeListener(ChangeListener l) {
                    }

                    @Override
                    public void removeChangeListener(ChangeListener l) {
                    }

                    @Override
                    public List<GradleExecConfiguration> findConfigurations() {
                        return Collections.emptyList();
                    }

                    @Override
                    public ProjectActionMappingProvider findActionProvider(String configurationId) {
                        return null;
                    }
                };
            }
            GradleProjectConfigProvider gradleProjectConfigProvider = this;
            synchronized (gradleProjectConfigProvider) {
                if (this.configProvider == null) {
                    this.setConfigurableProvider(p);
                }
            }
        }
        boolean defPresent = false;
        for (GradleExecConfiguration c : this.configProvider.findConfigurations()) {
            defPresent |= "%%DEFAULT%%".equals(c.getId());
            result.add(c);
        }
        if (!defPresent) {
            result.add(GradleExecAccessor.createDefault());
        }
        return result;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.refreshConfigurations();
    }
}

