/*
 * Decompiled with CFR 0.152.
 */
package org.dhatim.fastexcel;

import java.io.IOException;
import java.util.Objects;
import org.dhatim.fastexcel.Alignment;
import org.dhatim.fastexcel.Protection;
import org.dhatim.fastexcel.Writer;

class Style {
    private final int valueFormatting;
    private final int font;
    private final int fill;
    private final int border;
    private final Alignment alignment;
    private final Protection protection;

    Style(Style original, int valueFormatting, int font, int fill, int border, Alignment alignment, Protection protection) {
        this.valueFormatting = valueFormatting == 0 && original != null ? original.valueFormatting : valueFormatting;
        this.font = font == 0 && original != null ? original.font : font;
        this.fill = fill == 0 && original != null ? original.fill : fill;
        this.border = border == 0 && original != null ? original.border : border;
        this.alignment = alignment == null && original != null ? original.alignment : alignment;
        this.protection = protection == null && original != null ? original.protection : protection;
    }

    public int hashCode() {
        return Objects.hash(this.valueFormatting, this.font, this.fill, this.border, this.alignment, this.protection);
    }

    public boolean equals(Object obj) {
        boolean result;
        if (obj != null && obj.getClass() == this.getClass()) {
            Style other = (Style)obj;
            result = Objects.equals(this.valueFormatting, other.valueFormatting) && Objects.equals(this.font, other.font) && Objects.equals(this.fill, other.fill) && Objects.equals(this.border, other.border) && Objects.equals(this.alignment, other.alignment) && Objects.equals(this.protection, other.protection);
        } else {
            result = false;
        }
        return result;
    }

    void write(Writer w) throws IOException {
        w.append("<xf numFmtId=\"").append(this.valueFormatting).append("\" fontId=\"").append(this.font).append("\" fillId=\"").append(this.fill).append("\" borderId=\"").append(this.border).append("\" xfId=\"0\"");
        if (this.border != 0) {
            w.append(" applyBorder=\"1\"");
        }
        if (this.alignment == null && this.protection == null) {
            w.append("/>");
            return;
        }
        w.append('>');
        if (this.alignment != null) {
            this.alignment.write(w);
        }
        if (this.protection != null) {
            this.protection.write(w);
        }
        w.append("</xf>");
    }
}

