/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.array;

import com.oracle.truffle.js.runtime.array.ByteBufferSupport;
import java.nio.ByteBuffer;

abstract class ByteBufferAccess {
    ByteBufferAccess() {
    }

    public final int getInt8(ByteBuffer buffer, int index) {
        return buffer.get(index);
    }

    public final int getUint8(ByteBuffer buffer, int index) {
        return this.getInt8(buffer, index) & 0xFF;
    }

    public abstract int getInt16(ByteBuffer var1, int var2);

    public final int getUint16(ByteBuffer buffer, int index) {
        return this.getInt16(buffer, index) & 0xFFFF;
    }

    public abstract int getInt32(ByteBuffer var1, int var2);

    public final long getUint32(ByteBuffer buffer, int index) {
        return (long)this.getInt32(buffer, index) & 0xFFFFFFFFL;
    }

    public abstract float getFloat(ByteBuffer var1, int var2);

    public abstract double getDouble(ByteBuffer var1, int var2);

    public abstract long getInt64(ByteBuffer var1, int var2);

    public final void putInt8(ByteBuffer buffer, int index, int value) {
        buffer.put(index, (byte)value);
    }

    public abstract void putInt16(ByteBuffer var1, int var2, int var3);

    public abstract void putInt32(ByteBuffer var1, int var2, int var3);

    public abstract void putFloat(ByteBuffer var1, int var2, float var3);

    public abstract void putDouble(ByteBuffer var1, int var2, double var3);

    public abstract void putInt64(ByteBuffer var1, int var2, long var3);

    static final ByteBufferAccess littleEndian() {
        return ByteBufferSupport.littleEndian();
    }

    static final ByteBufferAccess bigEndian() {
        return ByteBufferSupport.bigEndian();
    }

    static final ByteBufferAccess nativeOrder() {
        return ByteBufferSupport.nativeOrder();
    }

    static final ByteBufferAccess forOrder(boolean littleEndian) {
        return littleEndian ? ByteBufferAccess.littleEndian() : ByteBufferAccess.bigEndian();
    }
}

