/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.devops.responses;

import com.oracle.bmc.responses.BmcResponse;
import java.beans.ConstructorProperties;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class GetObjectContentResponse
extends BmcResponse {
    private String opcRequestId;
    private String contentType;
    private String contentDisposition;
    private InputStream inputStream;

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getContentDisposition() {
        return this.contentDisposition;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    @ConstructorProperties(value={"__httpStatusCode__", "headers", "opcRequestId", "contentType", "contentDisposition", "inputStream"})
    private GetObjectContentResponse(int __httpStatusCode__, Map<String, List<String>> headers, String opcRequestId, String contentType, String contentDisposition, InputStream inputStream) {
        super(__httpStatusCode__, headers);
        this.opcRequestId = opcRequestId;
        this.contentType = contentType;
        this.contentDisposition = contentDisposition;
        this.inputStream = inputStream;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",contentType=").append(String.valueOf(this.contentType));
        sb.append(",contentDisposition=").append(String.valueOf(this.contentDisposition));
        sb.append(",inputStream=").append(String.valueOf(this.inputStream));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetObjectContentResponse)) {
            return false;
        }
        GetObjectContentResponse other = (GetObjectContentResponse)((Object)o);
        return super.equals(o) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.contentType, other.contentType) && Objects.equals(this.contentDisposition, other.contentDisposition) && Objects.equals(this.inputStream, other.inputStream);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.contentType == null ? 43 : this.contentType.hashCode());
        result = result * 59 + (this.contentDisposition == null ? 43 : this.contentDisposition.hashCode());
        result = result * 59 + (this.inputStream == null ? 43 : this.inputStream.hashCode());
        return result;
    }

    public static class Builder
    implements BmcResponse.Builder<GetObjectContentResponse> {
        private int __httpStatusCode__;
        private Map<String, List<String>> headers;
        private String opcRequestId;
        private String contentType;
        private String contentDisposition;
        private InputStream inputStream;

        public Builder __httpStatusCode__(int __httpStatusCode__) {
            this.__httpStatusCode__ = __httpStatusCode__;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            this.headers = headers;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public Builder contentDisposition(String contentDisposition) {
            this.contentDisposition = contentDisposition;
            return this;
        }

        public Builder inputStream(InputStream inputStream) {
            this.inputStream = inputStream;
            return this;
        }

        public Builder copy(GetObjectContentResponse o) {
            this.__httpStatusCode__(o.get__httpStatusCode__());
            this.headers(o.getHeaders());
            this.opcRequestId(o.getOpcRequestId());
            this.contentType(o.getContentType());
            this.contentDisposition(o.getContentDisposition());
            this.inputStream(o.getInputStream());
            return this;
        }

        public GetObjectContentResponse build() {
            return new GetObjectContentResponse(this.__httpStatusCode__, this.headers, this.opcRequestId, this.contentType, this.contentDisposition, this.inputStream);
        }
    }
}

