/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.client.admin.cli;

import java.util.ArrayList;
import java.util.Arrays;
import org.jboss.aesh.console.AeshConsoleBuilder;
import org.jboss.aesh.console.AeshConsoleImpl;
import org.jboss.aesh.console.Prompt;
import org.jboss.aesh.console.command.registry.AeshCommandRegistryBuilder;
import org.jboss.aesh.console.command.registry.CommandRegistry;
import org.jboss.aesh.console.settings.Settings;
import org.jboss.aesh.console.settings.SettingsBuilder;
import org.keycloak.client.admin.cli.aesh.AeshEnhancer;
import org.keycloak.client.admin.cli.aesh.Globals;
import org.keycloak.client.admin.cli.aesh.ValveInputStream;
import org.keycloak.client.admin.cli.commands.KcAdmCmd;
import org.keycloak.client.admin.cli.util.ClassLoaderUtil;
import org.keycloak.common.crypto.CryptoIntegration;

public class KcAdmMain {
    public static void main(String[] args) {
        String libDir = System.getProperty("kc.lib.dir");
        if (libDir == null) {
            throw new RuntimeException("System property kc.lib.dir needs to be set");
        }
        ClassLoader cl = ClassLoaderUtil.resolveClassLoader(libDir);
        Thread.currentThread().setContextClassLoader(cl);
        CryptoIntegration.init(cl);
        Globals.stdin = new ValveInputStream();
        Settings settings = new SettingsBuilder().logging(false).readInputrc(false).disableCompletion(true).disableHistory(true).enableAlias(false).enableExport(false).inputStream(Globals.stdin).create();
        CommandRegistry registry = new AeshCommandRegistryBuilder().command(KcAdmCmd.class).create();
        AeshConsoleImpl console = (AeshConsoleImpl)new AeshConsoleBuilder().settings(settings).commandRegistry(registry).prompt(new Prompt("")).create();
        AeshEnhancer.enhance(console);
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add("kcadm");
        arguments.addAll(Arrays.asList(args));
        Globals.args = arguments;
        StringBuilder b = new StringBuilder();
        for (String s : args) {
            boolean needQuote = false;
            needQuote = s.indexOf(32) != -1 || s.indexOf(34) != -1 || s.indexOf(39) != -1;
            b.append(' ');
            if (needQuote) {
                b.append('\'');
            }
            b.append(s);
            if (!needQuote) continue;
            b.append('\'');
        }
        console.setEcho(false);
        console.execute("kcadm" + b.toString());
        console.start();
    }
}

