/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.ops;

import com.adobe.epubcheck.api.EPUBLocation;
import com.adobe.epubcheck.api.EPUBProfile;
import com.adobe.epubcheck.messages.MessageId;
import com.adobe.epubcheck.opf.OPFChecker;
import com.adobe.epubcheck.opf.OPFChecker30;
import com.adobe.epubcheck.opf.OPFItem;
import com.adobe.epubcheck.opf.ValidationContext;
import com.adobe.epubcheck.ops.OPSHandler;
import com.adobe.epubcheck.util.EPUBVersion;
import com.adobe.epubcheck.util.FeatureEnum;
import com.adobe.epubcheck.util.SourceSet;
import com.adobe.epubcheck.vocab.AggregateVocab;
import com.adobe.epubcheck.vocab.AltStylesheetVocab;
import com.adobe.epubcheck.vocab.ComicsVocab;
import com.adobe.epubcheck.vocab.DataNavVocab;
import com.adobe.epubcheck.vocab.DictVocab;
import com.adobe.epubcheck.vocab.EpubCheckVocab;
import com.adobe.epubcheck.vocab.ForeignVocabs;
import com.adobe.epubcheck.vocab.IndexVocab;
import com.adobe.epubcheck.vocab.MagazineNavigationVocab;
import com.adobe.epubcheck.vocab.PackageVocabs;
import com.adobe.epubcheck.vocab.Property;
import com.adobe.epubcheck.vocab.StagingEdupubVocab;
import com.adobe.epubcheck.vocab.StructureVocab;
import com.adobe.epubcheck.vocab.UncheckedVocab;
import com.adobe.epubcheck.vocab.Vocab;
import com.adobe.epubcheck.vocab.VocabUtil;
import com.adobe.epubcheck.xml.model.XMLAttribute;
import com.adobe.epubcheck.xml.model.XMLElement;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import io.mola.galimatias.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.w3c.epubcheck.constants.MIMEType;
import org.w3c.epubcheck.core.references.Reference;
import org.w3c.epubcheck.core.references.Resource;
import org.w3c.epubcheck.core.references.ResourceRegistry;
import org.w3c.epubcheck.util.microsyntax.ViewportMeta;
import org.w3c.epubcheck.util.url.URLUtils;

public class OPSHandler30
extends OPSHandler {
    private static final String HAS_PALPABLE_CONTENT = "IS_PALPABLE";
    private static Map<String, Vocab> RESERVED_VOCABS = ImmutableMap.of((Object)"", (Object)AggregateVocab.of(StructureVocab.VOCAB, StagingEdupubVocab.VOCAB, DataNavVocab.VOCAB, DictVocab.VOCAB, IndexVocab.VOCAB, ComicsVocab.VOCAB, StructureVocab.UNCHECKED_VOCAB), (Object)"msv", (Object)MagazineNavigationVocab.VOCAB, (Object)"prism", (Object)ForeignVocabs.PRISM_VOCAB);
    private static Map<String, Vocab> ALTCSS_VOCABS = ImmutableMap.of((Object)"", (Object)AggregateVocab.of(AltStylesheetVocab.VOCAB, new UncheckedVocab("", "")));
    private static Map<String, Vocab> KNOWN_VOCAB_URIS = ImmutableMap.of((Object)"http://www.idpf.org/epub/vocab/structure/magazine/#", (Object)MagazineNavigationVocab.VOCAB, (Object)"http://www.prismstandard.org/specifications/3.0/PRISM_CV_Spec_3.0.htm#", (Object)ForeignVocabs.PRISM_VOCAB);
    private static Set<String> DEFAULT_VOCAB_URIS = ImmutableSet.of((Object)"http://www.idpf.org/epub/vocab/structure/#");
    private static final Splitter TOKENIZER = Splitter.onPattern((String)"\\s+").omitEmptyStrings();
    private Map<String, Vocab> vocabs = RESERVED_VOCABS;
    private final Set<PackageVocabs.ITEM_PROPERTIES> requiredProperties = EnumSet.noneOf(PackageVocabs.ITEM_PROPERTIES.class);
    private final Set<PackageVocabs.ITEM_PROPERTIES> allowedProperties = EnumSet.noneOf(PackageVocabs.ITEM_PROPERTIES.class);
    private final boolean isLinear;
    protected boolean inPicture = false;
    protected boolean anchorNeedsText = false;
    protected boolean inMathML = false;
    protected boolean inSvg = false;
    protected boolean inBody = false;
    protected boolean inRegionBasedNav = false;
    protected boolean isOutermostSVGAlreadyProcessed = false;
    protected boolean hasAltorAnnotation = false;
    protected boolean hasLabel = false;
    protected boolean hasListItem = false;
    protected boolean hasViewport = false;
    private Map<URL, String> mediaSources;
    protected static final String[] scriptEventsStrings = new String[]{"onafterprint", "onbeforeprint", "onbeforeunload", "onerror", "onhaschange", "onload", "onmessage", "onoffline", "onpagehide", "onpageshow", "onpopstate", "onredo", "onresize", "onstorage", "onundo", "onunload", "onblur", "onchange", "oncontextmenu", "onfocus", "onformchange", "onforminput", "oninput", "oninvalid", "onreset", "onselect", "onsubmit", "onkeydown", "onkeypress", "onkeyup", "onabort", "oncanplay", "oncanplaythrough", "ondurationchange", "onemptied", "onended", "onerror", "onloadeddata", "onloadedmetadata", "onloadstart", "onpause", "onplay", "onplaying", "onprogress", "onratechange", "onreadystatechange", "onseeked", "onseeking", "onstalled", "onsuspend", "ontimeupdate", "onvolumechange", "onwaiting"};
    protected static HashSet<String> scriptEvents;
    protected static final String[] mouseEventsStrings;
    protected static HashSet<String> mouseEvents;

    public static HashSet<String> getScriptEvents() {
        if (scriptEvents == null) {
            scriptEvents = new HashSet();
            Collections.addAll(scriptEvents, scriptEventsStrings);
            Collections.addAll(scriptEvents, mouseEventsStrings);
        }
        return scriptEvents;
    }

    public static HashSet<String> getMouseEvents() {
        if (mouseEvents == null) {
            mouseEvents = new HashSet();
            Collections.addAll(mouseEvents, mouseEventsStrings);
        }
        return mouseEvents;
    }

    public OPSHandler30(ValidationContext context) {
        super(context);
        this.isLinear = !context.properties.contains(EpubCheckVocab.VOCAB.get(EpubCheckVocab.PROPERTIES.NON_LINEAR));
    }

    @Override
    protected void checkImage(String attrNS, String attr) {
        XMLElement e = this.currentElement();
        if ("http://www.w3.org/2000/svg".equals(e.getNamespace())) {
            URL url = this.checkResourceURL(e.getAttributeNS(attrNS, attr));
            this.registerReference(url, Reference.Type.IMAGE);
        } else {
            String src = e.getAttribute("src");
            String srcset = e.getAttribute("srcset");
            TreeSet<String> imageSources = new TreeSet<String>();
            if (src != null) {
                imageSources.add(src);
            }
            imageSources.addAll(SourceSet.parse(srcset).getImageURLs());
            for (String urlString : imageSources) {
                URL url = this.checkResourceURL(urlString);
                if (url == null || !this.context.referenceRegistry.isPresent()) continue;
                Resource imageResource = ((ResourceRegistry)this.context.resourceRegistry.get()).getResource(URLUtils.docURL(url)).orElse(null);
                if (this.inPicture && imageResource != null) {
                    String mimetype = imageResource.getMimeType();
                    URL imageURL = imageResource.getURL();
                    switch (e.getName()) {
                        case "img": {
                            if (OPFChecker.isBlessedImageType(mimetype, EPUBVersion.VERSION_3)) break;
                            this.report.message(MessageId.MED_003, this.location(), this.context.relativize(imageURL), mimetype);
                            break;
                        }
                        case "source": {
                            String type = Strings.nullToEmpty((String)e.getAttribute("type")).trim();
                            if (type.isEmpty() && !OPFChecker.isBlessedImageType(mimetype, EPUBVersion.VERSION_3)) {
                                this.report.message(MessageId.MED_007, this.location(), this.context.relativize(imageURL), mimetype);
                                break;
                            }
                            this.checkMimetypeMatches(url, type);
                        }
                    }
                }
                this.registerReference(url, Reference.Type.IMAGE, this.inPicture);
            }
        }
    }

    protected void checkType(String type) {
        if (type == null) {
            return;
        }
        Set<Property> propList = VocabUtil.parsePropertyList(type, this.vocabs, this.context, this.location());
        this.checkTypes(Property.filter(propList, StructureVocab.EPUB_TYPES.class));
        for (Property property : propList) {
            if (!"http://www.idpf.org/epub/vocab/structure/#".equals(property.getVocabURI())) continue;
            try {
                property.toEnum();
            }
            catch (UnsupportedOperationException ex) {
                this.report.message(MessageId.OPF_088, this.location(), property.getName());
            }
        }
        if (propList.contains(DataNavVocab.VOCAB.get(DataNavVocab.EPUB_TYPES.REGION_BASED))) {
            if (!"nav".equals(this.currentElement().getName()) || !this.context.properties.contains(PackageVocabs.ITEM_VOCAB.get(PackageVocabs.ITEM_PROPERTIES.DATA_NAV))) {
                this.report.message(MessageId.HTM_052, this.location(), new Object[0]);
            } else {
                this.inRegionBasedNav = true;
            }
        }
        if (propList.contains(DictVocab.VOCAB.get(DictVocab.EPUB_TYPES.DICTIONARY))) {
            this.context.featureReport.report(FeatureEnum.DICTIONARY, this.location(), null);
        }
    }

    protected void checkTypes(Set<StructureVocab.EPUB_TYPES> types) {
        if (types.contains(StructureVocab.EPUB_TYPES.PAGEBREAK)) {
            this.context.featureReport.report(FeatureEnum.PAGE_BREAK, this.location(), null);
        }
        if (types.contains(StructureVocab.EPUB_TYPES.INDEX)) {
            this.allowedProperties.add(PackageVocabs.ITEM_PROPERTIES.INDEX);
            this.context.featureReport.report(FeatureEnum.INDEX, this.location(), null);
        }
        if (types.contains(StructureVocab.EPUB_TYPES.GLOSSARY)) {
            this.allowedProperties.add(PackageVocabs.ITEM_PROPERTIES.GLOSSARY);
        }
    }

    @Override
    protected URL checkSVGFontFaceURI() {
        URL href = super.checkSVGFontFaceURI();
        if (href != null && this.context.isRemote(href)) {
            this.requiredProperties.add(PackageVocabs.ITEM_PROPERTIES.REMOTE_RESOURCES);
        }
        return href;
    }

    protected void checkSSMLPh(String ph) {
        if (ph == null) {
            return;
        }
        if (ph.trim().length() < 1) {
            this.report.message(MessageId.HTM_007, this.location(), new Object[0]);
        }
    }

    @Override
    public void characters(char[] chars, int arg1, int arg2) {
        super.characters(chars, arg1, arg2);
        if (!new String(chars, arg1, arg2).trim().isEmpty()) {
            this.currentElement().setPrivateData(HAS_PALPABLE_CONTENT, true);
        }
        if (this.anchorNeedsText) {
            this.anchorNeedsText = false;
        }
    }

    @Override
    public void startElement() {
        super.startElement();
        XMLElement e = this.currentElement();
        e.setPrivateData(HAS_PALPABLE_CONTENT, false);
        this.checkDiscouragedElements();
        this.processSemantics();
        this.processSectioning();
        String name = e.getName();
        if ("http://www.w3.org/1999/xhtml".equals(e.getNamespace())) {
            if (name.equals("html")) {
                this.vocabs = VocabUtil.parsePrefixDeclaration(e.getAttributeNS("http://www.idpf.org/2007/ops", "prefix"), RESERVED_VOCABS, KNOWN_VOCAB_URIS, DEFAULT_VOCAB_URIS, this.report, this.location());
            } else if (name.equals("meta")) {
                this.processMeta();
            } else if (name.equals("form")) {
                this.requiredProperties.add(PackageVocabs.ITEM_PROPERTIES.SCRIPTED);
            } else if (name.equals("link")) {
                this.processLink();
            } else if (name.equals("audio")) {
                this.startMediaElement();
            } else if (name.equals("video")) {
                this.processVideo();
                this.startMediaElement();
            } else if (name.equals("figure")) {
                this.processFigure();
            } else if (name.equals("table")) {
                this.processTable();
            } else if (name.equals("track")) {
                this.startTrack();
            } else if (name.equals("a")) {
                this.anchorNeedsText = true;
                this.processAnchor(e);
            } else if (name.equals("input")) {
                this.startInput();
            } else if (name.equals("picture")) {
                this.inPicture = true;
            } else if (name.equals("source")) {
                if ("picture".equals(e.getParent().getName())) {
                    this.checkImage(null, null);
                } else {
                    this.startMediaSource();
                }
            } else if (name.equals("embed")) {
                this.startEmbed();
            } else if (name.equals("blockquote") || name.equals("q") || name.equals("ins") || name.equals("del")) {
                this.checkCiteAttribute();
            }
        } else if ("http://www.w3.org/1998/Math/MathML".equals(e.getNamespace())) {
            if (name.equals("math")) {
                this.requiredProperties.add(PackageVocabs.ITEM_PROPERTIES.MATHML);
                this.inMathML = true;
                this.hasAltorAnnotation = null != e.getAttribute("alttext");
                String altimg = e.getAttribute("altimg");
                if (altimg != null) {
                    super.checkImage(null, "altimg");
                }
            } else if (name.equals("annotation-xml")) {
                this.hasAltorAnnotation = true;
            }
        } else if ("http://www.w3.org/2000/svg".equals(e.getNamespace())) {
            if (name.equals("svg")) {
                this.processSVG();
            } else if (name.equals("a")) {
                this.anchorNeedsText = true;
                this.processAnchor(e);
            } else if (name.equals("title")) {
                this.hasLabel = true;
            } else if (name.equals("text")) {
                this.hasLabel = true;
            }
        } else if ("http://www.idpf.org/2007/ops".equals(e.getNamespace()) && name.equals("switch")) {
            this.requiredProperties.add(PackageVocabs.ITEM_PROPERTIES.SWITCH);
        }
        this.processInlineScripts();
        this.checkType(e.getAttributeNS("http://www.idpf.org/2007/ops", "type"));
        this.checkSSMLPh(e.getAttributeNS("http://www.w3.org/2001/10/synthesis", "ph"));
    }

    private void checkCiteAttribute() {
        URL url = this.checkURL(this.currentElement().getAttribute("cite"));
        this.registerReference(url, Reference.Type.CITE);
    }

    private void startTrack() {
        URL url = this.checkResourceURL(this.currentElement().getAttribute("src"));
        this.registerReference(url, Reference.Type.TRACK);
    }

    private void startInput() {
        URL url = this.checkResourceURL(this.currentElement().getAttribute("src"));
        this.registerReference(url, Reference.Type.GENERIC);
    }

    private void startEmbed() {
        URL url = this.checkResourceURL(this.currentElement().getAttribute("src"));
        this.checkMimetypeMatches(url, this.currentElement().getAttribute("type"));
        this.registerReference(url, Reference.Type.GENERIC);
    }

    protected void checkDiscouragedElements() {
        XMLElement elem = this.currentElement();
        if ("http://www.w3.org/1999/xhtml".equals(elem.getNamespace())) {
            switch (elem.getName()) {
                case "base": 
                case "embed": 
                case "rp": {
                    this.report.message(MessageId.HTM_055, this.location(), elem.getName());
                }
            }
        }
    }

    protected void processInlineScripts() {
        HashSet<String> scriptEvents = OPSHandler30.getScriptEvents();
        HashSet<String> mouseEvents = OPSHandler30.getMouseEvents();
        XMLElement e = this.currentElement();
        for (int i = 0; i < e.getAttributeCount(); ++i) {
            XMLAttribute attr = e.getAttribute(i);
            String name = attr.getName().toLowerCase(Locale.ROOT);
            if (!scriptEvents.contains(name) && !mouseEvents.contains(name)) continue;
            this.processJavascript();
            return;
        }
    }

    @Override
    protected void checkScript() {
        super.checkScript();
        URL url = this.checkResourceURL(this.currentElement().getAttribute("src"));
        this.registerReference(url, Reference.Type.GENERIC);
    }

    @Override
    protected void processJavascript() {
        super.processJavascript();
        this.requiredProperties.add(PackageVocabs.ITEM_PROPERTIES.SCRIPTED);
    }

    protected void processLink() {
        String classAttribute = this.currentElement().getAttribute("class");
        if (classAttribute == null) {
            return;
        }
        Set<Property> properties = VocabUtil.parsePropertyList(classAttribute, ALTCSS_VOCABS, this.context, this.location());
        Set<AltStylesheetVocab.PROPERTIES> altClasses = Property.filter(properties, AltStylesheetVocab.PROPERTIES.class);
        if (properties.size() == 1) {
            return;
        }
        boolean vertical = altClasses.contains((Object)AltStylesheetVocab.PROPERTIES.VERTICAL);
        boolean horizontal = altClasses.contains((Object)AltStylesheetVocab.PROPERTIES.HORIZONTAL);
        boolean day = altClasses.contains((Object)AltStylesheetVocab.PROPERTIES.DAY);
        boolean night = altClasses.contains((Object)AltStylesheetVocab.PROPERTIES.NIGHT);
        if (vertical && horizontal || day && night) {
            this.report.message(MessageId.CSS_005, this.location(), classAttribute);
        }
    }

    protected void processAnchor(XMLElement e) {
        if (e.getAttribute("href") == null) {
            this.anchorNeedsText = false;
        }
        if (this.inSvg || this.context.mimeType.equals("image/svg+xml")) {
            String title = e.getAttributeNS("http://www.w3.org/1999/xlink", "title");
            String ariaLabel = e.getAttribute("aria-label");
            this.hasLabel = !Strings.isNullOrEmpty((String)title) || !Strings.isNullOrEmpty((String)ariaLabel);
        }
    }

    protected void startMediaElement() {
        assert ("audio".equals(this.currentElement().getName()) || "video".equals(this.currentElement().getName()));
        this.mediaSources = new HashMap<URL, String>();
        URL url = this.checkResourceURL(this.currentElement().getAttribute("src"));
        this.registerMediaResource(url, this.context.getMimeType(url), false);
    }

    protected void endMediaElement() {
        assert ("audio".equals(this.currentElement().getName()) || "video".equals(this.currentElement().getName()));
        boolean hasFallback = this.mediaSources.values().stream().anyMatch(mimetype -> OPFChecker30.isCoreMediaType(mimetype));
        this.mediaSources.forEach((url, mimetype) -> this.registerMediaResource((URL)url, (String)mimetype, hasFallback));
    }

    protected void startMediaSource() {
        XMLElement elem = this.currentElement();
        assert ("source".equals(elem.getName()));
        if (!"audio".equals(elem.getParent().getName()) && !"video".equals(elem.getParent().getName())) {
            return;
        }
        URL url = this.checkResourceURL(elem.getAttribute("src"));
        if (this.context.container.isPresent()) {
            String mimetype = this.checkMimetypeMatches(url, elem.getAttribute("type"));
            this.mediaSources.put(url, mimetype);
        }
    }

    protected void registerMediaResource(URL url, String mimetype, boolean hasFallback) {
        if (url == null) {
            return;
        }
        if (OPFChecker30.isAudioType(mimetype)) {
            this.context.featureReport.report(FeatureEnum.AUDIO, this.location());
            this.registerReference(url, Reference.Type.AUDIO, hasFallback);
        } else {
            this.context.featureReport.report(FeatureEnum.VIDEO, this.location());
            this.registerReference(url, Reference.Type.VIDEO);
        }
    }

    protected String checkMimetypeMatches(URL resource, String mimetype) {
        String resourceMimetype = this.context.getMimeType(resource);
        if (mimetype == null) {
            return resourceMimetype;
        }
        mimetype = MIMEType.removeParams(mimetype);
        if (resourceMimetype != null && resourceMimetype.matches("audio/ogg\\s*;\\s*codecs=opus")) {
            resourceMimetype = "audio/ogg";
        }
        if (resourceMimetype != null && !resourceMimetype.equals(mimetype)) {
            this.report.message(MessageId.OPF_013, this.location(), this.context.relativize(resource), mimetype, resourceMimetype);
        }
        return mimetype;
    }

    protected void processVideo() {
        URL posterURL = this.checkResourceURL(this.currentElement().getAttribute("poster"));
        this.registerReference(posterURL, Reference.Type.IMAGE);
    }

    @Override
    protected void processHyperlink(URL href) {
        super.processHyperlink(href);
        if ("data".equals(href.scheme())) {
            this.report.message(MessageId.RSC_029, this.location(), new Object[0]);
            return;
        }
        if (this.inRegionBasedNav) {
            this.registerReference(href, Reference.Type.REGION_BASED_NAV);
        }
    }

    protected URL checkResourceURL(String src) {
        String mimeType;
        if (src == null || src.trim().isEmpty()) {
            return null;
        }
        URL url = this.checkURL(src);
        if (this.context.isRemote(url)) {
            this.requiredProperties.add(PackageVocabs.ITEM_PROPERTIES.REMOTE_RESOURCES);
        }
        if ((mimeType = this.context.getMimeType(url)) != null && MIMEType.SVG.is(mimeType) && !MIMEType.SVG.is(this.context.mimeType)) {
            this.allowedProperties.add(PackageVocabs.ITEM_PROPERTIES.SVG);
        }
        return url;
    }

    @Override
    protected void checkObject() {
    }

    protected void endObject() {
        XMLElement elem = this.currentElement();
        URL url = this.checkResourceURL(elem.getAttribute("data"));
        this.checkMimetypeMatches(url, elem.getAttribute("type"));
        boolean hasFallback = (Boolean)elem.getPrivateData(HAS_PALPABLE_CONTENT);
        this.registerReference(url, Reference.Type.GENERIC, hasFallback);
    }

    @Override
    protected void checkIFrame() {
        super.checkIFrame();
        URL url = this.checkResourceURL(this.currentElement().getAttribute("src"));
        this.registerReference(url, Reference.Type.GENERIC);
    }

    protected void processSVG() {
        this.inSvg = true;
        if (!this.context.mimeType.equals("image/svg+xml")) {
            this.requiredProperties.add(PackageVocabs.ITEM_PROPERTIES.SVG);
        } else if (!this.isOutermostSVGAlreadyProcessed) {
            this.isOutermostSVGAlreadyProcessed = true;
            if (this.context.opfItem.isPresent() && ((OPFItem)this.context.opfItem.get()).isFixedLayout() && this.currentElement().getAttribute("viewBox") == null) {
                this.report.message(MessageId.HTM_048, this.location(), new Object[0]);
            }
        }
    }

    protected void processMeta() {
        String name;
        XMLElement e = this.currentElement();
        if ("http://www.w3.org/1999/xhtml".equals(e.getNamespace()) && "viewport".equals(Strings.nullToEmpty((String)(name = e.getAttribute("name"))).trim())) {
            String content = e.getAttribute("content");
            if (!this.hasViewport && this.context.opfItem.isPresent() && ((OPFItem)this.context.opfItem.get()).isFixedLayout()) {
                this.hasViewport = true;
                final LinkedList syntaxErrors = new LinkedList();
                ViewportMeta viewport = ViewportMeta.parse(content, new ViewportMeta.ErrorHandler(){

                    @Override
                    public void error(ViewportMeta.ParseError error, int position) {
                        syntaxErrors.add(error);
                    }
                });
                if (!syntaxErrors.isEmpty()) {
                    this.report.message(MessageId.HTM_047, this.location(), content);
                } else {
                    for (String property : Arrays.asList("width", "height")) {
                        if (!viewport.hasProperty(property)) {
                            this.report.message(MessageId.HTM_056, this.location(), property);
                            continue;
                        }
                        List<String> values = viewport.getValues(property);
                        if (values.size() > 1) {
                            this.report.message(MessageId.HTM_059, this.location(), property, values.stream().map(v -> '\"' + v + '\"').collect(Collectors.joining(", ")));
                        }
                        if (ViewportMeta.isValidProperty(property, values.get(0))) continue;
                        this.report.message(MessageId.HTM_057, this.location(), property);
                    }
                }
            } else if (this.context.opfItem.isPresent() && ((OPFItem)this.context.opfItem.get()).isFixedLayout()) {
                this.report.message(MessageId.HTM_060a, this.location(), content);
            } else {
                this.report.message(MessageId.HTM_060b, this.location(), content);
            }
        }
    }

    protected void processTable() {
        this.context.featureReport.report(FeatureEnum.TABLE, this.location());
    }

    protected void processFigure() {
        this.context.featureReport.report(FeatureEnum.FIGURE, this.location());
    }

    private void processSemantics() {
        XMLElement e = this.currentElement();
        if (e.getAttribute("itemscope") != null && !this.context.featureReport.hasFeature(FeatureEnum.HAS_MICRODATA)) {
            this.context.featureReport.report(FeatureEnum.HAS_MICRODATA, this.location());
        }
        if (e.getAttribute("property") != null && !this.context.featureReport.hasFeature(FeatureEnum.HAS_RDFA)) {
            this.context.featureReport.report(FeatureEnum.HAS_RDFA, this.location());
        }
    }

    private void processSectioning() {
        XMLElement e = this.currentElement();
        if (this.isLinear && this.context.profile == EPUBProfile.EDUPUB && "http://www.w3.org/1999/xhtml".equals(e.getNamespace())) {
            if ("body".equals(e.getName())) {
                this.inBody = true;
            } else if (this.inBody && !"section".equals(e.getName())) {
                this.context.featureReport.report(FeatureEnum.SECTIONS, this.location());
                this.inBody = false;
            } else if ("section".equals(e.getName())) {
                this.inBody = false;
                this.context.featureReport.report(FeatureEnum.SECTIONS, this.location());
            }
        }
    }

    @Override
    public void endElement() {
        super.endElement();
        XMLElement e = this.currentElement();
        String name = e.getName();
        if (this.openElements == 0L && (name.equals("html") || name.equals("svg"))) {
            this.checkOverlaysStyles();
            this.checkProperties();
        } else if (name.equals("object")) {
            this.endObject();
        } else if (name.equals("video")) {
            this.endMediaElement();
        } else if (name.equals("audio")) {
            this.endMediaElement();
        } else if (name.equals("a")) {
            if (this.anchorNeedsText) {
                this.report.message(MessageId.ACC_004, this.location().context("a"), new Object[0]);
                this.anchorNeedsText = false;
            }
            if ((this.inSvg || this.context.mimeType.equals("image/svg+xml")) && !this.hasLabel) {
                this.report.message(MessageId.ACC_011, this.location().context(e.getName()), new Object[0]);
            }
        } else if (name.equals("math")) {
            this.inMathML = false;
            if (!this.hasAltorAnnotation) {
                this.report.message(MessageId.ACC_009, this.location().context("math"), new Object[0]);
            }
        } else if (name.equals("nav") && this.inRegionBasedNav) {
            this.inRegionBasedNav = false;
        } else if (name.equals("picture")) {
            this.inPicture = false;
        } else if (name.equals("svg")) {
            this.inSvg = false;
        } else if ("http://www.w3.org/1999/xhtml".equals(e.getNamespace()) && name.equals("head")) {
            this.checkHead();
        }
        this.updatePalpableState();
    }

    protected boolean isPalpable() {
        XMLElement elem = this.currentElement();
        String name = elem.getName();
        if (elem.getAttribute("hidden") != null) {
            return false;
        }
        switch (elem.getNamespace()) {
            case "http://www.w3.org/1999/xhtml": {
                switch (name) {
                    case "audio": 
                    case "canvas": 
                    case "embed": 
                    case "iframe": 
                    case "img": 
                    case "object": 
                    case "picture": 
                    case "video": {
                        return true;
                    }
                }
                return (Boolean)elem.getPrivateData(HAS_PALPABLE_CONTENT);
            }
            case "http://www.w3.org/2000/svg": {
                return "svg".equals(name);
            }
            case "http://www.w3.org/1998/Math/MathML": {
                return "math".equals(name);
            }
        }
        return false;
    }

    private void updatePalpableState() {
        XMLElement elem = this.currentElement();
        if (elem.getParent() != null) {
            elem.getParent().getPrivateData().compute(HAS_PALPABLE_CONTENT, (k, v) -> (Boolean)v != false || this.isPalpable());
        }
    }

    protected void checkOverlaysStyles() {
        if (this.context.opfItem.isPresent() && ((OPFItem)this.context.opfItem.get()).getMediaOverlay() != null && (this.context.featureReport.hasFeature(FeatureEnum.MEDIA_OVERLAYS_ACTIVE_CLASS) || this.context.featureReport.hasFeature(FeatureEnum.MEDIA_OVERLAYS_PLAYBACK_ACTIVE_CLASS)) && !this.hasCSS) {
            this.report.message(MessageId.CSS_030, this.location(), new Object[0]);
        }
    }

    protected void checkProperties() {
        if (!this.context.container.isPresent()) {
            return;
        }
        Set<PackageVocabs.ITEM_PROPERTIES> itemProps = Property.filter(this.context.properties, PackageVocabs.ITEM_PROPERTIES.class);
        for (PackageVocabs.ITEM_PROPERTIES requiredProperty : Sets.difference(this.requiredProperties, itemProps)) {
            this.report.message(MessageId.OPF_014, EPUBLocation.of(this.context), PackageVocabs.ITEM_VOCAB.getName(requiredProperty));
        }
        Set uncheckedProperties = Sets.difference(itemProps, this.requiredProperties).copyInto(EnumSet.noneOf(PackageVocabs.ITEM_PROPERTIES.class));
        uncheckedProperties.remove((Object)PackageVocabs.ITEM_PROPERTIES.NAV);
        uncheckedProperties.remove((Object)PackageVocabs.ITEM_PROPERTIES.DATA_NAV);
        uncheckedProperties.remove((Object)PackageVocabs.ITEM_PROPERTIES.COVER_IMAGE);
        uncheckedProperties.removeAll(this.allowedProperties);
        if (uncheckedProperties.contains((Object)PackageVocabs.ITEM_PROPERTIES.REMOTE_RESOURCES)) {
            uncheckedProperties.remove((Object)PackageVocabs.ITEM_PROPERTIES.REMOTE_RESOURCES);
            if (!this.requiredProperties.contains((Object)PackageVocabs.ITEM_PROPERTIES.SCRIPTED)) {
                this.report.message(MessageId.OPF_018, this.location(), new Object[0]);
            } else {
                this.report.message(MessageId.OPF_018b, this.location(), new Object[0]);
            }
        }
        if (!uncheckedProperties.isEmpty()) {
            this.report.message(MessageId.OPF_015, EPUBLocation.of(this.context), Joiner.on((String)", ").join(PackageVocabs.ITEM_VOCAB.getNames(uncheckedProperties)));
        }
    }

    protected void checkHead() {
        if (this.context.opfItem.isPresent() && ((OPFItem)this.context.opfItem.get()).isFixedLayout() && !this.hasViewport) {
            this.report.message(MessageId.HTM_046, this.location(), new Object[0]);
        }
    }

    @Override
    protected void checkLink() {
        super.checkLink();
        XMLElement e = this.currentElement();
        String rel = e.getAttribute("rel");
        if (rel != null) {
            String title = e.getAttribute("title");
            List linkTypes = TOKENIZER.splitToList((CharSequence)rel);
            if (linkTypes.contains("alternate") && linkTypes.contains("stylesheet") && Strings.isNullOrEmpty((String)title)) {
                this.report.message(MessageId.CSS_015, this.location(), new Object[0]);
            }
        }
    }

    static {
        mouseEventsStrings = new String[]{"onclick", "ondblclick", "ondrag", "ondragend", "ondragenter", "ondragleave", "ondragover", "ondragstart", "ondrop", "onmousedown", "onmousemove", "onmouseout", "onmouseover", "onmouseup", "onmousewheel", "onscroll"};
    }
}

