/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.ldap;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.naming.directory.DirContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceAware;
import org.springframework.context.support.MessageSourceAccessor;
import org.springframework.ldap.AuthenticationException;
import org.springframework.ldap.NamingException;
import org.springframework.ldap.OperationNotSupportedException;
import org.springframework.ldap.core.support.LdapContextSource;
import org.springframework.security.BadCredentialsException;
import org.springframework.security.SpringSecurityMessageSource;
import org.springframework.security.ldap.LdapUtils;
import org.springframework.security.ldap.SpringSecurityContextSource;
import org.springframework.util.Assert;

public class DefaultSpringSecurityContextSource
extends LdapContextSource
implements SpringSecurityContextSource,
MessageSourceAware {
    private static final Log logger = LogFactory.getLog((Class)(class$org$springframework$security$ldap$DefaultSpringSecurityContextSource == null ? (class$org$springframework$security$ldap$DefaultSpringSecurityContextSource = DefaultSpringSecurityContextSource.class$("org.springframework.security.ldap.DefaultSpringSecurityContextSource")) : class$org$springframework$security$ldap$DefaultSpringSecurityContextSource));
    private String rootDn;
    protected MessageSourceAccessor messages = SpringSecurityMessageSource.getAccessor();
    static /* synthetic */ Class class$org$springframework$security$ldap$DefaultSpringSecurityContextSource;

    public DefaultSpringSecurityContextSource(String providerUrl) {
        Assert.hasLength((String)providerUrl, (String)"An LDAP connection URL must be supplied.");
        StringTokenizer st = new StringTokenizer(providerUrl);
        ArrayList<String> urls = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            String url = st.nextToken();
            String urlRootDn = LdapUtils.parseRootDnFromUrl(url);
            urls.add(url.substring(0, url.lastIndexOf(urlRootDn)));
            logger.info((Object)(" URL '" + url + "', root DN is '" + urlRootDn + "'"));
            if (this.rootDn == null) {
                this.rootDn = urlRootDn;
                continue;
            }
            if (this.rootDn.equals(urlRootDn)) continue;
            throw new IllegalArgumentException("Root DNs must be the same when using multiple URLs");
        }
        super.setUrls(urls.toArray(new String[urls.size()]));
        super.setBase(this.rootDn);
    }

    public DirContext getReadWriteContext(String userDn, Object credentials) {
        Hashtable<String, Object> env = new Hashtable<String, Object>(this.getAnonymousEnv());
        env.put("java.naming.security.principal", userDn);
        env.put("java.naming.security.credentials", credentials);
        env.remove("com.sun.jndi.ldap.connect.pool");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Creating context with principal: '" + userDn + "'"));
        }
        try {
            return this.createContext(env);
        }
        catch (NamingException e) {
            if (e instanceof AuthenticationException || e instanceof OperationNotSupportedException) {
                throw new BadCredentialsException(this.messages.getMessage("DefaultSpringSecurityContextSource.badCredentials", "Bad credentials"), e);
            }
            throw e;
        }
    }

    public void setMessageSource(MessageSource messageSource) {
        this.messages = new MessageSourceAccessor(messageSource);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

