/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui.action;

import ca.sqlpower.architect.swingui.ArchitectFrame;
import ca.sqlpower.architect.swingui.PlayPen;
import ca.sqlpower.architect.swingui.action.AbstractArchitectAction;
import ca.sqlpower.architect.swingui.action.Messages;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;

public class PasteSelectedAction
extends AbstractArchitectAction {
    private static final Logger logger = Logger.getLogger(PasteSelectedAction.class);

    public PasteSelectedAction(ArchitectFrame frame) {
        super(frame, Messages.getString("PasteSelectedAction.name"), Messages.getString("PasteSelectedAction.description"));
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(86, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Component focusOwner;
        PlayPen playPen = this.getSession().getPlayPen();
        if (playPen.isAncestorOf(focusOwner = this.getSession().getArchitectFrame().getFocusOwner()) || playPen == focusOwner) {
            Transferable clipboardContents = this.getSession().getContext().getClipboardContents();
            logger.debug((Object)("Pasting " + clipboardContents + " into the playpen."));
            if (clipboardContents != null) {
                playPen.pasteData(clipboardContents);
            } else {
                JOptionPane.showMessageDialog(this.getSession().getArchitectFrame(), "There is no contents in the clipboard to paste.", "Clipboard empty", 1);
            }
        }
    }
}

