'''OpenGL extension NV.image_formats

This module customises the behaviour of the 
OpenGL.raw.GLES2.NV.image_formats to provide a more 
Python-friendly API

Overview (from the spec)
	
	OpenGL ES 3.1 specifies a variety of formats required to be usable
	with texture images. This extension introduces the texture image
	formats missing for parity with OpenGL 4.4.
	

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/NV/image_formats.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
import ctypes
from OpenGL.raw.GLES2 import _types, _glgets
from OpenGL.raw.GLES2.NV.image_formats import *
from OpenGL.raw.GLES2.NV.image_formats import _EXTENSION_NAME

def glInitImageFormatsNV():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )


### END AUTOGENERATED SECTION