"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _constants = require("../utils/constants");

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; } /*
                                                                                                                                                                                                                   * Copyright OpenSearch Contributors
                                                                                                                                                                                                                   * SPDX-License-Identifier: Apache-2.0
                                                                                                                                                                                                                   */

class NotificationsService {
  constructor(osDriver) {
    _defineProperty(this, "osDriver", void 0);

    _defineProperty(this, "getChannel", async (context, request, response) => {
      try {
        const {
          id
        } = request.params;
        const {
          callAsCurrentUser: callWithRequest
        } = this.osDriver.asScoped(request);
        const getResponse = await callWithRequest(_constants.CLIENT_NOTIFICATIONS_METHODS.GET_CHANNEL, {
          id
        });
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: getResponse
          }
        });
      } catch (err) {
        console.error('Security Analytics - NotificationsService - getChannel:', err);
        return response.custom({
          statusCode: 200,
          body: {
            ok: false,
            error: err.message
          }
        });
      }
    });

    _defineProperty(this, "getChannels", async (context, request, response) => {
      try {
        const {
          callAsCurrentUser: callWithRequest
        } = this.osDriver.asScoped(request);
        const getChannelsResponse = await callWithRequest(_constants.CLIENT_NOTIFICATIONS_METHODS.GET_CHANNELS);
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: getChannelsResponse
          }
        });
      } catch (err) {
        console.error('Security Analytics - NotificationsService - getChannels:', err);
        return response.custom({
          statusCode: 200,
          body: {
            ok: false,
            error: err.message
          }
        });
      }
    });

    this.osDriver = osDriver;
  }
  /**
   * Calls backend GET channels API from the Notifications plugin
   * to retrieve the channel config with the specific ID.
   */

  /**
   * Calls backend GET channels API from the Notifications plugin.
   */


}

exports.default = NotificationsService;
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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