/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.model;

import java.time.Instant;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.support.WriteRequest;
import org.opensearch.client.Client;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.util.CollectionUtils;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.index.IndexNotFoundException;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.TermQueryBuilder;
import org.opensearch.ml.common.AccessMode;
import org.opensearch.ml.common.MLModelGroup;
import org.opensearch.ml.common.transport.model_group.MLRegisterModelGroupInput;
import org.opensearch.ml.helper.ModelAccessControlHelper;
import org.opensearch.ml.indices.MLIndicesHandler;
import org.opensearch.ml.utils.RestActionUtils;
import org.opensearch.search.SearchHit;
import org.opensearch.search.builder.SearchSourceBuilder;

public class MLModelGroupManager {
    @Generated
    private static final Logger log = LogManager.getLogger(MLModelGroupManager.class);
    private final MLIndicesHandler mlIndicesHandler;
    private final Client client;
    ClusterService clusterService;
    ModelAccessControlHelper modelAccessControlHelper;

    @Inject
    public MLModelGroupManager(MLIndicesHandler mlIndicesHandler, Client client, ClusterService clusterService, ModelAccessControlHelper modelAccessControlHelper) {
        this.mlIndicesHandler = mlIndicesHandler;
        this.client = client;
        this.clusterService = clusterService;
        this.modelAccessControlHelper = modelAccessControlHelper;
    }

    public void createModelGroup(MLRegisterModelGroupInput input, ActionListener<String> listener) {
        try {
            String modelName = input.getName();
            User user = RestActionUtils.getUserContext(this.client);
            try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
                ActionListener wrappedListener = ActionListener.runBefore(listener, () -> context.restore());
                this.validateUniqueModelGroupName(input.getName(), (ActionListener<SearchResponse>)ActionListener.wrap(modelGroups -> {
                    if (modelGroups != null && modelGroups.getHits().getTotalHits() != null && modelGroups.getHits().getTotalHits().value != 0L) {
                        Iterator iterator = modelGroups.getHits().iterator();
                        while (iterator.hasNext()) {
                            String id = ((SearchHit)iterator.next()).getId();
                            wrappedListener.onFailure((Exception)new IllegalArgumentException("The name you provided is already being used by a model group with ID: " + id + "."));
                        }
                    } else {
                        MLModelGroup mlModelGroup;
                        MLModelGroup.MLModelGroupBuilder builder = MLModelGroup.builder();
                        if (this.modelAccessControlHelper.isSecurityEnabledAndModelAccessControlEnabled(user)) {
                            this.validateRequestForAccessControl(input, user);
                            builder = builder.access(input.getModelAccessMode().getValue());
                            if (Boolean.TRUE.equals(input.getIsAddAllBackendRoles())) {
                                input.setBackendRoles(user.getBackendRoles());
                            }
                            mlModelGroup = builder.name(modelName).description(input.getDescription()).backendRoles(input.getBackendRoles()).owner(user).createdTime(Instant.now()).lastUpdatedTime(Instant.now()).build();
                        } else {
                            this.validateSecurityDisabledOrModelAccessControlDisabled(input);
                            mlModelGroup = builder.name(modelName).description(input.getDescription()).access(AccessMode.PUBLIC.getValue()).createdTime(Instant.now()).lastUpdatedTime(Instant.now()).build();
                        }
                        this.mlIndicesHandler.initModelGroupIndexIfAbsent((ActionListener<Boolean>)ActionListener.wrap(res -> {
                            IndexRequest indexRequest = new IndexRequest(".plugins-ml-model-group");
                            indexRequest.source(mlModelGroup.toXContent(XContentBuilder.builder((XContent)XContentType.JSON.xContent()), ToXContent.EMPTY_PARAMS));
                            indexRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
                            this.client.index(indexRequest, ActionListener.wrap(r -> {
                                log.debug("Indexed model group doc successfully {}", (Object)modelName);
                                wrappedListener.onResponse((Object)r.getId());
                            }, e -> {
                                log.error("Failed to index model group doc", (Throwable)e);
                                wrappedListener.onFailure(e);
                            }));
                        }, ex -> {
                            log.error("Failed to init model group index", (Throwable)ex);
                            wrappedListener.onFailure(ex);
                        }));
                    }
                }, e -> {
                    log.error("Failed to search model group index", (Throwable)e);
                    wrappedListener.onFailure(e);
                }));
            }
            catch (Exception e2) {
                log.error("Failed to create model group doc", (Throwable)e2);
                listener.onFailure(e2);
            }
        }
        catch (Exception e3) {
            log.error("Failed to init model group index", (Throwable)e3);
            listener.onFailure(e3);
        }
    }

    private void validateRequestForAccessControl(MLRegisterModelGroupInput input, User user) {
        AccessMode modelAccessMode = input.getModelAccessMode();
        Boolean isAddAllBackendRoles = input.getIsAddAllBackendRoles();
        if (modelAccessMode == null) {
            if (!CollectionUtils.isEmpty((Collection)input.getBackendRoles()) && Boolean.TRUE.equals(isAddAllBackendRoles)) {
                throw new IllegalArgumentException("You cannot specify backend roles and add all backend roles at the same time.");
            }
            if (Boolean.TRUE.equals(isAddAllBackendRoles) || !CollectionUtils.isEmpty((Collection)input.getBackendRoles())) {
                input.setModelAccessMode(AccessMode.RESTRICTED);
                modelAccessMode = AccessMode.RESTRICTED;
            } else {
                input.setModelAccessMode(AccessMode.PRIVATE);
            }
        }
        if (!(AccessMode.PUBLIC != modelAccessMode && AccessMode.PRIVATE != modelAccessMode || CollectionUtils.isEmpty((Collection)input.getBackendRoles()) && !Boolean.TRUE.equals(isAddAllBackendRoles))) {
            throw new IllegalArgumentException("You can specify backend roles only for a model group with the restricted access mode.");
        }
        if (AccessMode.RESTRICTED == modelAccessMode) {
            if (this.modelAccessControlHelper.isAdmin(user) && Boolean.TRUE.equals(isAddAllBackendRoles)) {
                throw new IllegalArgumentException("Admin users cannot add all backend roles to a model group.");
            }
            if (!this.modelAccessControlHelper.isAdmin(user) && CollectionUtils.isEmpty((Collection)user.getBackendRoles())) {
                throw new IllegalArgumentException("You must have at least one backend role to register a restricted model group.");
            }
            if (CollectionUtils.isEmpty((Collection)input.getBackendRoles()) && !Boolean.TRUE.equals(isAddAllBackendRoles)) {
                throw new IllegalArgumentException("You must specify one or more backend roles or add all backend roles to register a restricted model group.");
            }
            if (!CollectionUtils.isEmpty((Collection)input.getBackendRoles()) && Boolean.TRUE.equals(isAddAllBackendRoles)) {
                throw new IllegalArgumentException("You cannot specify backend roles and add all backend roles at the same time.");
            }
            if (!(this.modelAccessControlHelper.isAdmin(user) || Boolean.TRUE.equals(isAddAllBackendRoles) || new HashSet(user.getBackendRoles()).containsAll(input.getBackendRoles()))) {
                throw new IllegalArgumentException("You don't have the backend roles specified.");
            }
        }
    }

    public void validateUniqueModelGroupName(String name, ActionListener<SearchResponse> listener) throws IllegalArgumentException {
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
            BoolQueryBuilder query = new BoolQueryBuilder();
            query.filter((QueryBuilder)new TermQueryBuilder("name.keyword", name));
            SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().query((QueryBuilder)query);
            SearchRequest searchRequest = new SearchRequest(new String[]{".plugins-ml-model-group"}).source(searchSourceBuilder);
            this.client.search(searchRequest, ActionListener.runBefore((ActionListener)ActionListener.wrap(modelGroups -> listener.onResponse(modelGroups), e -> {
                if (e instanceof IndexNotFoundException) {
                    listener.onResponse(null);
                } else {
                    log.error("Failed to search model group index", (Throwable)e);
                    listener.onFailure(e);
                }
            }), () -> context.restore()));
        }
        catch (Exception e2) {
            log.error("Failed to search model group index", (Throwable)e2);
            listener.onFailure(e2);
        }
    }

    private void validateSecurityDisabledOrModelAccessControlDisabled(MLRegisterModelGroupInput input) {
        if (input.getModelAccessMode() != null || input.getIsAddAllBackendRoles() != null || !CollectionUtils.isEmpty((Collection)input.getBackendRoles())) {
            throw new IllegalArgumentException("You cannot specify model access control parameters because the Security plugin or model access control is disabled on your cluster.");
        }
    }
}

