/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.action.connector;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.client.Client;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.action.ActionListener;
import org.opensearch.ml.helper.ConnectorAccessControlHelper;
import org.opensearch.ml.utils.RestActionUtils;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.search.fetch.subphase.FetchSourceContext;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;

public class SearchConnectorTransportAction
extends HandledTransportAction<SearchRequest, SearchResponse> {
    @Generated
    private static final Logger log = LogManager.getLogger(SearchConnectorTransportAction.class);
    private final Client client;
    private final ConnectorAccessControlHelper connectorAccessControlHelper;

    @Inject
    public SearchConnectorTransportAction(TransportService transportService, ActionFilters actionFilters, Client client, ConnectorAccessControlHelper connectorAccessControlHelper) {
        super("cluster:admin/opensearch/ml/connectors/search", transportService, actionFilters, SearchRequest::new);
        this.client = client;
        this.connectorAccessControlHelper = connectorAccessControlHelper;
    }

    protected void doExecute(Task task, SearchRequest request, ActionListener<SearchResponse> actionListener) {
        request.indices(new String[]{".plugins-ml-connector"});
        this.search(request, actionListener);
    }

    private void search(SearchRequest request, ActionListener<SearchResponse> actionListener) {
        User user = RestActionUtils.getUserContext(this.client);
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
            ActionListener wrappedListener = ActionListener.runBefore(actionListener, () -> context.restore());
            List excludes = Optional.ofNullable(request.source()).map(SearchSourceBuilder::fetchSource).map(FetchSourceContext::excludes).map(x -> Arrays.stream(x).collect(Collectors.toList())).orElse(new ArrayList());
            excludes.add("credential");
            FetchSourceContext rebuiltFetchSourceContext = new FetchSourceContext(Optional.ofNullable(request.source()).map(SearchSourceBuilder::fetchSource).map(FetchSourceContext::fetchSource).orElse(true).booleanValue(), (String[])Optional.ofNullable(request.source()).map(SearchSourceBuilder::fetchSource).map(FetchSourceContext::includes).orElse(null), excludes.toArray(new String[0]));
            request.source().fetchSource(rebuiltFetchSourceContext);
            if (this.connectorAccessControlHelper.skipConnectorAccessControl(user)) {
                this.client.search(request, wrappedListener);
            } else {
                SearchSourceBuilder sourceBuilder = this.connectorAccessControlHelper.addUserBackendRolesFilter(user, request.source());
                request.source(sourceBuilder);
                this.client.search(request, wrappedListener);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            actionListener.onFailure(e);
        }
    }
}

