/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.rca.store.rca.temperature;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.performanceanalyzer.grpc.FlowUnitMessage;
import org.opensearch.performanceanalyzer.rca.framework.api.Rca;
import org.opensearch.performanceanalyzer.rca.framework.api.Resources;
import org.opensearch.performanceanalyzer.rca.framework.api.contexts.ResourceContext;
import org.opensearch.performanceanalyzer.rca.framework.api.flow_units.temperature.CompactNodeTemperatureFlowUnit;
import org.opensearch.performanceanalyzer.rca.framework.api.flow_units.temperature.DimensionalTemperatureFlowUnit;
import org.opensearch.performanceanalyzer.rca.framework.api.summaries.temperature.CompactNodeSummary;
import org.opensearch.performanceanalyzer.rca.framework.api.summaries.temperature.FullNodeTemperatureSummary;
import org.opensearch.performanceanalyzer.rca.framework.api.summaries.temperature.NodeLevelDimensionalSummary;
import org.opensearch.performanceanalyzer.rca.framework.util.InstanceDetails;
import org.opensearch.performanceanalyzer.rca.scheduler.FlowUnitOperationArgWrapper;
import org.opensearch.performanceanalyzer.rca.store.rca.temperature.dimension.CpuUtilDimensionTemperatureRca;
import org.opensearch.performanceanalyzer.rca.store.rca.temperature.dimension.HeapAllocRateTemperatureRca;
import org.opensearch.performanceanalyzer.rca.store.rca.temperature.dimension.ShardSizeDimensionTemperatureRca;

public class NodeTemperatureRca
extends Rca<CompactNodeTemperatureFlowUnit> {
    public static final String TABLE_NAME = NodeTemperatureRca.class.getSimpleName();
    private static final Logger LOG = LogManager.getLogger(NodeTemperatureRca.class);
    private final CpuUtilDimensionTemperatureRca cpuUtilDimensionTemperatureRca;
    private final HeapAllocRateTemperatureRca heapAllocRateTemperatureRca;
    private final ShardSizeDimensionTemperatureRca shardSizeDimensionTemperatureRca;

    public NodeTemperatureRca(CpuUtilDimensionTemperatureRca cpuUtilDimensionTemperatureRca, HeapAllocRateTemperatureRca heapAllocRateTemperatureRca, ShardSizeDimensionTemperatureRca shardSizeDimensionTemperatureRca) {
        super(5L);
        this.cpuUtilDimensionTemperatureRca = cpuUtilDimensionTemperatureRca;
        this.heapAllocRateTemperatureRca = heapAllocRateTemperatureRca;
        this.shardSizeDimensionTemperatureRca = shardSizeDimensionTemperatureRca;
    }

    @Override
    public void generateFlowUnitListFromWire(FlowUnitOperationArgWrapper args) {
        List<FlowUnitMessage> flowUnitMessages = args.getWireHopper().readFromWire(args.getNode());
        ArrayList<CompactNodeTemperatureFlowUnit> flowUnitList = new ArrayList<CompactNodeTemperatureFlowUnit>();
        LOG.debug("rca: Executing fromWire: {}", (Object)this.getClass().getSimpleName());
        for (FlowUnitMessage flowUnitMessage : flowUnitMessages) {
            flowUnitList.add(CompactNodeTemperatureFlowUnit.buildFlowUnitFromWrapper(flowUnitMessage));
        }
        this.setFlowUnits(flowUnitList);
    }

    @Override
    public CompactNodeTemperatureFlowUnit operate() {
        ArrayList flowUnitsAcrossDimensions = new ArrayList();
        flowUnitsAcrossDimensions.add(this.cpuUtilDimensionTemperatureRca.getFlowUnits());
        flowUnitsAcrossDimensions.add(this.heapAllocRateTemperatureRca.getFlowUnits());
        flowUnitsAcrossDimensions.add(this.shardSizeDimensionTemperatureRca.getFlowUnits());
        for (List list : flowUnitsAcrossDimensions) {
            if (list.size() >= 1) continue;
            list.add(new DimensionalTemperatureFlowUnit(System.currentTimeMillis()));
        }
        AtomicBoolean emptyFlowUnit = new AtomicBoolean(false);
        flowUnitsAcrossDimensions.forEach(flowUnitAcrossOneDimension -> {
            if (((DimensionalTemperatureFlowUnit)flowUnitAcrossOneDimension.get(0)).isEmpty()) {
                LOG.debug("Empty flowUnitAcrossOneDimension");
                emptyFlowUnit.set(true);
            } else {
                emptyFlowUnit.set(false);
            }
        });
        if (emptyFlowUnit.get()) {
            return new CompactNodeTemperatureFlowUnit(System.currentTimeMillis());
        }
        ArrayList<NodeLevelDimensionalSummary> arrayList = new ArrayList<NodeLevelDimensionalSummary>();
        flowUnitsAcrossDimensions.forEach(flowUnitAcrossOneDimension -> {
            if (!((DimensionalTemperatureFlowUnit)flowUnitAcrossOneDimension.get(0)).isEmpty()) {
                nodeDimensionProfiles.add(((DimensionalTemperatureFlowUnit)flowUnitAcrossOneDimension.get(0)).getNodeDimensionProfile());
            }
        });
        FullNodeTemperatureSummary nodeProfile = this.buildNodeProfile(arrayList);
        CompactNodeSummary summary = new CompactNodeSummary(nodeProfile.getNodeId(), nodeProfile.getHostAddress());
        summary.fillFromNodeProfile(nodeProfile);
        return new CompactNodeTemperatureFlowUnit(System.currentTimeMillis(), new ResourceContext(Resources.State.UNKNOWN), summary, true);
    }

    private FullNodeTemperatureSummary buildNodeProfile(List<NodeLevelDimensionalSummary> dimensionProfiles) {
        InstanceDetails instanceDetails = this.getInstanceDetails();
        FullNodeTemperatureSummary nodeProfile = new FullNodeTemperatureSummary(instanceDetails.getInstanceId().toString(), instanceDetails.getInstanceIp().toString());
        for (NodeLevelDimensionalSummary profile : dimensionProfiles) {
            nodeProfile.updateNodeDimensionProfile(profile);
        }
        return nodeProfile;
    }
}

