/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.fetch.subphase.highlight;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.search.highlight.Encoder;
import org.apache.lucene.search.highlight.Formatter;
import org.apache.lucene.search.highlight.Fragmenter;
import org.apache.lucene.search.highlight.InvalidTokenOffsetsException;
import org.apache.lucene.search.highlight.NullFragmenter;
import org.apache.lucene.search.highlight.QueryScorer;
import org.apache.lucene.search.highlight.Scorer;
import org.apache.lucene.search.highlight.SimpleFragmenter;
import org.apache.lucene.search.highlight.SimpleHTMLFormatter;
import org.apache.lucene.search.highlight.SimpleSpanFragmenter;
import org.apache.lucene.search.highlight.TextFragment;
import org.apache.lucene.util.BytesRefHash;
import org.apache.lucene.util.CollectionUtil;
import org.opensearch.core.common.text.Text;
import org.opensearch.index.IndexSettings;
import org.opensearch.index.mapper.MappedFieldType;
import org.opensearch.search.fetch.FetchContext;
import org.opensearch.search.fetch.FetchSubPhase;
import org.opensearch.search.fetch.subphase.highlight.CustomQueryScorer;
import org.opensearch.search.fetch.subphase.highlight.FieldHighlightContext;
import org.opensearch.search.fetch.subphase.highlight.HighlightField;
import org.opensearch.search.fetch.subphase.highlight.HighlightUtils;
import org.opensearch.search.fetch.subphase.highlight.Highlighter;
import org.opensearch.search.fetch.subphase.highlight.SearchHighlightContext;
import org.opensearch.search.fetch.subphase.highlight.UnifiedHighlighter;

public class PlainHighlighter
implements Highlighter {
    private static final String CACHE_KEY = "highlight-plain";

    @Override
    public HighlightField highlight(FieldHighlightContext fieldContext) throws IOException {
        int i;
        String[] fragments;
        Map cache;
        org.apache.lucene.search.highlight.Highlighter entry;
        Encoder encoder;
        SearchHighlightContext.Field field = fieldContext.field;
        FetchContext context = fieldContext.context;
        FetchSubPhase.HitContext hitContext = fieldContext.hitContext;
        MappedFieldType fieldType = fieldContext.fieldType;
        Encoder encoder2 = encoder = field.fieldOptions().encoder().equals("html") ? HighlightUtils.Encoders.HTML : HighlightUtils.Encoders.DEFAULT;
        if (!fieldContext.cache.containsKey(CACHE_KEY)) {
            fieldContext.cache.put(CACHE_KEY, new HashMap());
        }
        if ((entry = (org.apache.lucene.search.highlight.Highlighter)(cache = (Map)fieldContext.cache.get(CACHE_KEY)).get(fieldType)) == null) {
            NullFragmenter fragmenter;
            CustomQueryScorer queryScorer = new CustomQueryScorer(fieldContext.query, field.fieldOptions().requireFieldMatch() != false ? fieldType.name() : null);
            queryScorer.setExpandMultiTermQuery(true);
            if (field.fieldOptions().numberOfFragments() == 0) {
                fragmenter = new NullFragmenter();
            } else if (field.fieldOptions().fragmenter() == null) {
                fragmenter = new SimpleSpanFragmenter((QueryScorer)queryScorer, field.fieldOptions().fragmentCharSize());
            } else if ("simple".equals(field.fieldOptions().fragmenter())) {
                fragmenter = new SimpleFragmenter(field.fieldOptions().fragmentCharSize());
            } else if ("span".equals(field.fieldOptions().fragmenter())) {
                fragmenter = new SimpleSpanFragmenter((QueryScorer)queryScorer, field.fieldOptions().fragmentCharSize());
            } else {
                throw new IllegalArgumentException("unknown fragmenter option [" + field.fieldOptions().fragmenter() + "] for the field [" + fieldContext.fieldName + "]");
            }
            SimpleHTMLFormatter formatter = new SimpleHTMLFormatter(field.fieldOptions().preTags()[0], field.fieldOptions().postTags()[0]);
            entry = new org.apache.lucene.search.highlight.Highlighter((Formatter)formatter, encoder, (Scorer)queryScorer);
            entry.setTextFragmenter((Fragmenter)fragmenter);
            entry.setMaxDocCharsToAnalyze(Integer.MAX_VALUE);
            cache.put(fieldType, entry);
        }
        int numberOfFragments = field.fieldOptions().numberOfFragments() == 0 ? 1 : field.fieldOptions().numberOfFragments();
        ArrayList<TextFragment> fragsList = new ArrayList<TextFragment>();
        Analyzer analyzer = context.mapperService().documentMapper().mappers().indexAnalyzer();
        int maxAnalyzedOffset = context.getIndexSettings().getHighlightMaxAnalyzedOffset();
        List<Object> textsToHighlight = HighlightUtils.loadFieldValues(fieldType, context.getQueryShardContext(), hitContext, fieldContext.forceSource);
        for (Object textToHighlight : textsToHighlight) {
            String text = UnifiedHighlighter.convertFieldValue(fieldType, textToHighlight);
            int textLength = text.length();
            if (textLength > maxAnalyzedOffset) {
                throw new IllegalArgumentException("The length of [" + fieldContext.fieldName + "] field of [" + hitContext.hit().getId() + "] doc of [" + context.getIndexName() + "] index has exceeded [" + maxAnalyzedOffset + "] - maximum allowed to be analyzed for highlighting. This maximum can be set by changing the [" + IndexSettings.MAX_ANALYZED_OFFSET_SETTING.getKey() + "] index level setting. For large texts, indexing with offsets or term vectors, and highlighting with unified or fvh highlighter is recommended!");
            }
            try {
                TokenStream tokenStream = analyzer.tokenStream(fieldType.name(), text);
                try {
                    TextFragment[] bestTextFragments;
                    if (!tokenStream.hasAttribute(CharTermAttribute.class) || !tokenStream.hasAttribute(OffsetAttribute.class)) continue;
                    for (TextFragment bestTextFragment : bestTextFragments = entry.getBestTextFragments(tokenStream, text, false, numberOfFragments)) {
                        if (bestTextFragment == null || !(bestTextFragment.getScore() > 0.0f)) continue;
                        fragsList.add(bestTextFragment);
                    }
                }
                finally {
                    if (tokenStream == null) continue;
                    tokenStream.close();
                }
            }
            catch (BytesRefHash.MaxBytesLengthExceededException tokenStream) {
            }
            catch (InvalidTokenOffsetsException e) {
                throw new IllegalArgumentException(e);
            }
        }
        if (field.fieldOptions().scoreOrdered().booleanValue()) {
            CollectionUtil.introSort(fragsList, (o1, o2) -> Math.round(o2.getScore() - o1.getScore()));
        }
        if (field.fieldOptions().numberOfFragments() == 0 && textsToHighlight.size() > 1 && fragsList.size() > 0) {
            fragments = new String[fragsList.size()];
            for (i = 0; i < fragsList.size(); ++i) {
                fragments[i] = ((TextFragment)fragsList.get(i)).toString();
            }
        } else {
            numberOfFragments = Math.min(fragsList.size(), numberOfFragments);
            fragments = new String[numberOfFragments];
            for (i = 0; i < fragments.length; ++i) {
                fragments[i] = ((TextFragment)fragsList.get(i)).toString();
            }
        }
        if (fragments.length > 0) {
            return new HighlightField(fieldContext.fieldName, Text.convertFromStringArray((String[])fragments));
        }
        int noMatchSize = fieldContext.field.fieldOptions().noMatchSize();
        if (noMatchSize > 0 && textsToHighlight.size() > 0) {
            String fieldContents = textsToHighlight.get(0).toString();
            int end = PlainHighlighter.findGoodEndForNoHighlightExcerpt(noMatchSize, analyzer, fieldType.name(), fieldContents);
            if (end > 0) {
                return new HighlightField(fieldContext.fieldName, new Text[]{new Text(fieldContents.substring(0, end))});
            }
        }
        return null;
    }

    @Override
    public boolean canHighlight(MappedFieldType fieldType) {
        return true;
    }

    private static int findGoodEndForNoHighlightExcerpt(int noMatchSize, Analyzer analyzer, String fieldName, String contents) throws IOException {
        try (TokenStream tokenStream = analyzer.tokenStream(fieldName, contents);){
            if (!tokenStream.hasAttribute(OffsetAttribute.class)) {
                int n = -1;
                return n;
            }
            int end = -1;
            tokenStream.reset();
            while (tokenStream.incrementToken()) {
                OffsetAttribute attr = (OffsetAttribute)tokenStream.getAttribute(OffsetAttribute.class);
                if (attr.endOffset() >= noMatchSize) {
                    if (attr.endOffset() == noMatchSize) {
                        end = noMatchSize;
                    }
                    int n = end;
                    return n;
                }
                end = attr.endOffset();
            }
            tokenStream.end();
            int n = end;
            return n;
        }
    }
}

