/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.memory.index;

import java.io.IOException;
import java.time.Instant;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchSecurityException;
import org.opensearch.OpenSearchWrapperException;
import org.opensearch.ResourceAlreadyExistsException;
import org.opensearch.ResourceNotFoundException;
import org.opensearch.action.DocWriteResponse;
import org.opensearch.action.admin.indices.create.CreateIndexRequest;
import org.opensearch.action.admin.indices.create.CreateIndexResponse;
import org.opensearch.action.delete.DeleteRequest;
import org.opensearch.action.get.GetRequest;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.client.Client;
import org.opensearch.client.Requests;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.index.query.MatchAllQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.TermQueryBuilder;
import org.opensearch.ml.common.conversation.ConversationMeta;
import org.opensearch.ml.common.conversation.ConversationalIndexConstants;
import org.opensearch.search.SearchHit;
import org.opensearch.search.sort.SortOrder;

public class ConversationMetaIndex {
    @Generated
    private static final Logger log = LogManager.getLogger(ConversationMetaIndex.class);
    private Client client;
    private ClusterService clusterService;
    private static final String indexName = ".plugins-ml-conversation-meta";

    public void initConversationMetaIndexIfAbsent(ActionListener<Boolean> listener) {
        block11: {
            if (!this.clusterService.state().metadata().hasIndex(indexName)) {
                log.debug("No conversational meta index found. Adding it");
                CreateIndexRequest request = Requests.createIndexRequest((String)indexName).mapping(ConversationalIndexConstants.META_MAPPING);
                try (ThreadContext.StoredContext threadContext = this.client.threadPool().getThreadContext().stashContext();){
                    ActionListener internalListener = ActionListener.runBefore(listener, () -> threadContext.restore());
                    ActionListener al = ActionListener.wrap(createIndexResponse -> {
                        if (createIndexResponse.equals((Object)new CreateIndexResponse(true, true, indexName))) {
                            log.info("created index [.plugins-ml-conversation-meta]");
                            internalListener.onResponse((Object)true);
                        } else {
                            internalListener.onResponse((Object)false);
                        }
                    }, e -> {
                        if (e instanceof ResourceAlreadyExistsException || e instanceof OpenSearchWrapperException && e.getCause() instanceof ResourceAlreadyExistsException) {
                            internalListener.onResponse((Object)true);
                        } else {
                            log.error("failed to create index [.plugins-ml-conversation-meta]", (Throwable)e);
                            internalListener.onFailure(e);
                        }
                    });
                    this.client.admin().indices().create(request, al);
                }
                catch (Exception e2) {
                    if (e2 instanceof ResourceAlreadyExistsException || e2 instanceof OpenSearchWrapperException && e2.getCause() instanceof ResourceAlreadyExistsException) {
                        listener.onResponse((Object)true);
                        break block11;
                    }
                    log.error("failed to create index [.plugins-ml-conversation-meta]", (Throwable)e2);
                    listener.onFailure(e2);
                }
            } else {
                listener.onResponse((Object)true);
            }
        }
    }

    public void createConversation(String name, ActionListener<String> listener) {
        this.initConversationMetaIndexIfAbsent((ActionListener<Boolean>)ActionListener.wrap(indexExists -> {
            if (indexExists.booleanValue()) {
                String userstr = (String)this.client.threadPool().getThreadContext().getTransient("_opendistro_security_user_info");
                IndexRequest request = Requests.indexRequest((String)indexName).source(new Object[]{"create_time", Instant.now(), "name", name, "user", userstr == null ? null : User.parse((String)userstr).getName()});
                try (ThreadContext.StoredContext threadContext = this.client.threadPool().getThreadContext().stashContext();){
                    ActionListener internalListener = ActionListener.runBefore((ActionListener)listener, () -> threadContext.restore());
                    ActionListener al = ActionListener.wrap(resp -> {
                        if (resp.status() == RestStatus.CREATED) {
                            internalListener.onResponse((Object)resp.getId());
                        } else {
                            internalListener.onFailure((Exception)new IOException("failed to create conversation"));
                        }
                    }, e -> {
                        log.error("Failed to create conversation", (Throwable)e);
                        internalListener.onFailure(e);
                    });
                    this.client.index(request, al);
                }
                catch (Exception e2) {
                    log.error("Failed to create conversation", (Throwable)e2);
                    listener.onFailure(e2);
                }
            } else {
                listener.onFailure((Exception)new IOException("Failed to add conversation due to missing index"));
            }
        }, e -> listener.onFailure(e)));
    }

    public void createConversation(ActionListener<String> listener) {
        this.createConversation("", listener);
    }

    public void getConversations(int from, int maxResults, ActionListener<List<ConversationMeta>> listener) {
        if (!this.clusterService.state().metadata().hasIndex(indexName)) {
            listener.onResponse(List.of());
        }
        SearchRequest request = Requests.searchRequest((String[])new String[]{indexName});
        String userstr = (String)this.client.threadPool().getThreadContext().getTransient("_opendistro_security_user_info");
        Object queryBuilder = userstr == null ? new MatchAllQueryBuilder() : new TermQueryBuilder("user", User.parse((String)userstr).getName());
        request.source().query((QueryBuilder)queryBuilder);
        request.source().from(from).size(maxResults);
        request.source().sort("create_time", SortOrder.DESC);
        try (ThreadContext.StoredContext threadContext = this.client.threadPool().getThreadContext().stashContext();){
            ActionListener internalListener = ActionListener.runBefore(listener, () -> threadContext.restore());
            ActionListener al = ActionListener.wrap(searchResponse -> {
                LinkedList<ConversationMeta> result = new LinkedList<ConversationMeta>();
                for (SearchHit hit : searchResponse.getHits()) {
                    result.add(ConversationMeta.fromSearchHit((SearchHit)hit));
                }
                internalListener.onResponse(result);
            }, e -> {
                log.error("Failed to retrieve conversations", (Throwable)e);
                internalListener.onFailure(e);
            });
            this.client.admin().indices().refresh(Requests.refreshRequest((String[])new String[]{indexName}), ActionListener.wrap(refreshResponse -> this.client.search(request, al), e -> {
                log.error("Failed to retrieve conversations during refresh", (Throwable)e);
                internalListener.onFailure(e);
            }));
        }
        catch (Exception e2) {
            log.error("Failed to retrieve conversations", (Throwable)e2);
            listener.onFailure(e2);
        }
    }

    public void getConversations(int maxResults, ActionListener<List<ConversationMeta>> listener) {
        this.getConversations(0, maxResults, listener);
    }

    public void deleteConversation(String conversationId, ActionListener<Boolean> listener) {
        if (!this.clusterService.state().metadata().hasIndex(indexName)) {
            listener.onResponse((Object)true);
        }
        DeleteRequest delRequest = Requests.deleteRequest((String)indexName).id(conversationId);
        String userstr = (String)this.client.threadPool().getThreadContext().getTransient("_opendistro_security_user_info");
        String user = User.parse((String)userstr) == null ? "BAD_USER" : User.parse((String)userstr).getName();
        this.checkAccess(conversationId, (ActionListener<Boolean>)ActionListener.wrap(access -> {
            if (access.booleanValue()) {
                try (ThreadContext.StoredContext threadContext = this.client.threadPool().getThreadContext().stashContext();){
                    ActionListener internalListener = ActionListener.runBefore((ActionListener)listener, () -> threadContext.restore());
                    ActionListener al = ActionListener.wrap(deleteResponse -> {
                        if (deleteResponse.getResult() == DocWriteResponse.Result.DELETED) {
                            internalListener.onResponse((Object)true);
                        } else if (deleteResponse.status() == RestStatus.NOT_FOUND) {
                            internalListener.onResponse((Object)true);
                        } else {
                            internalListener.onResponse((Object)false);
                        }
                    }, e -> {
                        log.error("Failure deleting conversation " + conversationId, (Throwable)e);
                        internalListener.onFailure(e);
                    });
                    this.client.delete(delRequest, al);
                }
                catch (Exception e2) {
                    log.error("Failed deleting conversation with id=" + conversationId, (Throwable)e2);
                    listener.onFailure(e2);
                }
            } else {
                throw new OpenSearchSecurityException("User [" + user + "] does not have access to conversation " + conversationId, new Object[0]);
            }
        }, e -> listener.onFailure(e)));
    }

    public void checkAccess(String conversationId, ActionListener<Boolean> listener) {
        if (!this.clusterService.state().metadata().hasIndex(indexName)) {
            listener.onResponse((Object)true);
            return;
        }
        String userstr = (String)this.client.threadPool().getThreadContext().getTransient("_opendistro_security_user_info");
        try (ThreadContext.StoredContext threadContext = this.client.threadPool().getThreadContext().stashContext();){
            ActionListener internalListener = ActionListener.runBefore(listener, () -> threadContext.restore());
            GetRequest getRequest = Requests.getRequest((String)indexName).id(conversationId);
            ActionListener al = ActionListener.wrap(getResponse -> {
                if (!getResponse.isExists() || !getResponse.getId().equals(conversationId)) {
                    throw new ResourceNotFoundException("Conversation [" + conversationId + "] not found", new Object[0]);
                }
                if (userstr == null || User.parse((String)userstr) == null) {
                    internalListener.onResponse((Object)true);
                    return;
                }
                ConversationMeta conversation = ConversationMeta.fromMap((String)conversationId, (Map)getResponse.getSourceAsMap());
                String user = User.parse((String)userstr).getName();
                if (!user.equals(conversation.getUser())) {
                    internalListener.onResponse((Object)false);
                    return;
                }
                internalListener.onResponse((Object)true);
            }, e -> internalListener.onFailure(e));
            this.client.admin().indices().refresh(Requests.refreshRequest((String[])new String[]{indexName}), ActionListener.wrap(refreshResponse -> this.client.get(getRequest, al), e -> {
                log.error("Failed to refresh conversations index during check access ", (Throwable)e);
                internalListener.onFailure(e);
            }));
        }
        catch (Exception e2) {
            listener.onFailure(e2);
        }
    }

    @Generated
    public ConversationMetaIndex(Client client, ClusterService clusterService) {
        this.client = client;
        this.clusterService = clusterService;
    }
}

