/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ad.transport;

import java.io.IOException;
import java.util.List;
import java.util.Random;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.action.bulk.BulkAction;
import org.opensearch.action.bulk.BulkRequest;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.ad.model.AnomalyResult;
import org.opensearch.ad.ratelimit.ResultWriteRequest;
import org.opensearch.ad.settings.AnomalyDetectorSettings;
import org.opensearch.ad.transport.ADResultBulkAction;
import org.opensearch.ad.transport.ADResultBulkRequest;
import org.opensearch.ad.transport.ADResultBulkResponse;
import org.opensearch.ad.util.BulkUtil;
import org.opensearch.ad.util.RestHandlerUtils;
import org.opensearch.client.Client;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.unit.ByteSizeValue;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.index.IndexingPressure;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;

public class ADResultBulkTransportAction
extends HandledTransportAction<ADResultBulkRequest, ADResultBulkResponse> {
    private static final Logger LOG = LogManager.getLogger(ADResultBulkTransportAction.class);
    private IndexingPressure indexingPressure;
    private final long primaryAndCoordinatingLimits;
    private float softLimit;
    private float hardLimit;
    private String indexName;
    private Client client;
    private Random random;

    @Inject
    public ADResultBulkTransportAction(TransportService transportService, ActionFilters actionFilters, IndexingPressure indexingPressure, Settings settings, ClusterService clusterService, Client client) {
        super(ADResultBulkAction.NAME, transportService, actionFilters, ADResultBulkRequest::new, "same");
        this.indexingPressure = indexingPressure;
        this.primaryAndCoordinatingLimits = ((ByteSizeValue)IndexingPressure.MAX_INDEXING_BYTES.get(settings)).getBytes();
        this.softLimit = ((Float)AnomalyDetectorSettings.INDEX_PRESSURE_SOFT_LIMIT.get(settings)).floatValue();
        this.hardLimit = ((Float)AnomalyDetectorSettings.INDEX_PRESSURE_HARD_LIMIT.get(settings)).floatValue();
        this.indexName = ".opendistro-anomaly-results";
        this.client = client;
        clusterService.getClusterSettings().addSettingsUpdateConsumer(AnomalyDetectorSettings.INDEX_PRESSURE_SOFT_LIMIT, it -> {
            this.softLimit = it.floatValue();
        });
        clusterService.getClusterSettings().addSettingsUpdateConsumer(AnomalyDetectorSettings.INDEX_PRESSURE_HARD_LIMIT, it -> {
            this.hardLimit = it.floatValue();
        });
        this.random = new Random(42L);
    }

    protected void doExecute(Task task, ADResultBulkRequest request, ActionListener<ADResultBulkResponse> listener) {
        long totalBytes = this.indexingPressure.getCurrentCombinedCoordinatingAndPrimaryBytes() + this.indexingPressure.getCurrentReplicaBytes();
        float indexingPressurePercent = (float)totalBytes / (float)this.primaryAndCoordinatingLimits;
        List<ResultWriteRequest> results = request.getAnomalyResults();
        if (results == null || results.size() < 1) {
            listener.onResponse((Object)new ADResultBulkResponse());
        }
        BulkRequest bulkRequest = new BulkRequest();
        if (indexingPressurePercent <= this.softLimit) {
            for (ResultWriteRequest resultWriteRequest : results) {
                this.addResult(bulkRequest, resultWriteRequest.getResult(), resultWriteRequest.getResultIndex());
            }
        } else if (indexingPressurePercent <= this.hardLimit) {
            float acceptProbability = 1.0f - indexingPressurePercent;
            for (ResultWriteRequest resultWriteRequest : results) {
                AnomalyResult result = resultWriteRequest.getResult();
                if (!result.isHighPriority() && !(this.random.nextFloat() < acceptProbability)) continue;
                this.addResult(bulkRequest, result, resultWriteRequest.getResultIndex());
            }
        } else {
            for (ResultWriteRequest resultWriteRequest : results) {
                AnomalyResult result = resultWriteRequest.getResult();
                if (!result.isHighPriority()) continue;
                this.addResult(bulkRequest, result, resultWriteRequest.getResultIndex());
            }
        }
        if (bulkRequest.numberOfActions() > 0) {
            this.client.execute((ActionType)BulkAction.INSTANCE, (ActionRequest)bulkRequest, ActionListener.wrap(bulkResponse -> {
                List<IndexRequest> failedRequests = BulkUtil.getFailedIndexRequest(bulkRequest, bulkResponse);
                listener.onResponse((Object)new ADResultBulkResponse(failedRequests));
            }, e -> {
                LOG.error("Failed to bulk index AD result", (Throwable)e);
                listener.onFailure(e);
            }));
        } else {
            listener.onResponse((Object)new ADResultBulkResponse());
        }
    }

    private void addResult(BulkRequest bulkRequest, AnomalyResult result, String resultIndex) {
        String index = resultIndex == null ? this.indexName : resultIndex;
        try (XContentBuilder builder = XContentFactory.jsonBuilder();){
            IndexRequest indexRequest = new IndexRequest(index).source(result.toXContent(builder, (ToXContent.Params)RestHandlerUtils.XCONTENT_WITH_TYPE));
            bulkRequest.add(indexRequest);
        }
        catch (IOException e) {
            LOG.error("Failed to prepare bulk index request for index " + index, (Throwable)e);
        }
    }
}

